/* C Declarations                                          */
/*                                                         */
/* You MUST include the following three declarations in    */
/* your program.                                           */
/*                                                         */
/* Status variables defined by NI488.C			   */

extern  unsigned short int     ibsta;  /* status word                     */
extern  unsigned short int     iberr;  /* GPIB error code                 */
extern  unsigned short int     ibcnt;  /* number of bytes sent            */

/* Optionally include the following declarations in your   */
/* program.                                                */

/* GPIB Commands                                           */

#define UNL  0x3f  /* GPIB unlisten command                */
#define UNT  0x5f  /* GPIB untalk command                  */
#define GTL  0x01  /* GPIB go to local                     */
#define SDC  0x04  /* GPIB selected device clear           */
#define PPC  0x05  /* GPIB parallel poll configure         */
#define GET  0x08  /* GPIB group execute trigger           */
#define TCT  0x09  /* GPIB take control                    */
#define LLO  0x11  /* GPIB local lock out                  */
#define DCL  0x14  /* GPIB device clear                    */
#define PPU  0x15  /* GPIB parallel poll unconfigure       */
#define SPE  0x18  /* GPIB serial poll enable              */
#define SPD  0x19  /* GPIB serial poll disable             */
#define PPE  0x60  /* GPIB parallel poll enable            */
#define PPD  0x70  /* GPIB parallel poll disable           */

/* GPIB status bit vector :                                */
/*       global variable ibsta and wait mask               */

#define ERR     (1<<15) /* Error detected                  */
#define TIMO    (1<<14) /* Timeout                         */
#define END     (1<<13) /* EOI or EOS detected             */
#define SRQI    (1<<12) /* SRQ detected by CIC             */
#define CMPL    (1<<8)  /* I/O completed                   */
#define LOK     (1<<7)  /* Local lockout state             */
#define REM     (1<<6)  /* Remote state                    */
#define CIC     (1<<5)  /* Controller-in-Charge            */
#define ATN     (1<<4)  /* Attention asserted              */
#define TACS    (1<<3)  /* Talker active                   */
#define LACS    (1<<2)  /* Listener active                 */
#define DTAS    (1<<1)  /* Device trigger state            */
#define DCAS    (1<<0)  /* Device clear state              */

/* Error messages returned in global variable iberr        */

#define EDVR  0  /* DOS error                              */
#define ECIC  1  /* Function requires GPIB board to be CIC */
#define ENOL  2  /* Write function detected no listeners   */
#define EADR  3  /* Interface board not addressed correctly*/
#define EARG  4  /* Invalid argument to function call      */
#define ESAC  5  /* Function requires GPIB board to be SAC */
#define EABO  6  /* I/O operation aborted                  */
#define ENEB  7  /* Non-existent interface board           */
#define EOIP 10  /* I/O operation started before previous  */
		 /* operation completed                    */
#define ECAP 11  /* No capability for intended operation   */
#define EFSO 12  /* File system operation error            */
#define EBUS 14  /* Command error during device call       */
#define ESTB 15  /* Serial poll status byte lost           */
#define ESRQ 16  /* SRQ remains asserted                   */

/* EOS mode bits                                           */

#define BIN  (1<<12) /* Eight bit compare                  */
#define XEOS (1<<11) /* Send EOI with EOS byte             */
#define REOS (1<<10) /* Terminate read on EOS              */

/* Timeout values and meanings                             */

#define TNONE    0   /* Infinite timeout (disabled)        */
#define T10us    1   /* Timeout of 10 us (ideal)           */
#define T30us    2   /* Timeout of 30 us (ideal)           */
#define T100us   3   /* Timeout of 100 us (ideal)          */
#define T300us   4   /* Timeout of 300 us (ideal)          */
#define T1ms     5   /* Timeout of 1 ms (ideal)            */
#define T3ms     6   /* Timeout of 3 ms (ideal)            */
#define T10ms    7   /* Timeout of 10 ms (ideal)           */
#define T30ms    8   /* Timeout of 30 ms (ideal)           */
#define T100ms   9   /* Timeout of 100 ms (ideal)          */
#define T300ms  10   /* Timeout of 300 ms (ideal)          */
#define T1s     11   /* Timeout of 1 s (ideal)             */
#define T3s     12   /* Timeout of 3 s (ideal)             */
#define T10s    13   /* Timeout of 10 s (ideal)            */
#define T30s    14   /* Timeout of 30 s (ideal)            */
#define T100s   15   /* Timeout of 100 s (ideal)           */
#define T300s   16   /* Timeout of 300 s (ideal)           */
#define T1000s  17   /* Timeout of 1000 s (maximum)        */

/* Miscellaneous                                           */

#define S    0x08    /* parallel poll sense bit            */
#define LF   0x0a    /* ASCII linefeed character           */

/* You MUST include the appropriate extern declaration, as  given below, for */
/* each procedure or function you call. 				     */
/*									     */
/* The GPIB board functions:						     */

   extern pascal  ibbna  (int,char *);

   extern pascal  ibcac  (int,int);
		
   extern pascal  ibclr  (int);

   extern pascal  ibcmd  (int,char *,int);

   extern pascal  ibcmda (int,char *,int);

   extern pascal  ibdma  (int,int);

   extern pascal  ibeos  (int,int);
	
   extern pascal  ibeot  (int,int);
	
   extern pascal  ibfind (char *);

   extern pascal  ibgts  (int,int);
			
   extern pascal  ibist  (int,int);
			
   extern pascal  ibloc  (int);

   extern pascal  ibonl  (int,int);
		
   extern pascal  ibpad  (int,int);
		
   extern pascal  ibpct  (int);

   extern pascal  ibppc  (int,int);
	
   extern pascal  ibrd	 (int,char *,int);

   extern pascal  ibrda  (int,char *,int);

   extern pascal  ibrdf  (int,char *);
		
   extern pascal  ibrpp  (int,int *);

   extern pascal  ibrsc  (int,int);
			
   extern pascal  ibrsp  (int,int *);
			
   extern pascal  ibrsv  (int,int);
		
   extern pascal  ibsad  (int,int);
		
   extern pascal  ibsic  (int);

   extern pascal  ibsre  (int,int);
		
   extern pascal  ibstop (int);

   extern pascal  ibtmo  (int,int);
		
   extern pascal  ibtrg  (int);

   extern pascal  ibwait (int,int);
			
   extern pascal  ibwrt  (int,char *,int);

   extern pascal  ibwrta (int,char *,int);

   extern pascal  ibwrtf (int,char *);



