(************ Microsoft Pascal NI Example Program - Device Level **************)

(* This sample program is for reference only. It can only be expected to *)
(* function with a Fluke 8840 Digital Multimeter that has been properly  *)
(* configured in IBCONF.						 *)


program main (input,output);

{$include: 'nicode.pas'}
{$include: 'os2def.int'}
{$include: 'bsedos.int'}


var
	bdname		       : array [1..8] of char;	(* device name	     *)
	action		       : word;			(* placeholder	     *)
	RetCode 	       : word;			(* return code	     *)
	dvm		       : word;			(* device handle     *)
	cnt		       : word;			(* count	     *)
	mask		       : integer;		(* WAIT mask	     *)
	spr		       : char;			(* serial poll response *)
	NulAddr 	       : adsmem;		(* placeholder	     *)
	wrt, rd 	       : array [1..20] of char; (* I/O buffers	     *)

(*****************************************************************************)
(* This routine would notify you that the DosOpen call failed, and refer you *)
(* to the driver software configuration procedures.                          *)
(*****************************************************************************)

procedure finderr;

begin
  writeln (' Find error');
end;

(*****************************************************************************)
(* This routine would, among other things, check RetCode to determine the    *)
(* exact cause of the error condition & then take action appropriate to the  *)
(* application. 							     *)
(*****************************************************************************)

procedure error;

begin
  writeln (' Error');
end;

(*****************************************************************************)
begin

(* Assign a unique identifier to the device 'DVM' ("digital voltmeter")      *)

	bdname[1] := 'D';
	bdname[2] := 'V';
	bdname[3] := 'M';
	RetCode := DosOpen(	ads(bdname),		       (* path	 *)
				dvm,			       (* handle *)
				action, 		       (* action *)
				0,			       (* size	 *)
				RdOnly, 		       (* attrs  *)
				OpenTrunc,		       (* flag	 *)
				RdWrDN, 		       (* mode	 *)
				0);			       (* zero	 *)
	if (RetCode <> 0) then finderr;

(* Clear the device:                                                         *)

	NulAddr.s := 0;
	NulAddr.r := 0;
	RetCode := DosDevIOCtl(NulAddr, NulAddr, DCLEAR, CATEGORY, dvm);

(* Check for an error on each GPIB call to be safe...                        *)

	if (RetCode <> 0) then error;

(* Write the function, range, and trigger source instructions to the DVM.    *)
(* This string is meaningful to the Fluke 8840 Digital Multimeter.	     *)

	wrt[1] := 'F';
	wrt[2] := '3';
	wrt[3] := 'R';
	wrt[4] := '7';
	wrt[5] := 'T';
	wrt[6] := '3';
	RetCode := DosWrite(dvm, ads(wrt), 6, cnt);
	if (RetCode <> 0) then error;

(* Trigger the device:                                                       *)

	RetCode := DosDevIOCtl(NulAddr, NulAddr, TRIGGER, CATEGORY, dvm);
	if (RetCode <> 0) then error;

(* Wait for the DVM to set SRQ (hex 800) or for a timeout (hex 40).	     *)
(* Descriptions of these status bits are listed in NICODE.PAS.	If the	     *)
(* current time limit is too short, use DTempWrt to change it.		     *)

	mask := BTIMO OR BSRQ;
	RetCode := DosDevIOCtl(NulAddr, ads(mask), BWAIT, CATEGORY, dvm);
	if (RetCode <> 0) then error;


(* Next do a serial poll of the device: 				     *)

	RetCode := DosDevIOCtl(NulAddr, ads(spr), SPOLL, CATEGORY, dvm);
	if (RetCode <> 0) then error;

(* Now check the status byte. If it is 16#C0, the DVM has valid data to send *)
(* otherwise it has a fault condition to report.                             *)

	if (spr <> chr(16#C0)) then error;

(* If the data is valid, then read the measurement:                          *)

	RetCode := DosRead(dvm, ads(rd), 16, cnt);
	if (RetCode <> 0) then error;

(* To close out a programming sequence, call the ONLINE function to disable  *)
(* the hardware and software:						     *)

	RetCode := DosDevIOCtl(NulAddr, NulAddr, ONLINE, CATEGORY, dvm);
end.
