/***********
 *
 * ni488.c - function definitions for NI488 calls
 *
 * 	Copyright (c) 1988,1989,1990,1991 National Instruments
 *		All rights reserved.
 *
 * Purpose:
 *	This file contains C function definitions for NI488
 *      call compatibility with National Instrument's
 *	Version 1.3 Device Drivers for the OS/2 Operating System.
 *
 ************/

/* WARNING
 * If ni488.c (this file) is included in a C program which manipulates
 * files, ensure that the following include statements are not duplicated
 * in the C program.
 */
#define INCL_DOSMEMMGR
#define INCL_DOSFILEMGR
#define INCL_DOSDEVICES
#include <os2.h>

#include <fcntl.h>		/* define C open options */
#include <sys\types.h>		/* define types used by C system level calls */
#include <sys\stat.h>		/* define C owner permission */
#include "nictl.h"
#include "nicode.h"


typedef long NISEM;		/* OS/2 Semaphore */
typedef NISEM far * PNISEM;	/* OS/2 Semaphore Handle */

typedef union NIINT32 {
		struct {  USHORT offset;
			  SEL selector; } virt;
		PUSHORT ptr;
} NIINT32;


#define MAXFT	20
#define MAXBUF  2048
#define ni_MSKE 0xFF		/* nictl return code mask */

#define ni_ERR	0x8000
#define ni_EARG	4
#define ni_ENEB 7
#define ni_EDVR	9
#define ni_ECAP	11
#define ni_EFSO	12
#define ni_ETMW 17

#define OpReadFile	0x01
#define OpArcFile	0x20
#define OpOpenFile	0x01
#define OpReplace 	0x02
#define OpCreate	0x10
#define OpPrivate	0x80
#define OpSyncWrite	0x4000
#define OpNoBoxOnErr	0x2000
#define OpDenyNone	0x40
#define OpDenyWrite	0x20
#define OpRdWrt		0x02
#define OpRdOnly	0x00

#define ni_errck if (ibsta & ni_ERR) return
#define NoError (ibsta & ni_ERR) == 0

typedef struct dsc_n_typ {
	int dsc;
	int typ;
} dsc_n_typ;



int iberr=0;
int ibsta=0;
unsigned int ibcnt=0;
long nitmo;

static USHORT ibdos;		/* OS2 driver return code */
static unsigned long ibbs;/*address into which return status and
                            count gets stored. */
static int  lastv;		/* last value of parameter v */
static nidev ddef;		/* device parameters - see nicode.h */
static nibrd bdef;		/* board parameters - see nicode.h */
static int ni_mask;
static NISEM ibsem;		/* ni488 asynchronous semaphore */
static lst_rsv = 0;		/* last value of parameter passed to ibrsv */
static dsc_n_typ fts[MAXFT] = { -1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0 };

/*
 * convert upper case letter to lower case
 */
static char UpToLow(c)
char c;
{
	return ((c > 'a') ? c : c - 'A'+ 'a');
}
/*
 * is this a device or board handle?
 *   parameter:  device or board handle
 */

static int d_or_b(fh)
{
	int i;

	/* look for handle in handle-type table */
	for (i=0;i < MAXFT; i++)  {
		if (fh == fts[i].dsc)
			return fts[i].typ;
	}

	/* can't find handle in table */
	iberr = ni_EARG;
	ibsta = ni_ERR;
	return -1;
}

/*
 * switch OS/2 board status to ni-style board ibsta
 */

swibsta(bs,err)
{
	ibsta = ( ((err) ? (1<<15) : (1<<8)) |
		((bs & BIODONE) << 8) |
		((bs & BEND) << 9) |
		((bs & BTIMO) << 8) |
		((bs & BDTAS) >> 6) |
		((bs & BDCAS) >> 8) |
		((bs & BTA) >> 6)   |
		((bs & BLA) >> 8)   |
		((bs & BSRQ) << 1)  |
		((bs & BREM) >> 6)  |
		((bs & BLOK) >> 6)  |
		((bs & BATN) >> 10)  |
		((bs & BCIC) >> 10) );
}

/*
 * calculate ibsta & iberr for device calls 
 *   parameter:  device handle
 */

static dstat(d)
{
   unsigned int status;

	iberr = nictl(d,IBSTATUS,  &ibbs,0);
	if (iberr)
		iberr &= 0xFE;		/* device error in low byte */
   status = (unsigned int) ibbs;
   ibcnt = (unsigned int) (ibbs >> 16 );

	ibsta = ( ((iberr) ? (1<<15) : (1<<8)) |
		((status & BIODONE) << 8) |
		((status & BEND) << 9) |
		((status & BTIMO) << 8));
	return ibsta;
}

/*
 * calculate ibsta & iberr for board calls
 *   parameter:  board handle
 */

static bstat(b)
{
   unsigned int status;

	iberr = nictl(b,IBSTATUS, &ibbs,0);
	if (iberr)
		iberr &= 0xFF;		/* device error in low byte */
   status = (unsigned int) ibbs;
   ibcnt = (unsigned int) (ibbs >> 16);

	swibsta(status,iberr);

	if (iberr == ni_EDVR)   {
		iberr = 0;
		ibcnt = ibdos;
	}
	return ibsta;
}

/*
 * modify device or board flags (flags are defined in nicode.h)
 *   parameters: pointer to flag
 *		 bit mask
 *		 bit replacement mask
 */

static chgflg(fptr,mask,value)
int * fptr;
{
	lastv = *fptr & mask;
	*fptr = (*fptr & ~mask) | (mask & value);
}

/*
 * configure board parameter
 *   parameters: board handle
 *		 pointer to board parameter
 *		 new value of board parameter
 */

static chgbrd(b,chg,v)
int * chg;
{
	if (nictl(b,BTempRd,&bdef,0) == 0) {
		lastv = *chg;
		*chg = v;
		nictl(b,BTempWrt,&bdef,0);
	}
	bstat(b);
}


/*
 * configure device parameter
 *   parameters: device handle
 *		 pointer to device parameter
 *		 new value of device parameter
 */

static chgdev(d,chg,v)
int * chg;
{
	if (nictl(d,DTempRd,&ddef,0) == 0) {
		lastv = *chg;
		*chg = v;
		nictl(d,DTempWrt,&ddef,0);
	}
	dstat(d);
}

int   ibbna(d,s)
char * s;
{
	int b;

	if ((UpToLow(*s++) == 'g') &&
	    (UpToLow(*s++) == 'p') &&
	    (UpToLow(*s++) == 'i') &&
	    (UpToLow(*s++) == 'b') &&
	    ((*s == '0') || (*s == '1'))) {
	    if (*s == '0')
		b = 0;
	    else
		b = 1;
	    chgdev(d,&(ddef.brdno),b);
	    dstat(d);
	}
	else {
		iberr = ni_EARG;
		ibsta = ni_ERR;
	}
	return ibsta;
}

int   ibcac(b,v)
{
	nictl(b,ATNON,0,0);	/* set ATN line */
	return bstat(b);
}

int  ibclr(d)
{
	nictl(d,DCLEAR,0,0);
	return dstat(d);
}

int   ibcmd(b,cmd,cnt)
int * cmd;
{
	ibcnt = cnt;
	nictl(b,CMD,&ibcnt,cmd);
	bstat(b);
	return ibsta;
}

int     ibcmda(b,cmd,cnt)
int * cmd;
{
	return ibcmd(b,cmd,cnt);	/* all board level nictl functions
					 * are synchronous
					 */
}

int     ibdma(db,v)
{
	int typ;
	USHORT rc;

	if ((typ = d_or_b(db)) < 0)  
		return ibsta;

	if (typ){				/* device type */
		if (nictl(db,DTempRd,&ddef,0)==0) {
			chgflg(&(ddef.uflags),UDMA,(v ? UDMA : 0));
			nictl(db,DTempWrt,&ddef,0);
		}
		dstat(db);
	}
	else { 					/* board type */
		if ((rc = nictl(db,BTempRd,&bdef,0))==0) {
			chgflg(&(bdef.uflags),UDMA,(v ? UDMA : 0));
			rc = nictl(db,BTempWrt,&bdef,0);
		}
		bstat(db);
	}
	if (!(iberr)) iberr = (lastv & UDMA) ? 1 : 0;
	return ibsta;
}

int     ibeot(db,v)
{
	int typ;

	if ((typ = d_or_b(db)) < 0)
		return ibsta;

	if (typ) {				/* device type */
		if (nictl(db,DTempRd,&ddef,0) == 0) {
			chgflg(&(ddef.uflags),UEOT, (v ? UEOT : 0));
			nictl(db,DTempWrt,&ddef,0);
		}
		dstat(db);
	}
	else   {				/* board type */
		if (nictl(db,BTempRd,&bdef,0) == 0) {
			chgflg(&(bdef.uflags),UEOT, (v ? UEOT : 0));
			nictl(db,BTempWrt,&bdef,0);
		}
		bstat(db);
	}
	if (!(iberr)) iberr = (lastv ? 1 : 0);
	return ibsta;
}

int     ibeos(db,v)
{
	int mklast=0;
	USHORT lastvs;
	int typ;
	int eosm = (UREOS | UWEOS | UCMP8);

	if ((typ = d_or_b(db)) < 0)
		return ibsta;

	if (v & 0xE300) {
		iberr = ni_EARG;
		ibsta |= ni_ERR;
		return ibsta;
	}

	if (typ){					/* device type */
		if (nictl(db,DTempRd,&ddef,0) == 0) {
			lastvs = ((ddef.uflags & eosm) << 8) | (char) ddef.eos;
			chgflg(&(ddef.uflags), eosm, (v >> 8));
			ddef.eos = (char) v;
			nictl(db,DTempWrt,&ddef,0);
		}
		dstat(db);
	}
	else{ 						/* board type */
		if (nictl(db,BTempRd,&bdef,0) == 0) {
			lastvs = ((bdef.uflags & eosm) << 8) | (char) bdef.eos;
			chgflg(&(bdef.uflags), eosm, (v >> 8));
			bdef.eos = (char) v;
			nictl(db,BTempWrt,&bdef,0);
		}
		bstat(db);
	}
	if (!(iberr)) iberr = lastvs;
	return ibsta;
}

int     ibfind(s)
char * s;
{
	HFILE dsc;
	int typ;
	int i;
	USHORT action;
	int AddBrdOK;
	char dc;
      
	if ((iberr = DosOpen((PCH) s, (PHFILE) &dsc, (PINT) &action,
			0L,			/* file's new size */
			OpReadFile,
			OpReplace,
			OpPrivate|OpSyncWrite|OpNoBoxOnErr|OpDenyNone|OpRdWrt,
			0L))
				== 0)    {
		     iberr=nictl(dsc,PRESENT,&AddBrdOK,0);
		     if (iberr)
			     iberr = ni_EARG;
		     else if (!AddBrdOK) {
			     iberr = ni_ENEB;
			     DosClose(dsc);
		     }
		     else {
		    	if ((UpToLow(*s++) == 'g') && 
			      (UpToLow(*s++) == 'p') &&
			      (UpToLow(*s++) == 'i') &&
			      (UpToLow(*s++) == 'b') &&
			      ((*s == '0') || (*s == '1')))
				typ = 0;
			   else {
				  typ = 1;
            } 

			   for (i=0; i < MAXFT; i++) {
				   if (fts[i].dsc < 0) {
					   fts[i].dsc = dsc;
					   fts[i].typ = typ;
					   break;
				   }
			   }
			   if (typ)
				   dstat(dsc) ;
			   else
				   bstat(dsc);
			   iberr = 0;
		    }
		    if (iberr) dsc = -1;
		}
	   else {
       /* Special Case: in the case of a device not being connected
        * to a board an error code of 26 is returned. report ENEB in
        * such cases
        */
         if (iberr == 26) {
            iberr= ni_ENEB;
            dsc = -1;
         }
         else {
		      ibcnt = iberr;
		      iberr = 0;
		      dsc = -1;
         }
	}		           
	return dsc;
}

int     ibgts(b,v)
{
	int count;

	if (v)
		nictl(b,0x86,0,0);
	else {
		count = 1;
		nictl(b,CMD,&count,"?");
		if (count == 1)
			nictl(b,ATNOFF,0,0);	/* clear ATN line */
	}
	return bstat(b);
}

int     ibist(b,v)
{
	USHORT lv;

	if (nictl(b,BTempRd,&bdef,0)==0) {
		chgflg(&(bdef.uflags), UIST, (v ? UIST : 0));
		if (nictl(b,BTempWrt,&bdef,0)==0) {
		    lv = v;
		    nictl(b,PPOLLIST,&lv,0);
		}
	}
	bstat(b);
	if (!(iberr)) iberr = (lastv) ? 1 : 0;
	return ibsta;
}

int     ibloc(db)
{
	int typ;

	if ((typ = d_or_b(db)) < 0)
		return ibsta;

	if (typ) {
		nictl(db,DLOCAL,0,0);
		return dstat(db);
	}
	else {
		nictl(db,BLOCAL,0,0);
		return bstat(db);
	}
}

int     ibonl(db,v)
{
	int typ;

	if ((typ = d_or_b(db)) < 0)
		return ibsta;

	if (typ){					/* device type */
		if (nictl(db,DConfRd,&ddef,0) == 0)
			nictl(db,DTempWrt,&ddef,0);
		return dstat(db);
	}
	else{ 						/* board type */
		nictl(db,(v ? ONLINE : OFFLINE),0,0);
		return bstat(db);
	}
}

int     ibpad(db,v)
{
	int typ;

	if ((typ = d_or_b(db)) < 0)
		return ibsta;

	if (typ)	/* device type */
		chgdev(db,&(ddef.pad),v);
	else 			/* board type */
		chgbrd(db,&(bdef.pad),v);
	if (!(iberr)) iberr = lastv;
	return ibsta;
}

int     ibppc(db,v)	
{
	int typ;
	USHORT lv;

	
	if ((typ = d_or_b(db)) < 0)
		return ibsta;

	lv = v;
	nictl(db,PPOLLCONF,&lv,0);

	if (typ) 			/* device type */
		dstat(db);
	else				/* board type */
		bstat(db);

	/* iberr doesn't contain the last value of v */

	return ibsta;
}

int     ibpct(d)
{
	nictl(d,PASSCONTROL,0,0);
	return dstat(d);
}

int     ibrd(db,rd,cnt)
int * rd;
{
 	ibdos = DosRead(db,(PINT) rd, cnt, (PINT) &ibcnt);
	return bstat(db);
}

int     ibrda(db,rd,cnt)
int * rd;
{
	return ibrd(db,rd,cnt);
}

int OpnBrd(name)
char * name;
{
	HFILE brd;
	int action;

	iberr = DosOpen((PCH) name, (PHFILE) &brd, (PINT) &action,
			0L,			/* file's new size */
			OpReadFile,
			OpReplace,
			OpPrivate|OpSyncWrite|OpNoBoxOnErr|OpDenyNone|OpRdWrt,
			0L);
	if (iberr) {
		brd = -1;
	        ibcnt = iberr;
	        ibsta = ni_ERR;
	        iberr = ni_EFSO;
	}
	return brd;
}

/* WARNING: ibrdf may not complete successfully if another application
 * simultaneously accesses the same board or attached devices.
 */
int     ibrdf(db,flname)
char * flname;
{
	HFILE fh;			/* file handle */
	USHORT action;			/* DosOpen ActionTaken */
	int bh;				/* board handle */
	int lasteot;			/* save device eot */
	int wcount;			/* file write count */
	USHORT tc;			/* total read count */
	NIINT32 p;

   unsigned int status;

	tc = 0;
	p.ptr = 0L;
	if (ibdos = DosAllocSeg(MAXBUF,(PSEL) &p.virt.selector,3)) {
		ibcnt = ibdos;
		ibsta = ni_ERR;
		iberr = ni_EDVR;
		return ibsta;
	}
	 
	if (ibdos = DosOpen((PCH) flname, (PHFILE) &fh, (PINT) &action,
			  0L,		/* file's new size */
			  OpArcFile,
			  OpReplace|OpCreate,
			  OpPrivate|OpSyncWrite|OpNoBoxOnErr|OpDenyWrite|OpRdWrt,
			  0L)  ) {
		ibcnt = ibdos;
		ibsta |= ni_ERR;
		iberr = ni_EFSO;
		return ibsta;
	}

	/* if this is a device handle, the first file block is transfered
	 * using a device handle and subsequent blocks are transfered using
         * a board handle (no addressing between file blocks)
         */
	bh = db;
	if ((nictl(db,DTempRd,&ddef,0))==0) {  /* is this a device? */
	   if ((ddef.uflags & UNAD) == 0) {
	      if (ddef.brdno)			  /* yes */
		bh = OpnBrd("GPIB1");
	      else
		bh = OpnBrd("GPIB0");
	      if (bh == -1) {
		DosClose(fh);
	        return ibsta;
	      }
	   }
	}

	ibdos = 0;
	ibbs=0;
	ibdos = DosRead(db,p.ptr,MAXBUF, (PINT) &wcount);
	ibsta = bstat(db);
	while (wcount && (!ibdos)) {
	   if ((ibdos = DosWrite(fh,p.ptr, wcount, (PINT) &ibcnt)) == 0)
	      tc += ibcnt;
	   wcount = 0;
      status = (unsigned int) ibbs;
	   if ((!ibdos) && ((status & BEND) == 0))  {
	      ibdos = DosRead(bh,p.ptr,MAXBUF, (PINT) &wcount);
	      ibsta = bstat(db);
	   }
	}
	/* mop up
	 */
	if (bh != db) 
	   DosClose(bh);
	ibcnt = tc;
	DosClose(fh);
	DosFreeSeg(p.virt.selector);
	return ibsta;
}

int     ibrpp(db,ppr)
int * ppr;
{
	int typ;

	if ((typ = d_or_b(db)) < 0)
		return ibsta;

	nictl(db,PPOLL,ppr,0);

	if (typ)			/* device type */
		dstat(db);
	else				/* board type */
		bstat(db);
}

int     ibrsc(b,v)
{
	if (nictl(b,BTempRd,&bdef,0)==0) {
		chgflg(&(bdef.uflags), USC, (v ? USC : 0));
		nictl(b,BTempWrt,&bdef,0);
	}
	bstat(b);
	if (!(iberr)) iberr = (lastv) ? 1 : 0;
	return ibsta;
}

int     ibrsp(d,spr)
int * spr;
{
	nictl(d,SPOLL,spr,0);
	return dstat(d);
}

int     ibrsv(b,v)
{
	USHORT lv;

	/* change serial poll status byte */
	lv = v & 0xBF;
	nictl(b,SPOLLBYTE,&lv, 0);
	/* clear request service */
	if (v & 0x40)
		nictl(b,REQUEST,0,0);
	bstat(b);
	if (!(iberr)) {
		iberr = lst_rsv;
		lst_rsv = v;
	}
	return ibsta;
}

int     ibsad(db,v)
{
	int typ;

	if ((typ = d_or_b(db)) < 0)
		return ibsta;

	if (typ)	/* device type */
		chgdev(db,&(ddef.sad),v);
	else 			/* board type */
		chgbrd(db,&(bdef.sad),v);
	if (!(iberr)) iberr = lastv;
	return ibsta;
}

int     ibsic(b)
{
	nictl(b,SENDIFC,0,0);
	return bstat(b);
}

int     ibsre(b,v)
 {

	if (nictl(b,BTempRd,&bdef,0)==0) {
		chgflg(&(bdef.uflags), USRE, (v ? USRE : 0));
		if (nictl(b,BTempWrt,&bdef,0)==0)
		    nictl(b,(v ? SETREMOTE : CLRREMOTE),0,0);
	}
	bstat(b);
	if (!(iberr)) iberr = (lastv) ? 1 : 0;
	return ibsta;
}

int     ibstop(db)
{
	/* not supported at this time */
}

int     ibtmo(db,v)
{
	int io,typ;
	long timeout;

	if ((typ = d_or_b(db)) < 0)
		return ibsta;

	if (typ)			/* device type */
		io = nictl(db,DTempRd,&ddef,0);
	else 				/* board type */
		io = nictl(db,BTempRd,&bdef,0);

	if (io == 0) {
      timeout = v;
	   switch (v)
		{
		   case 0: timeout = -1; break;
		   case 1: case 2: case 3: case 4: case 5:
			   timeout = 1;      break;
		   case 6: timeout = 6;      break;
		   case 7: timeout = 7;     break;
		   case 8: timeout = 30;     break;
 		   case 9: timeout = 100;    break;
		   case 10:timeout = 300;    break;
		   case 11:timeout = 1000;   break;
		   case 12:timeout = 3000;   break;
		   case 13:timeout = 10000;  break;
		   case 14:timeout = 30000;  break;
		   case 15:timeout = 100000; break;
		   case 16:timeout = 300000; break;
		   case 17:timeout = 1000000;break;
		   default:   
			if (typ)
				dstat(db);
			else
				bstat(db);
			ibsta = ni_ERR;
			iberr = ni_EARG;
			return ibsta;
			break;
		}
		if (typ){
			nitmo = ddef.timo;
			ddef.timo = timeout;
			nictl(db,DTempWrt,&ddef,0);
			dstat(db);
		}
		else{
			nitmo = bdef.timo;
			bdef.timo = timeout;
			nictl(db,BTempWrt,&bdef,0);
			bstat(db);
		}
	}
	return ibsta;
}

int     ibtrg(d)
{
	nictl(d,TRIGGER,0,0);
	return dstat(d);
}

/*
 * 
 * Semaphore warning: ibwait uses a RAM semaphore. 
 */

int     ibwait(db,mask)
{
	USHORT rc;			/* return code on calls */

	/* convert the mask from ni-style to OS/2 */
	ni_mask = (((mask & (1<<8)) >> 8) |	/* CMPL */
		((mask & (1<<13)) >> 9) |	/* END */
		((mask & (1<<14)) >> 8)  |	/* TIMO */
		((mask & (1<<1)) << 6)   |	/* DTAS */
		((mask & (1<<0)) << 8)   |	/* DCAS */
		((mask & (1<<3)) << 6)   |	/* TACS */
		((mask & (1<<2)) << 8)   | 	/* LACS */
		((mask & (1<<12)) >> 1)  |	/* SRQ */
		((mask & (1<<6)) << 6)   |	/* REM */
		((mask & (1<<7)) << 6)   |	/* LOK */
		((mask & (1<<4)) << 10)   |	/* ATN */
		((mask & (1<<5)) << 10) );	/* CIC */


	rc = nictl(db,BWAIT,&ni_mask,0L);

	/* calculate ni-style globals */
	iberr = (rc & ni_MSKE);
	swibsta(ni_mask,iberr);

	return ibsta;
}

int     ibwrt(db,wrt,cnt)
int * wrt;
{
 	ibdos = DosWrite(db,(PINT) wrt, cnt, (PINT) &ibcnt);
	return bstat(db);
}

/*
 * The OS/2 driver only provides synchronous operation.  Asynchronous
 * operations are achieved using the OS/2 Asynchronous I/O calls.  This
 * version of ibwrta performs an asynchronous write call, but then
 * waits for write completion.
 *
 * This code exactly follows the sequence of calls defined in the
 * OS/2 Technical Reference, Vol. 2, under the heading, DosWriteAsync.
 * IF THIS FUNCTION IS MODIFIED, WARNING: a program must not modify
 * the contents of the write buffer or look at the values returned in
 * ibdos or ibcnt until the semaphore is cleared.
 *
 * Semaphore warning: ibwrta uses a RAM semaphore. The handle for a 
 *   RAM semaphore is the far address of the semaphore storage location.
 *
 */

int     ibwrta(db,wrt,cnt)
int * wrt;
{
	ibdos = DosSemSet((PNISEM) &ibsem);
	if (!(ibdos))    {
	   DosWriteAsync( db,
			(PNISEM) &ibsem,
			(PINT) &ibdos,
			(PCH) wrt,
			cnt,
			(PINT) &ibcnt
			);
	   DosSemWait((PNISEM) &ibsem, (long) -1);
	}
	return bstat(db);
}

/* WARNING: ibwrtf may not complete successfully if another application
 * simultaneously accesses the same board or attached devices.
 */
int     ibwrtf(db,flname)
char * flname;
{
	HFILE fh;			/* file handle */
	USHORT action;			/* DosOpen ActionTaken */
	int bh;				/* board handle */
	int ch;				/* current handle */
	FILESTATUS fib;			/* file information block */
	int lasteot;			/* save db eot */
	int blasteot;			/* save board eot */
	USHORT rcount;			/* file read count */
	USHORT tc;			/* total write count */
	PINT membuf;			/* file I/O buffer */
	NIINT32 p;
	int savsta=0;
	int saverr;
	
	tc = 0;
	p.ptr = 0L;
	if (ibdos = DosAllocSeg(MAXBUF,(PSEL) &p.virt.selector,0)) {
		ibcnt = ibdos;
		ibsta = ni_ERR;
		iberr = ni_EDVR;
		return ibsta;
	}
	else
		membuf = p.ptr;
	 
	if (ibdos = DosOpen((PCH) flname, (PHFILE) &fh, (PINT) &action,
			  0L,		/* file's new size */
			  OpArcFile,
			  OpOpenFile,
			  OpPrivate|OpNoBoxOnErr|OpDenyWrite|OpRdOnly,
			  0L)  ) {
		ibcnt = ibdos;
		ibsta = ni_ERR;
		iberr = ni_EFSO;
		return ibsta;
	}
	/* get the length of the file */
	DosQFileInfo(fh,1,(FILESTATUS far *) &fib, sizeof(fib));

	/* if this is a device handle, the first file block is transfered
	 * using a device handle and subsequent blocks are transfered using
         * a board handle (no addressing between file blocks)
         */
	bh = ch = db;
	ibeot(db,0);			/* disable end on db write */
	if (NoError) {
	   lasteot = lastv;
	   if ((nictl(db,DTempRd,&ddef,0))==0) {  /* is this a device? */
	      if ((ddef.uflags & UNAD) == 0) {	/* yes - */
	         if (ddef.brdno)
	            bh = ibfind("GPIB1");
	         else
	            bh = ibfind("GPIB0");
	         if (bh == -1) {
	            ibcnt = ibdos;
	            ibsta = ni_ERR;
	            iberr = ni_EFSO;
	         }
	         else {
	            /* disable end on board write */
		    ibeot(bh,0);
	            blasteot = iberr;
		    if (!(NoError)) {
	               savsta = ibsta;
	               saverr = iberr;
	            }
	         }
	      }
	   }
	   if (/* Still */ NoError) {

	      ibdos = 0;
	      while ((fib.cbFile != 0L) && (!ibdos)) {
	         ibdos = DosRead(fh,membuf,MAXBUF,(PINT) &rcount);
	         if (!ibdos) {
	            if ((fib.cbFile -= rcount) == 0L)
	               ibsta = ibeot(ch,1);
	            if ((ibdos = DosWrite(ch,membuf, rcount, (PINT) &ibcnt)) == 0)
	               tc += ibcnt;
		 }
		bstat(db);
	        ch = bh;
	      }
 	      /* mop up
	       */
	      savsta = ibsta;
	      saverr = iberr;
	      if (bh != db) {
	         ibeot(bh,blasteot);
		 DosClose(bh);
	      }
	   } /* Still NoError */
	   ibeot(db,lasteot);

	   if (savsta) {
	      ibsta = savsta;
	      iberr = saverr;
	   }
	} /* NoError */
	ibcnt = tc;
	DosClose(fh);
	DosFreeSeg(p.virt.selector);
	return ibsta;
}




