/***********
 *
 * nicode.h - definitions for National Instruments OS/2 GPIB
 *	     Device Control Functions
 *
 *	Copyright 1988,1989, 1990, 1991 National Instruments Corporation.
 *	      All rights reserved.
 *
 * Purpose:
 *	This file contains C definitions for device functions supported
 *	by National Instruments Version 1.3 GPIB Drivers for OS/2.
 *
 ************/

/* The following definitions allow the necessary API function declarations
 * to be included by os2.h.  These definitions must precede the statement
 * "#include <os2.h>"
 */

#define INCL_DOSDEVICES
#define INCL_DOSSEMAPHORES

/* Parameters for DosOpen  */

#define RdOnly	   1	 /* Attribute: read only */
#define OpenTrunc  2		 /* OpenFlag: open file & truncate if exists */
#define RdWrDN	   0x42  /* OpenMode: access mode  = read/write,
						sharing mode = deny none */

/* Parameter for DosDevIOCtl	  */

#define CATEGORY 0x81

/* GPIB Commands     */

#define UNL  0x3f       /* GPIB unlisten command                */
#define UNT  0x5f       /* GPIB untalk command                  */
#define GTL  0x01      /* GPIB go to local                     */
#define SDC  0x04     /* GPIB selected device clear           */
#define PPC  0x05     /* GPIB parallel poll configure         */
#define GGET 0x08    /* GPIB group execute trigger	   */
#define TCT  0x09      /* GPIB take control                    */
#define LLO  0x11     /* GPIB local lock out                  */
#define DCL  0x14    /* GPIB device clear                    */
#define PPU  0x15   /* GPIB parallel poll unconfigure       */
#define SPE  0x18  /* GPIB serial poll enable              */
#define SPD  0x19  /* GPIB serial poll disable             */
#define PPE  0x60  /* GPIB parallel poll enable            */
#define PPD  0x70  /* GPIB parallel poll disable           */

/*
 *  device and board definitions
*/

	/* uflag - user flag definitions
	 */

#define UEOT		0x1	 /* end termination on write */
#define UREOS	0x4	 /* terminate read on EOS */
#define UWEOS	0x8	 /* assert EOI with EOS byte */
#define UCMP8	0x10	 /* 8-bit compare on EOS byte */
#define UNAD		0x20	 /* unaddress devices after I/O */
#define UDMA		0x2000  /* use DMA I/O */

	/* uflag - board only flag definitions
	 */

#define USRE		0x100	  /* set or clear remote enable line */
#define UIST		0x200   /* set or clear individual status bits for ppoll */
#define UGPIB		0x400	 /* return GPIB codes on all calls */
#define USC		0x0800 /* interface is system controller */

/*********************************************************************
*
* OS/2 GPIB board status bit definitions (device function = STATUS)
*
*	  bit definitions
*	   15 14 13 12 11 10  9  8  7  6  5  4	3  2  1  0
*	 ***************************************************
*	 | B | B| B| B| B| B| B| B| B| B|  |  | B|  | B | B|
*	 | C | A| L| R| S| L| T| D| D| T|  |  | E|  | T | I|
*	 | I | T| O| E| R| A| A| C| T| I|  |  | N|  | C | O|
*	 | C | N| K| M| Q|  |  | A| A| M|  |  | D|  |	| D|
*	 |   |	|  |  |  |  |  | S| S| O|  |  |  |  |	| O|
*	 |   |	|  |  |  |  |  |  |  |	|  |  |  |  |	| N|
*	 |   |	|  |  |  |  |  |  |  |	|  |  |  |  |	| E|
*	***************************************************
*
*	 BCIC	  - board is controller in charge
*	 BATN	  - GPIB attention line is asserted
*	 BLOK	  - board is in lockout state
*	 BREM	  - board is in remote state
*	 BSRQ	  - GPIB SRQ line is asserted
*	 BLA	  - GPIB is addressed as listener
*	 BTA	  - GPIB is addressed as talker
*	 BDCAS	  - GPIB has detected a device clear
*	 BDTAS	  - GPIB has detected a device trigger
*	 BTIMO	  - time limit exceeded on I/O function
*	 BEND	  - END or EOS detected on I/O function
*	 BTC	  - count was reached on I/O function
*	 BIODONE  - successful completion of I/O function
*/

#define BIODONE 	(1<<0)
#define	BTC		(1<<1)
#define BEND		(1<<4)
#define BTIMO		(1<<6)
#define BDTAS		(1<<7)
#define BDCAS		(1<<8)
#define	BTA		(1<<9)
#define	BLA		(1<<10)
#define BSRQ		(1<<11)
#define	BREM		(1<<12)
#define	BLOK		(1<<13)
#define BATN		(1<<14)
#define	BCIC		(1<<15)

/********************************************************************
*
*  OS/2 handler errors
*
*	 ECIC	  - board must be CIC to use this function
*	 ENOL	  - no listener for write transfer
*	 EADR	  - board not addressed correctly
*	 EARG	  - invalid argument to function call
*	 ESAC	  - board must be system controller to use this function
*	 EABO	  - I/O transfer aborted
*	 ECAP	  - illegal function code
*	 ESEM	  - invalid semaphore handle
*	 EBUS	  - command error during device function
*	 ETMW	  - timeout on wait function
*/

#define  ECIC	      1
#define  ENOL	      2
#define  EADR	      3
#define  EARG	      4
#define  ESAC	      5
#define  EABO	      6
#define  ECAP	      11
#define  ESEM	      13
#define  EBUS	      14
#define  ETMW	      17


/***********
 *
/*	Definitions of functions supported by National Instruments
 *	OS/2 Operating System GPIB Device Driver
 *
 ************/

/* Device Control Codes supported by OS/2 GPIB driver */

				/* begin BOARD IOCTL */
#define CMD		0x67	/* send commands from buffer */
#define ATNON		0x68	/* raise ATN */
#define ATNOFF		0x69	/* lower ATN */
#define SETREMOTE	0x6B	/* set remote enable */
#define SENDIFC		0x6C	/* send IFC for 100 microseconds */
#define PRESENT		0x6D	/* return whether board present */
#define ONLINE		0x6E	/* place device online */
#define OFFLINE 	0x6E	/* place device offline */
#define STATUS		0x70	/* interface status specific to API style
                           calls.*/
#define BLOCAL		0x71	/* return board to local state */
#define SPOLLBYTE	0x72	/* change status byte returned by serial poll */
#define REQUEST 	0x73	/* set request service */
#define PPOLLIST	0x74	/* set individual status bit */
#define CLRREMOTE	0x75	/* clear remote enable */
#define BWAIT		0x76	/* wait for event */
#define BConfRd		0x79	/* read board default configuration */
#define BConfWrt	0x80	/* write board default configuration */
#define BTempRd		0x81	/* read board temporary information */
#define BTempWrt	0x82	/* write board temporary information */
#define IBSTATUS  0x87  /* interface status specific to ibstyle
                           calls. */


				/* begin DEVICE IOCTL */
#define DCLEAR		0x92	/* device clear */
#define DLOCAL		0x93	/* return to local */
#define PASSCONTROL	0x96	/* pass control */
#define PPOLL		0x97	/* parallel poll */
#define PPOLLCONF	0x98	/* parallel poll configure */
#define TRIGGER		0x99	/* device trigger */
#define SPOLL		0x9A	/* serial poll */

				
#define DConfRd		0xA1	/* read device default configuration */
#define DConfWrt	0xA2	/* write device default configuration */
#define DTempRd		0xA3	/* read device temporary information */
#define DTempWrt	0xA4	/* write device temporary information */

/* Board configuration structure */

typedef struct nibrd {
	int	pad;		/* primary address of board */
	int	sad;		/* secondary address of board */
	int	eos;		/* eos character */
	long	timo;		/* minimum timeout for board level operations */
	int	uflags; 	/* some flags */
	int	reserved;	/* reserved word */
	int	rbase;		/* base address of board */
	int	dmaCH;		/* DMA channel used by board */
} nibrd;

/* Device configuration structure */

typedef struct nidev {
	int	brdno;		/* index to associated board */
	int	pad;		/* primary address of device */
	int	sad;		/* secondary address of device */
	int	eos;		/* eos character */
	int	uflags; 	/* some flags */
	long	timo;		/* minimum timeout for device level operations */
} nidev;





