(***********
 *
 * nicode.pas :
 *   Definitions for National Instruments OS/2 GPIB Device Control Functions
 *
 *	Copyright 1988,1989, 1990, 1991 National Instruments Corporation.
 *	      All rights reserved.
 *
 * Purpose:
 *	This file contains Pascal constants for device functions supported
 *	by National Instruments Version 1.3 GPIB Drivers for OS/2.
 *
 ************)

Const
			 (* Includes definition of DosDevIOCtl in BSEDOS.INT *)
	INCL_DOSDEVICES = 1;
	CATEGORY = 16#81;

(* Parameters for DosOpen						     *)

	RdOnly = 1;		   (* Attribute: read only *)
	OpenTrunc = 2;		   (* OpenFlag: open file & truncate if exists *)
	RdWrDN = 16#42; 	   (* OpenMode: access mode  = read/write,
						sharing mode = deny none *)

(* GPIB Commands:                                                            *)

   UNL  =  16#3f;                       (* GPIB unlisten command             *)
   UNT  =  16#5f;                       (* GPIB untalk command               *)
   GTL  =  16#01;                       (* GPIB go to local                  *)
   SDC  =  16#04;                       (* GPIB selected device clear        *)
   PPC  =  16#05;                       (* GPIB parallel poll configure      *)
   GGET =  16#08;                       (* GPIB group execute trigger        *)
   TCT  =  16#09;                       (* GPIB take control                 *)
   LLO  =  16#11;                       (* GPIB local lock out               *)
   DCL  =  16#14;                       (* GPIB device clear                 *)
   PPU  =  16#15;                       (* GPIB parallel poll unconfigure    *)
   SPE  =  16#18;                       (* GPIB serial poll enable           *)
   SPD  =  16#19;   			(* GPIB serial poll disable          *)
   PPE  =  16#60;   			(* GPIB parallel poll enable         *)
   PPD  =  16#70;   			(* GPIB parallel poll disable        *)
(*
 *  device and board definitions
 *)

	(* uflag - user flag definitions
	 *)

	UEOT =		  16#1;    (* end termination on write *)
	UREOS = 	  16#4;    (* terminate read on EOS *)
	UWEOS = 	  16#8;    (* assert EOI with EOS byte *)
	UCMP8 = 	  16#10;   (* 8-bit compare on EOS byte *)
	UDMA =		  16#2000; (* use DMA I/O *)

	(* uflag - board only flag definitions
	 *)

	UGPIB = 	  16#400;  (* return GPIB codes on all calls *)
	USC =		  16#0800; (* interface is system controller *)
	USRE =	  16#0100; (* set or clear remote enable line *]
	UIST =		  16#0200; (* set or clear individual status bit for ppoll *)

(*********************************************************************
*
* OS/2 GPIB board status bit definitions (device function = STATUS)
*
*	  bit definitions
*	   15 14 13 12 11 10  9  8  7  6  5  4	3  2  1  0
*	 ***************************************************
*	 | B | B| B| B| B| B| B| B| B| B|  |  | B|  | B | B|
*	 | C | A| L| R| S| L| T| D| D| T|  |  | E|  | T | I|
*	 | I | T| O| E| R| A| A| C| T| I|  |  | N|  | C | O|
*	 | C | N| K| M| Q|  |  | A| A| M|  |  | D|  |	| D|
*	 |   |	|  |  |  |  |  | S| S| O|  |  |  |  |	| O|
*	 |   |	|  |  |  |  |  |  |  |	|  |  |  |  |	| N|
*	 |   |	|  |  |  |  |  |  |  |	|  |  |  |  |	| E|
*	 ***************************************************
*
*	 BCIC	  - board is controller in charge
*	 BATN	  - GPIB attention line is asserted
*	 BLOK	  - board is in lockout state
*	 BREM	  - board is in remote state
*	 BSRQ	  - GPIB SRQ line is asserted
*	 BLA	  - GPIB is addressed as listener
*	 BTA	  - GPIB is addressed as talker
*	 BDCAS	  - GPIB has detected a device clear
*	 BDTAS	  - GPIB has detected a device trigger
*	 BTIMO	  - time limit exceeded on I/O function
*	 BEND	  - END or EOS detected on I/O function
*	 BTC	  - count was reached on I/O function
*	 BIODONE  - successful completion of I/O function
*
*)

	BIODONE =	  16#1;
	BTC =		  16#2;
	BEND =		  16#10;
	BTIMO = 	  16#40;
	BDTAS = 	  16#80;
	BDCAS = 	  16#100;
	BTA =		  16#200;
	BLA =		  16#400;
	BSRQ =		  16#800;
	BREM =		  16#1000;
	BLOK =		  16#2000;
	BATN =		  16#4000;
	BCIC =		  16#8000;

(********************************************************************
*
*  OS/2 handler errors
*
*	 ECIC	  - board must be CIC to use this function
*	 ENOL	  - no listener for write transfer
*	 EADR	  - board not addressed correctly
*	 EARG	  - invalid argument to function call
*	 ESAC	  - board must be system controller to use this function
*	 EABO	  - I/O transfer aborted
*	 ECAP	  - illegal function code
*	 ESEM	  - invalid semaphore handle
*	 EBUS	  - command error during device function
*	 ETMW	  - timeout on wait function
*)
	ECIC = 1;
	ENOL = 2;
	EADR = 3;
	EARG = 4;
	ESAC = 5;
	EABO = 6;
	ECAP = 11;
	ESEM = 13;
	EBUS = 14;
	ETMW = 17;


(***********
 *
 *	Definitions of functions supported by National Instruments
 *	OS/2 Operating System GPIB Device Driver
 *
 ************)

(* Device Control Codes supported by OS/2 GPIB driver *)

				(* BOARD IOCTL *)
	CMD =		  16#67;   (* send commands from buffer *)
	ATNON = 	  16#68;   (* raise ATN *)
	ATNOFF =	  16#69;   (* lower ATN *)
	SETREMOTE =	  16#6B;   (* set remote enable *)
	SENDIFC =	  16#6C;   (* send IFC for 100 microseconds *)
	PRESENT =	  16#6D;   (* return whether board present *)
	ONLINE =	  16#6E;   (* place device online *)
	OFFLINE =	  16#6F;   (* place device offline *)
	STATUS =	  16#70;   (* return interface status *)
	BLOCAL =	  16#71;   (* return board to local state *)
	SPOLLBYTE =	  16#72;   (* change status byte returned by serial poll *)
	REQUEST =	  16#73;   (* set request service *)
	PPOLLIST =	  16#74;   (* set individual status bit *)
	CLRREMOTE =	  16#75;   (* clear remote enable *)
	BWAIT = 	  16#76;   (* wait for event *)
	BConfRd =	  16#79;   (* read board default configuration *)
	BConfWrt =	  16#80;   (* write board default configuration *)
	BTempRd =	  16#81;   (* read board temporary information *)
	BTempWrt =	  16#82;   (* write board temporary information *)
        IBSTATUS =        16#87;   (* return interface status for ib-style calls *)

				(* DEVICE IOCTL *)
	DCLEAR =	  16#92;   (* device clear *)
	DLOCAL =	  16#93;   (* return to local *)
	PASSCONTROL =	  16#96;   (* pass control *)
	PPOLL = 	  16#97;   (* parallel poll *)
	PPOLLCONF =	  16#98;   (* parallel poll configure *)
	TRIGGER =	  16#99;   (* device trigger *)
	SPOLL = 	  16#9A;   (* serial poll *)

				
	DConfRd =	  16#A1;   (* read device default configuration *)
	DConfWrt =	  16#A2;   (* write device default configuration *)
	DTempRd =	  16#A3;   (* read device temporary information *)
	DTempWrt =	  16#A4;   (* write device temporary information *)

type	nibrd = record
		pad	   : integer;		 (* primary address of board *)
		sad	   : integer;		 (* secondary address of board *)
		eos	   : integer;		 (* eos character *)
		timo	   : integer4;		 (* minimum timeout *)
		uflags	   : integer;		 (* some flags *)
		reserved   : integer;		 (* reserved word *)
		rbase	   : integer;		 (* base address of board *)
		dmaCH	   : integer;		 (* DMA channel used by board *)
	end;

type	nidev = record
		brdno	   : integer;		 (* number of associated board *)
		pad	   : integer;		 (* primary address of device *)
		sad	   : integer;		 (* secondary address of device *)
		eos	   : integer;		 (* eos character *)
		uflags	   : integer;		 (* some flags *)
		timo	   : integer4;		 (* minimum timeout *)
	end;
