/* OS/2 Example Program 5 -- 488.2 Communication */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "decl.h"

char          buffer[101];       /* Data received from the *IDN? query */
int           i,                 /* Loop control variable */ 
              num_listeners;     /* Number of listeners on GPIB */
unsigned short instruments[32],  /* Array of primary addresses */
              result[31],        /* Array of listen addresses */
              pad;               /* Primary address of listener on GPIB */


main() {

   /*Initialize the GPIB interface*/
   SendIFC(0);         
   if (ibsta & ERR)
      report_error(0,"Could not send IFC");

   /*
   Create an array containing all valid GPIB primary addresses.  This
   array (INSTRUMENTS) will be given to the function FindLstn to find all 
   listeners.  The constant NOADDR, defined in DECL.H, signifies the end 
   of the array.
   */

   for (i = 0; i <= 30; i++) 
       instruments[i] = i;
    
   instruments[31] = NOADDR;    

   /*
   Print message to tell user that the program is searching for all active
   listeners.  Find all of the listeners on the bus.   Store the listen 
   addresses in the array RESULT.  
   */

   printf("Finding all listeners on the bus...\n\n");

   FindLstn(0, instruments, result, 31);
   if (ibsta & ERR) 
      report_error(0,"Could not find listeners");

   /*
   Assign the value of IBCNT to the variable NUM_LISTENERS.  The GPIB
   interface board is detected as a listener on the bus; however, it is
   not included in the final count of the number of listeners.   Print
   the number of listeners found.
   */

    num_listeners = ibcnt - 1;
    printf("Number of instruments found = %d\n", num_listeners);

   /*
   Send the *IDN? command to each device that was found.  The GPIB interface
   board is at address 0 by default.  The board does not respond to *IDN?, so
   skip it. 
   */

    for (i = 1; i <= num_listeners; i++) {

      /*
      Send the identification query to each listen address in the
      array RESULT.  The constant NLend, defined in DECL.H, instructs
      the function Send to append a linefeed character with EOI asserted
      to the end of the message.  
      */

      Send(0, result[i], "*IDN?", 5L, NLend);
      if (ibsta & ERR)
         report_error(0,"could not send *IDN? to devices");

      /*
      Read the name identification response returned from each device.  
      Store the response in the array BUFFER.  The constant STOPend,
      defined in DECL.H, instructs the function Receive to terminate the
      read when END is detected.  
      */

      Receive(0, result[i], buffer, 10L, STOPend);
      if (ibsta & ERR)
         report_error(0,"Could not receive from devices");

      /*
      The low byte of the listen address is the primary address.
      Assign the variable PAD the primary address of the device.
      The macro GetPAD, defined in DECL.H, returns the low byte
      of the listen address.
      */

      pad = GetPAD(result[i]);

      /*
      Use the null character to mark the end of the data received
      in the array BUFFER.  Print the primary address and the name
      identification of the device.  
      */

      buffer[ibcnt] = '\0';
      printf("The instrument at address %d is a %s\n", pad, buffer);
      
    }     /*  End of FOR loop */

   /*Take the board off-line*/
   ibonl (0,0);              
}

report_error(int fd, char *errmsg) {

   fprintf(stderr, "Error %d: %s\n", iberr, errmsg);
   ibonl(0,0);
   exit(1);              /* abort program */
}

