/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/* Copyright International Business Machines Corp. 1991                   */
/*                                                                        */
/* All Rights Reserved                                                    */
/*                                                                        */
/* Refer to "LICENSE.DOC" for information regarding the use of this file. */
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/* Declares for different TYPEs of messages to be displayed                  */
#define  TITLE     0     /* Line 2-3 of display   - BLUE/WHITE               */
#define  COPYRIGHT 1     /* Line 24 of display    - BLUE/WHITE               */
#define  STATUS    2     /* Line 21 of display    - GREEN/BLACK              */
#define  USERINPUT 3     /* Line 5-7 of display   - BLUE/WHITE               */
#define  ERROR     4     /* Line 9-12 of display  - RED/BLACK                */
#define  WARNING   5     /* Line 14-17 of display - GRAY/RED                 */
#define  HELP      6     /* Line 9-17 of display  - AQUA/BLACK               */
#define  YNQUEST   7     /* Line 8 of display     - BLUE/WHITE               */
#define  WARNHLP   8     /* Line 18-20 of display - RED/BLACK                */
#define  VBHELP    9     /* Line 22 of display    - GREEN/BLACK              */
#define  CLHELP   10     /* Line 2-21 of display  - BLUE/WHITE               */

#define  TRUE             1
#define  FALSE            0

#define  PLAY_DEMO        0
#define  RCD_DEMO         1

#define  ESC           27
#define  ENTER13       13
#define  ENTER10       10
#define  BACKSPACE     8
#define  SPACE         32
#define  UP_ARROW      240
#define  INCL_DOSMISC
#define  INCL_DOSDEVICES
#define  INCL_DOSFILEMGR

#define  BLINK  16   /* number to add to foreground/background color to      */
                     /* have it blink                                        */
#define  BLACK  0    /* Foreground and Background colors                     */
#define  BLUE   1
#define  GREEN  2
#define  AQUA   3
#define  RED    4
#define  PURPLE 5
#define  ORANGE 6
#define  GRAY   7
#define  WHITE  15

#define  LIGHT  8     /* number to add to above 8 foreground/background      */
                      /* colors to get a lighter shade of that color         */
#define  MAXSTRING 40 /* maximum length of file name + 1                     */
#define  MAXMSGLEN 80 /* maximum length of message                           */

#define LINT_ARGS     /* Perform type checking on library functions          */

#define OFILE_EXT ".SEQ"               /* Output file extension              */
#define IFILE_EXT ".MID"               /* Input file extension               */


#define NOTE_OFF             0x80
#define NOTE_ON              0x90
#define KEY_PRESSURE         0xA0
#define CONTROL_CHANGE       0xB0
#define PROGRAM_CHANGE       0xC0
#define CHANNEL_PRESSURE     0xD0
#define PITCH_BEND           0xE0
#define SYSTEM_MESSAGE       0xF0
#define MTC_QUARTER_FRAME    0xF1
#define SONG_POSITION        0xF2
#define SELECT_SONG          0xF3
#define TUNE_REQUEST         0xF6
#define EOX                  0xF7
#define TIMING_CLOCK         0xF8
#define START                0xFA
#define CONT                 0xFB
#define STOP                 0xFC
#define ACTIVE_SENSING       0xFE
#define SYSTEM_RESET         0xFF

#define BSIZE_R              280
#define NUM_MODES            43
#define XBUFFERSIZER         128
#define RBUFFERSIZEP         128
#define XBUFFERSIZEP         60000
#define RBUFFERSIZER         60000

#define  UNKNOWN_MODE    NUM_MODES

/* mode_data.dont_care definitions */
#define  FLAGS       0x01           /* If set, then ignore flags           */
#define  BPS         0x02           /* If set, then ignore bits_per_sample */
#define  SRATE       0x04           /* If set, then ignore srate           */
#define  CHANNELS    0x08           /* If set, then ignore channels        */
#define  BSIZE       0x10           /* If set, then ignore bsize           */

#define  MIDI_BUFF_LEN 150
