/************* jpegerr.h ****************************************/
/********* Irrecoverable Errors ********************************/
#define                     READ_INVALID                       101
#define                     WRITE_INVALID                      102
#define                     ACPA_INIT_DEV_DRV                  201 /* device driver not found */
#define                     ACPA_INIT_CARD_NOT_FOUND           202 /* ACPA card not found */
#define                     ACPA_INIT_CARD_LOCKED              203 /* Another process is using the ACPA card */
#define                     ACPA_INIT_UNRECOGNIZED_ERROR       204 /* Error return from ACPA init not recognized */
#define                     RESTART_INTERVAL_INVALID           401
#define                     MDU_TO_CODE_0                      403
#define                     PARS_STACK_OVFLW                   501
#define                     PARS_JPEG_HDR_SYNTAX               502
#define                     PARS_LINE_LENGTH_0                 504
#define                     PARS_NUM_LINES_NOT_GEN             505
#define                     PARS_IMAGE_NULL                    506
#define                     PARS_IMAGE_DATA_ORDER              507
#define                     PARS_COM_AREA_OPERATION_INVALID    508
/*
Must be default:
    DECOMPRESS/NO_COLOR_CONVERT/INTERMEDIATE_CALL/SINGLE_BUFFER
Or at least one of the alternatives:
    COMPRESS/COLOR_CONVERT/INITIAL_CALL or LAST_CALL/MULTIPLE_BUFFER
*/
#define                     HUFF_COEFF_SIZE_16                 404
#define                     HUFF_TAB_RESYNC                    801
#define                     HUFF_TAB_ZERO_NUM                  802
#define                     HUFF_DC_TBL_PTR_NULL               904  /* DC Huff. tbl ptr NULL */
#define                     HUFF_AC_TBL_PTR_NULL               905  /* AC Huff. tbl ptr NULL */
#define                     QUANT_TAB_INDEX_INVALID            402
#define                     QUANT_TBL_PTR_NULL                 903  /* Q table ptr NULL      */
#define                     BUF_UNPUTBYTE                      901  /* Unputbyte to prev. buf*/
#define                     BUF_INPUT_SIZE                     902  /* INVALID input buffer size */
#define                     BUF_OUT_OF_BOUNDS_ADDR             907
#define                     BUF_PIXEL_ALLOC                    205
#define                     BUF_PIXEL_PARAM_ALLOC              206
/* Failure to allocate buffer for pixel parameters */
#define                     BUF_NON_PIXEL_ALLOC                207
#define                     BUF_NUM_LINES_NOT_INTEGER_MULT     208
#define                     COLOR_CON_SPACE_INVALID            601
#define                     COLOR_SPACE_NUM_COMP_INVALID       602
/* Number of components in JPEG frame segment not consistent with the internal color space selected */
#define                     COLOR_SPACE_HOR_SAMP_INVALID       603
/* Number of Horizontal samples in JPEG frame segment not consistent with the internal color space selected */
#define                     COLOR_SPACE_VERT_SAMP_INVALID      604
/* Number of Vertical samples in JPEG frame segment not consistent with the internal color space selected */
#define                     SAMPLES_UNKNOWN                    605
/* Samples code is not one of YUV, YYUV, DVI, or OTHER   */
#define                     OUT_OF_RANGE_IMAGE_FRAME_WARN      701
#define                     OUT_OF_RANGE_COMPONENT_WARN        702
#define                     OUT_OF_RANGE_SAMPLES_WARN          703
#define                     OUT_OF_RANGE_SCAN_WARN             704
#define                     OUT_OF_RANGE_JPEG_TABLE_WARN       705
#define                     OUT_OF_RANGE_HUFF_TABLE_WARN       706
#define                     OUT_OF_RANGE_QUANT_TABLE_WARN      707
#define                     OUT_OF_RANGE_DNL_WARN              708
#define                     OUT_OF_RANGE_PARS_WARN             709
#define                     OUT_OF_RANGE_WARN                  710
#define                     OUT_OF_MEMORY                      906


#define MRESULT int
#define ERROR_RETURN    -1
#define SUCCESS          0
#define WARNING_RETURN   1
#define MARKER_CODE      2
#define WARNINGS_LIM     10


/****************** Warning Flags *******************************/
#define                     IMAGE_FRAME_WARN   0x0001
#define                     COMPONENT          0x0002
#define                     SAMPLES            0x0004
#define                     SCAN               0x0008
#define                     JPEG_TAB           0x0010
#define                     HUFF_TAB           0x0020
#define                     QUANT_TAB          0x0040
#define                     DNL_WARN           0x0080
#define                     PARS               0x0100



/**********  Warnings ******************************************/

/*********** Image/Frame Warnings ******************************/
#define                      IMAGE_FRAME_PRECISION    1001
#define                      IMAGE_FRAME_COMP         1002
#define                      IMAGE_FRAME_SOF_INVALID  1003
#define                      IMAGE_FRAME_LIM          3


/*********** Component Warnings ********************************/
#define                      COMP_ID_DEF              1101
#define                      COMP_CNT                 1102
#define                      COMP_LIM                 2


/*********** Samples Warnings **********************************/
#define                      SAMPLES_HOR_RANGE        1201
#define                      SAMPLES_VERT_RANGE       1202
#define                      SAMPLES_HOR_NUM          1203
#define                      SAMPLES_VERT_NUM         1204
#define                      SAMPLES_PER_MDU          1205
#define                      SAMPLES_LIM              5


/*********** Scan Warnings *************************************/
#define                      SCAN_START_OF_SPECTRAL   1301
#define                      SCAN_END_OF_SPECTRAL     1302
#define                      SCAN_SUCCESSIVE_APPROX   1303
#define                      SCAN_LIM                 3


/*********** JPEG Table Warnings *******************************/
#define                      JPEG_TABLE_ALLOC         1401
#define                      JPEG_TABLE_LIM           1


/*********** Huffman Table Warnings ****************************/
#define                      HUFF_DUPLICATE           1501
#define                      HUFF_TAB_SETUP           1502
#define                      HUFF_LENGTH              1503
#define                      HUFF_DC_ID_RANGE         1504
#define                      HUFF_AC_ID_RANGE         1505
#define                      HUFF_DC_LUM_TABLE        1506
#define                      HUFF_DC_CHROM_TABLE      1507
#define                      HUFF_AC_LUM_TABLE        1508
#define                      HUFF_AC_CHROM_TABLE      1509
#define                      HUFF_TABLE_LIM           9


/*********** Quantization Table Warnings ***********************/
#define                      QUANT_TABLE_DQT_ID_RANGE 1601
#define                      QUANT_TABLE_LIM          1


/*********** DNL Warnings **************************************/
#define                      DNL_INVALID              1701
#define                      DNL_LIM                  1


/*********** Parser Warnings ****************************/
#define                      PARS_INVALID             2001
#define                      PARS_ZERO_INVALID        2002
#define                      PARS_COMMENT_TOO_LONG    2003
#define                      PARS_LIM                 3



