/*********************************************************************/
/*								     */
/*  INCLUDE NAME = eapiacb.cnc					     */
/*								     */
/*  DESCRIPTIVE NAME = AAPI Audio Control Block and Function	     */
/*			   Definitions	("C" language version)       */
/*								     */
/*  COPYRIGHT = (C) Copyright by IBM Corp. 1989 - 1991. 	     */
/*		All rights reserved.				     */
/*		Refer to "LICENSE.DOC" for information regarding     */
/*		the use of this file.				     */
/*								     */
/*  NOTES = In the following control block definitions, the	     */
/*	    identifier "2#xxxxxxxx..." indicates that the individual */
/*	    bits therein can be independently set and reset.	     */
/*								     */
/*  CHANGE ACTIVITY =  See Below				     */
/*								     */
/*	    Isolated changed areas will be marked with three	     */
/*	    character codes "XXX".  New areas will be marked with    */
/*	    only "XXXs" at the start and "XXXe" at the end.          */
/*								     */
/*		       12/07/89, AVC Release 1.02		     */
/*		       03/16/90, AVC Release 1.03		     *-103*/
/*				 Add MIDI DSP flag		     *-103*/
/*				 Add MIDI related return codes	     *-103*/
/*				 Add High quality music support      *-103*/
/*				 Add Pause/Resume controls	     *-103*/
/*		       05/23/91, M-ACPA Release 2.00		     *-200*/
/*				 Add Save/Restore flag and pointer   *-200*/
/*				 Add AUD_SIZE call		     *-200*/
/*				 Add RIFF WAVE PCM support	     *-200*/
/*				 Remove mix flags		     *-200*/
/*								     */
/*********************************************************************/
/*								     */
/********AUDIO CONTROL BLOCK STRUCTURE********************************/
/*								     */
typedef struct AAPI_ACB_T	       /* Audio Control Block	     */
{				       /*			     */
/********Input Parameters*********************************************/
/*								     */
 unsigned char	 channel;	       /*  Input channel identifier  */
   #define AAPI_CHNA 0		       /*   Channel A		     */
   #define AAPI_CHNB 1		       /*   Channel B		     */
   #define AAPI_CHNS 0xFF	       /*   Select and return channel*-200*/
/*								     */
 unsigned char	 dspmode;	       /*  Audio operation	     */
   #define AAPI_PLAY 1		       /*   Play		     */
   #define AAPI_RECD 2		       /*   Record		     */
   #define AAPI_MON  3		       /*   Monitor		     */
/*								     */
 unsigned char	 seektype;	       /*  Type of seek to perform   */
   #define AAPI_INIT 0		       /*   Initialize and seek      */
   #define AAPI_SEEK 1		       /*   Seek only		     */
   #define AAPI_CONT 2		       /*   Continue		     */
   #define AAPI_ROLY 3		       /*   Release resources only   */
   #define AAPI_RINT 4		       /*   Release, init and seek   */
/*								     */
 unsigned char	 audtype;	       /*  Audio compression type    */
   #define AAPI_DEFT 0		       /*   Use current/default      */
   #define AAPI_SM11 1		       /*   ADPCM/11K	     (music) */
   #define AAPI_ML05 2		       /*   ADPCM/5.5K	     (voice) */
   #define AAPI_ML22 3		       /*   ADPCM/22K (stereo music) */
   #define AAPI_FM22 4		       /*   ADPCM/22K	  (HQ music) *-103*/
   #define AAPI_WAVE 60 	       /*   RIFF WAVE PCM	     *-200*/
/*								     */
 unsigned char	 intlevel;	       /*  Interrupt Level	     */
/*								     */
 unsigned char	 inpsrce;	       /*  Input source 	     */
   #define AAPI_INMI 0		       /*   Microphone input - normal*/
   #define AAPI_INLI 1		       /*   Line level input - left  */
   #define AAPI_INLR 2		       /*   Line level input - right */
   #define AAPI_INLB 3		       /*   Line level input - both  */
   #define AAPI_INML 4		       /*   Microphone input - low   */
/*								     */
 unsigned short  piobase;	       /*  Audio card base addr      */
/*								     */
 unsigned short  controls;	       /*  Control change requests   */
				       /*   2#xxxxxxxxxxxxxxxx	     */
   #define AAPI_MVOL 0x01	       /*   Master Volume	     */
   #define AAPI_TVO1 0x02	       /*   Track Volume - 1	     */
   #define AAPI_TVO2 0x04	       /*   Track Volume - 2	     */
   #define AAPI_CBAL 0x08	       /*   Channel Balance	     */
   #define AAPI_STOP 0x10	       /*   Set stop position	     */
   #define AAPI_PFIO 0x20	       /*   Perform I/O 	     */
   #define AAPI_PAUS 0x40	       /*   Pause current operation  *-103*/
   #define AAPI_RESM 0x80	       /*   Resume current operation *-103*/
/*								     */
 unsigned short  oprparms;	       /*  Operation parameters      */
				       /*   2#xxxxxxxxxxxxxxxx	     */
   #define AAPI_RCNU 0x02	       /*   No update of obj totals  */
				       /*    during record operation */
   #define AAPI_SPKO 0x04	       /*   PS/2 speaker enabled     */
   #define AAPI_MNPC 0x10	       /*   Monitor, pre-compress    */
   #define AAPI_MNPS 0x20	       /*   Monitor, post-compress   */
   #define AAPI_BCAN 0x200	       /*   If process is switched   */
				       /*    to bkgrnd, end operation*/
   #define AAPI_LDVM 0x400	       /*   Setup VOICE/MIDI DSP     *-103*/
				       /*    environment if voice is *-103*/
				       /*    started first	     *-103*/
/*								     */
 FAB_STRUCT	*fileptr;	       /*  File Access Block Pointer */
 unsigned short  subtype;	       /*  FABO sub-type to access   */
/*								     */
 unsigned long	 audstart;	       /*  Seek start position	     */
 unsigned long	 audend;	       /*  Seek end position	     */
/*								     */
 unsigned long	 bufflen;	       /*  I/O buffer length	     */
 unsigned char	 *buffptr;	       /*  I/O buffer pointer	     */
 unsigned short  emmhan;	       /*  Memory manager handle     */
 unsigned short  emmcnt;	       /*  Memory manager page count */
/*								     */
 unsigned short  memid; 	       /*  Memory type id	     */
   #define AAPI_MNON  0x00	       /*   Not allocated	     */
   #define AAPI_MAIN  0x01	       /*   Main memory 	     */
   #define AAPI_MLIM  0x02	       /*   LIM memory		     */
   #define AAPI_MDEV  0x03	       /*   Device		     */
/*								     */
 unsigned char	 memres[6];	       /*  Reserved - memory struct  */
/*								     */
 unsigned char	 ctlparms;	       /*  Control parameters	     */
				       /*   2#xxxxxxxxxxxxxxxx	     */
   #define AAPI_STPI 0x01	       /*   Stop - Ignore other ctrls*/
   #define AAPI_PQUE 0x02	       /*   Purge queue, then process*/
				       /*    new control requests    */
   #define AAPI_ISRC 0x04	       /*   This control call made   */
				       /*    from within an ISR      */
   #define AAPI_ALLC 0x08	       /*   Pause/Resume all channels*-103*/
   #define AAPI_RESC 0x10	       /*   Restore previous controls*-200*/
				       /*    (Master Vol, Vol, Bal)  *-200*/
/*								     */
 unsigned char	 masvol;	       /*  Master volume level(0-100)*/
 unsigned short  trkvol1;	       /*  Track vol/1 level(0-100)  */
 unsigned long	 trkvol1s;	       /*  Start pos (ms) of vol fade*/
 unsigned long	 trkvol1e;	       /*  End pos (ms) of vol fade  */
 unsigned short  trkvol2;	       /*  Track vol/2 level(0-100)  */
 unsigned long	 trkvol2s;	       /*  Start pos (ms) of vol fade*/
 unsigned long	 trkvol2e;	       /*  End pos (ms) of vol fade  */
 unsigned char	 chnbal;	       /*  Channel balance lev(0-100)*/
 unsigned char	 outchan;	       /*  Output channel pair	     */
    #define AAPI_OTAB 0 	       /*   A(chan bal)/B(remaining) */
    #define AAPI_OTBA 1 	       /*   B(chan bal)/A(remaining) */
 unsigned long	 chnbals;	       /*  Start pos (ms) of bal fade*/
 unsigned long	 chnbale;	       /*  End pos (ms) of bal fade  */
 unsigned long	 stoppos;	       /*  Position (ms) to stop oper*/
/*								     */
 unsigned long	 iotime;	       /*  Length of audio I/O (ms)  */
				       /*   Zero = maximum length    */
/*								     */
 struct AAPI_ACB_T *acb2ptr;	       /*  Secondary ACB pointer     */
/*								     */
 struct AAPI_LST_T *listptr;	       /*  List of start/stop times  */
/*								     */
 char *dsp_path;		       /*  Pointer to DSP code path  */
/*								     */
 unsigned char *svrsptr;	       /*  Pointer to Save/Restore   *-200*/
				       /*   area for controls	     *-200*/
/*								     */
 struct AAPI_FMT_T *fmtptr;	       /*  Pointer to audio format   *-200*/
				       /*   area		     *-200*/
/*								     */
 unsigned char	 in_reserve[20];       /*  Input parms reserved area *-200*/
/*								     */
/********Output Parameters********************************************/
/*								     */
 unsigned long	 position;	       /*  Current position in audio */
				       /*   (milliseconds)	     */
/*								     */
 unsigned char	 state; 	       /*  Current state of process  */
   #define AAPI_STOPPED   0	       /*   Stopped		     */
   #define AAPI_PLAYING   1	       /*   Playing		     */
   #define AAPI_RECORDING 2	       /*   Recording		     */
   #define AAPI_STOPPING  3	       /*   Stopping		     */
/*								     */
 unsigned short    backrc;	       /*  Backgrnd process retn code*/
 unsigned short    acb2rc;	       /*  Secondary ACB return code */
 unsigned long	 timeleft;	       /*  Time left before I/O      */
				       /*   required (milliseconds)  */
/*								     */
 unsigned short  oupdates;	       /*  Audio objects updated     */
				       /*   2#xxxxxxxxxxxxxxxx	     */
   #define AAPI_UPAU  0x01	       /*   Audio object updated     */
   #define AAPI_UPVU  0x02	       /*   Volume object updated    */
   #define AAPI_UPES  0x04	       /*   Escape object updated    */
   #define AAPI_UPPT  0x08	       /*   Points object updated    */
   #define AAPI_UPLB  0x10	       /*   Label object updated     */
/*								     */
 unsigned char	 out_reserve[8];       /*  Output parms reserved area*/
/*								     */
/********AAPI Work Area***********************************************/
/*								     */
 unsigned char	 workarea[256];        /*  Reserved-AAPI use only    *-200*/
/*********************************************************************/
}  AAPI_ACB;			       /* End Audio Control Block    */
/*								     */
/********END OF AUDIO CONTROL BLOCK STRUCTURE*************************/
/*								     */
/*								     */
/*								     */
/********AUDIO START/STOP LIST STRUCTURE******************************/
/*								     */
typedef struct AAPI_LST_T	       /* Audio Start/End List CB    */
{				       /*			     */
   unsigned long   audstart;	       /*  Seek start position	     */
   unsigned long   audend;	       /*  Seek end position	     */
   struct AAPI_LST_T *nextlist;        /*  Ptr to next list structure*/
}  AAPI_LST;			       /* End Audio Start/End List CB*/
/*								     */
/********END OF AUDIO START/STOP LIST STRUCTURE***********************/
/*								     */
/*								     */
/*								     */
/********AUDIO DEVICE STRUCTURE***************************************/
/*								     */
typedef struct AAPI_DEV_T	       /* Audio Device Control Block */
{				       /*			     */
  unsigned short device_id;	       /*  Device ID		     */
   #define AAPI_DEV_TEC  0x6e6c        /*   M-ACPA device ID	     */
  unsigned short iobase;	       /*  IO base address	     */
  unsigned short intlev;	       /*  Interrupt level	     */
  unsigned short os2rtn;	       /*  OS/2 error code	     */
  unsigned short res[5];	       /*  Reserved for future use   */
}  AAPI_DEV;			       /* End Audio Device CB	     */
/*								     */
/********END OF AUDIO DEVICE STRUCTURE********************************/
/*								     */
/*								     */
/*								     */
/********AUDIO FORMAT STRUCTURE***************************************-200*/
/*								     *-200*/
/* Defined constants with "_W" suffixes are valid inputs to          *-200*/
/* create Microsoft RIFF WAVE format files.			     *-200*/
/*								     *-200*/
#ifndef AAPIFMT 		       /*			     *-200*/
#define AAPIFMT 		       /*			     *-200*/
typedef struct AAPI_FMT_T	       /* Audio Format Control Block *-200*/
{				       /*			     *-200*/
  unsigned short format;	       /*  Format of audio data      *-200*/
   #define AAPI_FMT_LPCM_W   1	       /*   Linear PCM		     *-200*/
  unsigned long samples_per_second;    /*  Sample rate in Hertz      *-200*/
   #define AAPI_FMT_8000    8000       /*			     *-200*/
   #define AAPI_FMT_11KH_W 11025       /*			     *-200*/
   #define AAPI_FMT_22KH_W 22050       /*			     *-200*/
   #define AAPI_FMT_44KH_W 44100       /*			     *-200*/
  unsigned short bits_per_sample;      /*  Sample width in bits(8/16)*-200*/
  unsigned short channels;	       /*  # of channels in data     *-200*/
  unsigned short sample_number_format; /*  Format of sample	     *-200*/
   #define AAPI_FMT_USGN_W   2	       /*   Unsigned (<= 8 bits)     *-200*/
   #define AAPI_FMT_2CMP_W   0	       /*   2's complement (>=9bits) *-200*/
   #define AAPI_FMT_SIGN     1	       /*   Signed		     *-200*/
  unsigned short dither_percent;       /*  Dither (% of one bit)     *-200*/
   #define AAPI_FMT_DITHER   33        /*   Recommended value	     *-200*/
  unsigned short fmtflag;	       /*  Flags		     *-200*/
   #define AAPI_FMT_SMIX     1	       /*   Turn on source mixing    *-200*/
  unsigned short res[20];	       /*  Reserved for future use   *-200*/
}  AAPI_FMT;			       /* End Audio Format CB	     *-200*/
#endif				       /*			     *-200*/
/*								     *-200*/
/********END OF AUDIO FORMAT STRUCTURE********************************-200*/
/*								     */
/*								     */
/*								     */
/********AAPI FUNCTION DECLARATIONS***********************************/
/*								     */
/*  The following are the external declarations for the Audio	     */
/*  Application Programming Interface functions available to "C"     */
/*  language source code.  See the AAPI documentation for the	     */
/*  function descriptions.					     */
/*								     */
/*********************************************************************/
/*								     */
  extern short aud_size(short);        /* Retn audio structure size  *-200*/
   #define AAPI_SZAD	  1	       /*   Audio Device	     *-200*/
   #define AAPI_SZAC	  2	       /*   Control Block	     *-200*/
   #define AAPI_SZSR	  3	       /*   Save/Restore Area	     *-200*/
   #define AAPI_SZSS	  4	       /*   Start/Stop List	     *-200*/
   #define AAPI_SZAF	  5	       /*   Audio Format	     *-200*/
  extern short aud_cfig(AAPI_DEV *);   /* Retn configuration info    */
  extern short aud_init(AAPI_ACB *);   /* Initialize audio processing*/
  extern short aud_set(AAPI_ACB *);    /* Set up an audio operation  */
  extern short aud_strt(AAPI_ACB *);   /* Start an audio operation   */
  extern short aud_ctrl(AAPI_ACB *);   /* Control an audio operation */
  extern short aud_term(AAPI_ACB *);   /* Terminate audio processing */
/*								     */
/*								     */
/********AAPI RETURN CODES********************************************/
/*								     */
#define AAPI_RC_00	   0	      /* Successful call	     */
#define AAPI_RC_01	3201	      /* "Audio" obj read error      */
#define AAPI_RC_02	3202	      /* "Audio" obj not found       */
#define AAPI_RC_03	3203	      /* "Volume" obj read error     */
#define AAPI_RC_04	3204	      /* "Volume" obj not found      */
#define AAPI_RC_05	3205	      /* "Escape" obj read error     */
#define AAPI_RC_06	3206	      /* "Escape" obj not found      */
#define AAPI_RC_07	3207	      /* "Escape" file read error    */
#define AAPI_RC_08	3208	      /* I/O bufr allocation failed  */
#define AAPI_RC_09	3209	      /* "audstart" pos invalid      */
#define AAPI_RC_10	3210	      /* "audend" pos invalid        */
#define AAPI_RC_11	3211	      /* "Escape" file seek error    */
#define AAPI_RC_12	3212	      /* DSP card not responding     */
#define AAPI_RC_13	3213	      /* DSP buffer alloc failed     */
#define AAPI_RC_14	3214	      /* DSP program not found	     */
#define AAPI_RC_15	3215	      /* DSP program not readable    */
#define AAPI_RC_16	3216	      /* "dspmode" invalid           */
#define AAPI_RC_17	3217	      /* Warning - syncronous I/O    */
				      /*  failed		     */
#define AAPI_RC_18	3218	      /* Unable to install audio ISR */
#define AAPI_RC_19	3219	      /* "Escape" file write error   */
#define AAPI_RC_20	3220	      /* Control ignored, control    */
/*					  queue overflow	     */
#define AAPI_RC_21	3221	      /* EMS Save Page Map failed    */
#define AAPI_RC_22	3222	      /* EMS Map Page failed	     */
#define AAPI_RC_23	3223	      /* EMS Restore Page Map failed */
#define AAPI_RC_24	3224	      /* Audio Card not installed    */
#define AAPI_RC_25	3225	      /* Aud card interrupts disabled*/
#define AAPI_RC_26	3226	      /* Device Drv not responding   */
#define AAPI_RC_27	3227	      /* Disk full - out of space    */
#define AAPI_RC_28	3228	      /* Audio object at maximum size*/
#define AAPI_RC_29	3229	      /* DSP overload - Attempted to */
				      /*  play stereo or HQ music    *-103*/
				      /*  and another audio type     */
				      /*  at the same time	     */
#define AAPI_RC_30	3230	      /* Recording media too slow,   */
				      /*  data lost during recording */
#define AAPI_RC_31	3231	      /* Process switched to bkgrnd, */
				      /*  operation cancelled	     */
#define AAPI_RC_32	3232	      /* Audio file at maximum size, */
				      /*  (addr space exceeded)      */
#define AAPI_RC_33	3233	      /* DSP running and requested   *-103*/
				      /*  oper requires reload of DSP*-103*/
#define AAPI_RC_34	3234	      /* MIDI audio type can not be  *-103*/
				      /*  played on this chan or OS  *-103*/
#define AAPI_RC_35	3235	      /* Device driver error occurred*-103*/
				      /*  when writing MIDI data     *-103*/
#define AAPI_RC_36	3236	      /* OS system call failed,      *-103*/
				      /*  system inconsistency	     *-103*/
#define AAPI_RC_37	3237	      /* MIDI buffer alloc failed    *-103*/
/********END AAPI FUNCTION DECLARATIONS*******************************/
