/*********************************************************************/
/*								     */
/*  INCLUDE NAME = record.h					     */
/*								     */
/*  DESCRIPTIVE NAME = AAPI Recording Example messages		     */
/*								     */
/*  COPYRIGHT = (C) Copyright IBM Corp. 1991.			     */
/*		All rights reserved.				     */
/*		Refer to "LICENSE.DOC" for information regarding     */
/*		the use of this file.				     */
/*								     */
/*								     */
/* Unless otherwise specified all messages are restricted to a	     */
/* maximum length of 80 visual characters per line.  Messages may    */
/* span multiple lines by inserting carriage return/linefeed (\r\n)  */
/* characters into the message. Total number of characters in the    */
/* message is restricted to 256.				     */
/*								     */
/*********************************************************************/
#define M_1 "Enter new file name for recording ===> "
#define M_2 "\n        Press any other key to stop......\n\r\n"
#define M_3 "Insufficient storage to complete operation.\n"
#define M_4 "\r\n\nOpen failed, file already exists.\r\n\n"
#define M_5 "\r\n\nOpen failed, file does not exist."
#define M_6 "\r\n\nGeneral error on file.\r\n\n"
#define M_7 "\r\n\nGeneral error on escape file.\r\n\n"
#define M_8 "DSP not responding.\n"
#define M_9 "Audio card software not installed (IBMxxxx.DSP).\n"
#define M_10 "Audio card software damaged or invalid (IBMxxxx.DSP).\n"
#define M_11 "Audio card not installed.\n"
#define M_12 "Audio device driver not installed or in use.\n"
/*********************************************************************/
/*  M-13 - Variable %d can expand to 4 visual characters.	     */
/*********************************************************************/
#define M_13 "Error, can not continue -  AAPI rc = %d\n"
/*********************************************************************/
/*  M-14 - Message M_43 is appended to this message.		     */
/*	   Maximum length is 60 characters or a new line	     */
/*	   must be started.					     */
/*********************************************************************/
#define M_14 "Recording time\\volume\\balance = "
#define M_15 "\nDisk is full.\n"
#define M_16 "\nAudio object is at maximum size.\n"
#define M_17 "\nRecording media too slow or fragmented.\n"
#define M_18 "Start or stop position invalid.\n"
#define M_19 " File type                                (1=AVC, Enter=RIFF) ==> "
#define M_20 " Desired sample rate  (0=8000, Enter=11025, 2=22050, 3=44100) ==> "
#define M_21 " Sample width in bits                (Enter=eight, 1=sixteen) ==> "
#define M_22 " Number of channels                    (Enter=mono, 2=stereo) ==> "
#define M_23 " AVC mode  (Enter=music, 2=voice, 3=stereo music, 4=HQ music) ==> "
#define M_24 " Input Source (0=mic, 1=left, 2=right, Enter=both, 4=low-mic) ==> "
#define M_25 " Monitor mode       (0=off, 1=compressed, Enter=uncompressed) ==> "
#define M_26 " Monitor mode                     (0=off, Enter=uncompressed) ==> "
#define M_27 " Format                 (Enter=Linear PCM, 2=mu-law, 3=A-law) ==> "
#define M_28 " Dither                                 (0-100 : Enter =  33) ==> "
#define M_29 " Master Volume                          (0-120 : Enter = 100) ==> "
#define M_30 " Fade to Volume                         (0-100 : Enter = 100) ==> "
#define M_31 " Length of fade in seconds             (0 - 64 : Enter =   0) ==> "
#define M_32 " Balance                   (0=Left - 100=Right : Enter =  50) ==> "
#define M_33 " Length of pan in  seconds             (0 - 64 : Enter =   0) ==> "
#define M_34 " Display volume/balance choices        (1 = yes, Enter =  no) ==> "
#define M_35 " Display other option choices          (1 = yes, Enter =  no) ==> "
#define M_36 " PS/2 speaker (right channel only)     (1 = on,  Enter = off) ==> "
#define M_37 " Signal processor track       (1 or 2, Enter = any available) ==> "
#define M_38 "\nPress F1 to start/pause/resume\n\r"
#define M_39 "\nUse the keys below to control volume/balance\n\r"
#define M_40 "    Cursor keys        -  Volume/Balance \n\r"
#define M_41 "    Home, End          -  Pans left/right over 7 seconds \n\r"
#define M_42 "    Page Up, Page Down -  Fades up/down over 7 seconds\n\r"
/*********************************************************************/
/*  M-43 - Variables represent					     */
/*	      Playing Time, Volume, Balance			     */
/*  This message is appended to M_14.				     */
/*  Message can expand to a maximum of 20 visual characters.	     */
/*********************************************************************/
#define M_43 "%lu %d %d       \r"
#define M_44 " Invalid value, try again or Ctrl Break to exit\n\r"
/*********************************************************************/
/*  M-45 - Message M_46 is appended to this message.		     */
/*	   Maximum length is 70 characters or a new line	     */
/*	   must be started.					     */
/*********************************************************************/
#define M_45 "Recording time = "
/*********************************************************************/
/*  M-46 - Variable represents Recording Time			     */
/*  This message is appended to M_45.				     */
/*  Message can expand to a maximum of 10 visual characters.	     */
/*********************************************************************/
#define M_46 "%lu     \r"
#define M_47 "\nM-ACPA Audio API Sample Record Program \n\r"
#define M_48 "(C) Copyright IBM Corp. 1991 - All rights reserved.\n\r\n"
