/*  The xmakeini.exe wrapper
 *  Use it like this:
 *  
 *  mkini file.ini file1.rc file2.rc ... fileN.rc
 */

'@echo off'

bootdrv = value('BOOTDRV',, 'OS2ENVIRONMENT')
sysdrv  = value('SYSDRV',, 'OS2ENVIRONMENT')

crlf    = '0d 0a'x
sedfile = bootdrv || '\var\tmp\paths.sed'
cfg     = sysdrv  || '\tools\rc.cfg'

parse arg ini args

/* read cfg file     */
call stream cfg,  'c',  'open read'

/* apply .rc file */
do while lines(cfg) > 0
  line = linein(cfg)
  interpret(line)
end

call stream cfg,  'c',  'close'


do while words(args) > 0
  parse var args rcfile args

  fn = rcfile
  p = lastpos('\', fn)
  /* delete path               */
  if p > 0 then fn = substr(fn, p + 1)
  p = pos('.rc', fn)
  /* delete an '.rc' extension */
  if p > 0 then fn = delstr(fn, p)
  /* get variable name         */
  fn = value('rc.' || fn)

  /* if this .rc is enabled */
  if fn = 'yes' then do
    call charout, ini || ': ' || 'applying ' || rcfile || '...'

    'if exist ' || ini || ' attrib -s -r -h ' || ini || ' 2>&1 >\dev\nul'

    /* execute command  */
    bootdrv || '\os2\xmakeini.exe ' || ini || ' -s ' || sedfile ||,
       ' ' || rcfile || ' 2>&1 >\dev\nul'

    /* check error code */
    if rc = 0 then do
      /* succeeded */
      'if exist ' || ini || ' attrib +s +r +h' || ini || ' 2>&1 >\dev\nul'
      call charout, ' ok' || crlf
    end; else
      /* failed    */
      call charout, ' fail, rc = ' || rc || crlf
  end
end
