/*
 *      INSTALL.CMD Generic MAC Wrapper Driver - Copyright Willibald Meyer, netlabs.org 2005-2006
 *      Installation for Generic MAC Wrapper Driver - Copyright C.Langanke 2005-2006
 *
 *      Syntax: INSTALL
 *
 *      This program installs the Generic MAC Wrapper Driver for usage
 *      with the MPTS.
 *
 */
/* The first comment is used as online help text */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine( 2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = Info
 Subtitle  = STRIP(SUBSTR(SourceLine( 3), 3));

 env          = 'OS2ENVIRONMENT';
 TRUE         = (1 = 1);
 FALSE        = (0 = 1);
 CrLf         = '0d0a'x;
 Redirection  = '> NUL 2>&1';
 '@ECHO OFF'

 /* OS/2 Error codes */
 ERROR.NO_ERROR           =   0;
 ERROR.INVALID_FUNCTION   =   1;
 ERROR.FILE_NOT_FOUND     =   2;
 ERROR.PATH_NOT_FOUND     =   3;
 ERROR.ACCESS_DENIED      =   5;
 ERROR.NOT_ENOUGH_MEMORY  =   8;
 ERROR.INVALID_FORMAT     =  11;
 ERROR.INVALID_DATA       =  13;
 ERROR.NO_MORE_FILES      =  18;
 ERROR.WRITE_FAULT        =  29;
 ERROR.READ_FAULT         =  30;
 ERROR.GEN_FAILURE        =  31;
 ERROR.SHARING_VIOLATION  =  32;
 ERROR.INVALID_PARAMETER  =  87;
 ERROR.ENVVAR_NOT_FOUND   = 203;

 GlobalVars = 'Title CmdName CrLf env TRUE FALSE Redirection ERROR.';
 SAY;

 /* eventually show help */
 ARG Parm .
 IF (POS('?', Parm) > 0) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 call RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs

 /* dafault values */
 GlobalVars = GlobalVars 'CallDir AppName Vendor.';
 rc = ERROR.NO_ERROR;

 IniAppName         = 'Generic MAC Wrapper Driver';
 IniKeyVersion      = 'Version';
 IniKeyPath         = 'Path';

 VendorList         = 'Atheros Broadcom Intel Marvel Nforce Other';
 ProgStem           = 'genmac';
 ReqProgramsList    = 'unzip.exe';

 fDriverPackInstalled = FALSE;

 WpsFolderECS       = '<WP_CONFIG_NET>';
 WpsFolderOS2       = '<WP_CONFIG>';
 HelpObjectId       = '<GENMAC_HELP>';
 HelpShadowObjectId = '<GENMAC_HELP_SHADOW>';
 HelpFile           = 'inf\genmac.inf';

 CallDir  = GetCallDir();
 PARSE VALUE TRANSLATE( VALUE( 'PATH',,env)) WITH '\OS2;' -2 BootDrive +2;

 DO 1
    /* check if called by driver pack intaller */
    PARSE ARG DriverPackDir;
    DriverPackDir = STRIP( DriverPackDir);
    IF (DriverPackDir = '') THEN
    DO
       SAY Title;
       SAY SubTitle;
       SAY;
    END;

    /* check for required programs */
    MissingProgams = '';
    DO WHILE (ReqProgramsList \= '')
       PARSE VAR ReqProgramsList ReqProgram ReqProgramsList;
       IF (SysSearchpath( 'PATH', ReqProgram) = '') THEN
          MissingProgams = MissingProgams ReqProgram ;
    END;
    IF (MissingProgams \= '') THEN
    DO
       SAY 'error: the following required program files could not be found:';
       SAY '     ' MissingProgams;
       rc = 2;
       LEAVE
    END;

    /* determine some parameters and filenames */
    ConfigFile = BootDrive'\config.sys';
    MPTSDir = GetProgramPath( 'MPTS.EXE');
    MacsDir = MPTSDir'\macs';
    NetBindExec = MPTSDir'\protocol\netbind.exe';

    InstallDir = BootDrive'\'ProgStem;
    HelperExecutable = InstallDir'\driver\helperw.exe';
    UnlockExec = CallDir'\bin\unlock.exe';
    AppVersion = ReadVersion();

    /* determine zip file masks */
    PARSE VAR AppVersion  vMajor'.'vMinor;
    PackageFileMask = ProgStem''vMajor''vMinor'_#.zip';
    DriverFileMask  = 'driver_#.zip'

    IF (AppVersion = '') THEN
    DO
       SAY 'error: cannot detect package version informtion.';
       rc = 2;
       LEAVE
    END;

    SAY 'GenMac installation directory:' InstallDir;
    SAY 'GenMac version               :' AppVersion;
    SAY 'MPTS MAC driver directory    :' MacsDir;
    SAY

    /* copy files to default program directory */
    IF (TRANSLATE( InstallDir) \= TRANSLATE( CallDir)) THEN
    DO
       /* unlock helper executable, if exists */
       IF (FileExist( HelperExecutable)) THEN
       DO
          SAY '- unlock helper executable';
          '' UnlockExec HelperExecutable Redirection;
       END;

       SAY '- copying files to install dir'
       rc = CopyFiles( CallDir'\file_id.diz', InstallDir, TRUE);
       rc = CopyFiles( CallDir'\install.cmd', InstallDir, TRUE);
       rc = CopyFiles( CallDir'\readme.cmd',  InstallDir, TRUE);
       rc = CopyFiles( CallDir'\bin\*',       InstallDir'\bin',    TRUE);
       rc = CopyFiles( CallDir'\inf\*',       InstallDir'\inf',    TRUE);
       rc = CopyFiles( CallDir'\driver\*',    InstallDir'\driver', TRUE);
    END;

    /* set INI information */
    SAY '- setup version information'
    rcx = SysIni(, IniAppName, IniKeyVersion, AppVersion'0'x);
    rcx = SysIni(, IniAppName, IniKeyPath,    InstallDir'0'x);

    /* copy main driver files */
    SAY '- copying driver files to MPTS'
    rc = CopyFiles( CallDir'\driver\genm32*.os2', MacsDir, FALSE);
    rc = CopyFiles( CallDir'\driver\genm32*.msg', MPTSDir, FALSE);

    /* install helper executable file */
    SAY '- updating system configuration'
    rc = InstallHelper( ConfigFile, HelperExecutable, NetBindExec);

    /* unpack available driver packs */
    IF (DriverPackDir = '') THEN
       DriverPackDir = CallDir;
    IF (InstallDriverPack( ProgStem, DriverPackDir, InstallDir,,
                           PackageFileMask, DriverFileMask, VendorList)) THEN
       fDriverPackInstalled = TRUE;
    IF (FileExist( InstallDir'\nif\w*.nif')) THEN
       fDriverPackInstalled = TRUE;

    /* determine if ECS config folder exists */
    IF (SysSetObjectData( WpsFolderECS, ';')) THEN
       ObjLocation = WpsFolderECS
    ELSE
       ObjLocation = WpsFolderOS2;

    /* create WPS objects */
    SAY '- create help objects'

    ObjTitle = IniAppName 'V'AppVersion
    ObjSetup = 'EXENAME=VIEW.EXE;PARAMETERS='InstallDir'\'HelpFile';PROGTYPE=PM;OBJECTID='HelpObjectId';'
    rcx = SysCreateObject( 'WPProgram', ObjTitle, ObjLocation, ObjSetup, 'U');

    ShadowLocation = '<WP_DESKTOP>';
    ShadowSetup = 'SHADOWID='HelpObjectId';OBJECTID='HelpShadowObjectId';'
    rcx = SysCreateObject( 'WPShadow', '.', ShadowLocation, ShadowSetup, 'U');

    /* present message with TODOs */
    IF (\fDriverPackInstalled) THEN
    DO
       SAY;
       SAY '  WARNING: A GenMac driver pack needs to be installed before you can';
       SAY '  configure a driver in MPTS. Please check http://genmac.netlabs.org for the files'
       SAY;
       CheckList = VendorList;
       DO WHILE (CheckList \= '')
          PARSE VAR CheckList Vendor CheckList;
          SAY '  -' IdInsert( PackageFileMask, Vendor)
       END;
       SAY '';
    END;
    ELSE
    DO
       /* copy NIF files */
       SAY '- copying description files to MPTS'
       rc = CopyFiles( InstallDir'\nif\*', MacsDir, TRUE);

       SAY;
       SAY '  Please configure the driver corresponding to your hardware within MPTS.';
       SAY '  After that, in order to load the new or updated driver(s),';
       SAY '  REBOOT YOUR SYSTEM.';
    END;
 END;

 SAY;
 'PAUSE';
 EXIT( rc);

/* ------------------------------------------------------------------------- */
HALT:
 SAY 'Abbruch durch Benutzer.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 /* show title */
 SAY Title;
 SAY;

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help text */
 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 /* close file */
 rc = LINEOUT(Thisfile);

 RETURN('');

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
GetDrivePath: PROCEDURE
 PARSE ARG FileName

 FullPath = FILESPEC('D', FileName)||FILESPEC('P', FileName);
 IF (FullPath \= '') THEN
    RETURN(LEFT(FullPath, LENGTH(FullPath) - 1));
 ELSE
    RETURN('');

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 PARSE ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ---------------------------------------------------------------------- */
AssembeFilename: PROCEDURE
 PARSE ARG FilePath, FileName;
 IF (RIGHT( FilePath, 1) = '\') THEN
    RETURN( FilePath''FileName);
 ELSE
    RETURN( FilePath'\'FileName);

/* ========================================================================= */
GetProgramPath: PROCEDURE EXPOSE (GlobalVars);
 PARSE ARG ExeName

 ProgramPath = '';

 DO 1
   /* determine program fullname */
   ProgramPath = SysSearchPath( 'PATH', ExeName);
   IF (ProgramPath = '') THEN
      LEAVE;

   /* isolate path if desired */
      ProgramPath = LEFT( ProgramPath, LASTPOS( '\', ProgramPath) - 1);
 END;

 RETURN( ProgramPath);

/* ========================================================================= */
CopyFiles: PROCEDURE EXPOSE (GlobalVars);
 PARSE ARG SourceFiles, TargetDir, fIncludeSubDirs

 rc = ERROR.NO_ERROR;

 DO 1
    /* determine static part of source file path */
    SourceFiles = STREAM( SourceFiles, 'C', 'QUERY EXISTS');
    IF (SourceFiles = '') THEN
    DO
       SAY 'error: package files not found.';
       EXIT( ERROR.PATH_NOT_FOUND);
    END;
    BasePathLen = LASTPOS( '\', SourceFiles) + 1;

    /* search files */
    SearchOpts = 'FO';
    IF (fIncludeSubDirs) THEN
       SearchOpts = SearchOpts'S';
    rc = SysFileTree( SourceFiles, 'File.', SearchOpts);
    IF (rc \= 0) THEN
    DO
       SAY 'error in SysFileTree, reboot required!';
       EXIT( 99);
    END;

    /* copy file by file */
    DO i = 1 TO File.0
       SourceFile = File.i;
       TargetFile = TargetDir'\'SUBSTR( File.i, BasePathLen);
       TargetPath = LEFT( TargetFile, LASTPOS( '\', TargetFile) - 1);
       rc = MakePath( TargetPath);
       'COPY' SourceFile  TargetPath'\' ReDirection;
    END;

 END;

 RETURN( rc);

/* ========================================================================= */
MakePath: PROCEDURE
 PARSE ARG Path;

 DO 1
    /* tokenize path parts */
    PathNames = TRANSLATE( Path, ' ', '\');
    DO i = 2 TO WORDS( PathNames)
       ThisPath = LEFT( Path, WORDINDEX( PathNames, i) - 1 + LENGTH( WORD( PathNames, i)));
       rc = SysMkDir( ThisPath);
    END;

 END;

 RETURN( 0);

/* ========================================================================= */
ReadVersion: PROCEDURE EXPOSE (GlobalVars);

 AppVersion = '';
 DescFile   = 'file_id.diz';

 DO 1
    /* read description file */
    IF (STREAM( DescFile, 'C', 'OPEN READ') \= 'READY:') THEN
       LEAVE;

    PARSE VALUE LINEIN( DescFile) WITH '('LitVersion')'.
    IF (LENGTH( LitVersion) \= 5) THEN
       LEAVE;

    PARSE VAR LitVersion . +1 AppVersion;
    AppVersion = TRANSLATE( STRIP( AppVersion));

 END;

 /* cleanup */
 rcx = STREAM( DescFile, 'C', 'CLOSE');
 RETURN( AppVersion);

/* ====================================================================== */
IdInsert: PROCEDURE
 PARSE ARG Str, Id;
 VerPos = POS( '#', Str);
 IF (VerPos > 0) THEN
 DO 
    Str = LEFT( Str, VerPos - 1)''Id''SUBSTR( Str, VerPos + 1);
 END;
 RETURN( Str);

/* ========================================================================= */
ReadFile: PROCEDURE EXPOSE (GlobalVars);
 PARSE ARG File;

 Contents = '';

 DO 1

    FileSize = STREAM( File, 'C', 'QUERY SIZE');
    IF (FileSize = 0) THEN
       LEAVE;

    IF (STREAM( File, 'C', 'OPEN READ') \= 'READY:') THEN
       LEAVE;

    Contents = CHARIN( File, 1, FileSize);

    rcx = STREAM( File, 'C', 'CLOSE');
 END;

 RETURN( Contents);

/* ========================================================================= */
InstallHelper: PROCEDURE EXPOSE (GlobalVars);
 PARSE ARG ConfigFile, HelperExec, NetBindExec;

 DO 1

    /* create tmp file */
    TmpFile = SysTempFilename( VALUE('TMP',,env)'\gnminst.???');
    IF (STREAM( TmpFile, 'C', 'OPEN WRITE') \= 'READY:') THEN
    DO
       SAY 'error: cannot write' TmpFile;
       LEAVE;
    END;

    /* open config file */
    IF (STREAM( ConfigFile, 'C', 'OPEN READ') \= 'READY:') THEN
    DO
       SAY 'error: cannot read' ConfigFile;
       LEAVE;
    END;

    /* process file */
    NetBindExecUc = TRANSLATE( NetBindExec);
    HelperExecUc  = TRANSLATE( HelperExec);
    fNetBindFound = FALSE;
    fHelperAdded  = FALSE;


    /* always put helper app at first line of config.sys */
    rcx = LINEOUT( TmpFile, 'RUN='HelperExecUc);

    DO WHILE (LINES( ConfigFile))

       ThisLine = LINEIN( ConfigFile);
       fSkipLine = FALSE;

       /* tokenize line */
       PARSE VALUE TRANSLATE( ThisLine) WITH ThisStatement'='ThisValue
       ThisStatement = STRIP( ThisStatement);
       ThisValue     = STRIP( ThisValue);

       SELECT
          WHEN (ThisStatement = 'CALL') THEN
          DO
             /* if this is the netbind call, prepend run of helper */
             IF (ThisValue = NetBindExecUc) THEN
                fNetBindFound = TRUE;
          END;

          WHEN (ThisStatement = 'RUN') THEN
          DO
             ExecName = FILESPEC( 'N', WORD( ThisValue, 1));
             PARSE VAR ExecName ExeBaseName'.'ExeExtension;

             /* if this is a run for the helper, check to eliminate it */
             /* also eliminate Willibalds special versions */
             IF ((WORDPOS( ExeBaseName, 'HELPERW HELPERW1 HELPER1') > 0) &,
                 (ExeExtension = 'EXE')) THEN
                fSkipLine = TRUE;
          END;

          OTHERWISE NOP;

       END;

       IF (\fSkipLine) THEN
          rcx = LINEOUT( TmpFile, ThisLine);
    END;
    rcx = STREAM( ConfigFile, 'C', 'CLOSE');
    rcx = STREAM( TmpFile,    'C', 'CLOSE');

    /* ------------------------------------------ */

    /* if nothing changed, remove tmp file and exit */
    OldConfig = ReadFile( ConfigFile);
    NewConfig = ReadFile( TmpFile);
    IF (OldConfig = NewConfig) THEN
    DO
       rcx = SysFileDelete( TmpFile);
       SAY '  no configuration change necessary.';
       LEAVE;
    END;

    /* get original name of config file */
    rc = SysFileTree( ConfigFile, 'File.', 'FO');
    ConfigFile = File.1;

    /* create backup copy */
    DO i = 1 TO 999
       BackupFile = OVERLAY( RIGHT( i, 3, '0'), ConfigFile, LASTPOS( '.', ConfigFile) + 1);
       IF (\FileExist( BackupFile)) THEN
          LEAVE;
    END;
    'COPY' ConfigFile BackupFile Redirection;
    SAY '  modified' ConfigFile', created backup' BackupFile

    /* copy over updated version */
    'COPY' TmpFile ConfigFile Redirection;
    rcx = SysFileDelete( TmpFile);
 END;

 RETURN( 0);

/* ========================================================================= */
InstallDriverPack: PROCEDURE EXPOSE (GlobalVars);
 PARSE ARG ProgStem, DriverPackDir, InstallDir,,
           PackageFileMask, DrvZipfileMask, VendorList;

 fInstalled = FALSE;

 DO 1
    /* search driver packages */
    CheckList = VendorList;
    DO WHILE (CheckList \= '')
       PARSE VAR CheckList Vendor CheckList;

       Msg = '- installing driver pack for drivers of' Vendor

       /* determine filenames */
       ZipName      = AssembeFilename( DriverPackDir, IdInsert( PackageFileMask, Vendor));
       InnerZipName = AssembeFilename( DriverPackDir, IdInsert( DrvZipfileMask, Vendor));

       /* check for package zip files */
       IF (FileExist( ZipName)) THEN
       DO
          SAY Msg;
          'unzip -qo' ZipName FILESPEC( 'N', InnerZipName);
          'unzip -qo' InnerZipName '-d' InstallDir;
          rcx = SysFileDelete( InnerZipName);
          fInstalled = TRUE;
          ITERATE;
       END;

       /* check for inner zip files */
       IF (FileExist( InnerZipName)) THEN
       DO
          SAY Msg;
          'unzip -qo' InnerZipName '-d' InstallDir;
          fInstalled = TRUE;
       END;
    END;
 END;

 RETURN( fInstalled);

