/**************************************************************************/
/* instmmvw.cmd                                                           */
/*                                                                        */
/* This REXX command file will install the MMParts Heirarchy. Use -R as an */
/* argument to instmmvw to remove the MMView Heirarchy.                   */
/*                                                                        */
/* Example:                                                               */
/*    instmmvw               (installs)                                   */
/*    instmmvw -r            (removes)                                    */
/**************************************************************************/

arg deinstalling

if deinstalling = "-R" then
   say "Removing MMParts WPS classes"
else
   say "Installing MMParts WPS classes"

/* Load all the Rexx Util functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call RxFuncAdd 'RxWinReplaceObjectClass', 'mmparts', 'RxWinReplaceObjectClass'

MMClasses.   = ''
MMClasses.1  = 'MMDataFile'
MMClasses.2  = 'MMImage'
MMClasses.3  = 'MMAudio'
MMClasses.4  = 'MMVideo'
MMClasses.5  = 'MMMIDI'
MMClasses.6  = 'MMTarga'
MMClasses.7  = 'MMTIFF'
MMClasses.8  = 'MMGIF'
MMClasses.9  = 'MMPCX'
MMClasses.10 = 'MMPhotoCD'
MMClasses.11 = 'MMAVC'
MMClasses.12 = 'MMMMotion'
MMClasses.13 = 'MMDIB'
MMClasses.14 = 'MMDevice'
MMClasses.15 = 'MMCDDevice'
MMClasses.16 = 'MMLVDDevice'
MMClasses.17 = 'MMVolume'
MMClasses.18 = 'MMVOC'
MMClasses.19 = 'MM_AU'
MMClasses.20 = 'MMAU'
MMClasses.21 = 'MMAIF'
MMClasses.22 = 'MMIFF'
MMClasses.23 = 'MMSNDF'
MMClasses.24 = 'MMAVI'
MMClasses.25 = 'MMFLI'
MMClasses.26 = 'MMMPG'
MMClasses.27 = 'MMJPG'
MMClasses.28 = 'MMWAV'
MMClasses.29 = 'MMMOV'
MMClasses.30 = 'MMFolder'
MMClasses.31 = 'MMFinder'

x = 1;

do while MMClasses.x <> ''   /* loop until no more classes */
   if deinstalling = '-R' then
      if SysDeregisterObjectClass(MMClasses.x) then
         say MMClasses.x 'class deregistration successful'
      else
         say MMClasses.x 'class deregistration failed'
   else
      if SysRegisterObjectClass(MMClasses.x, "mmparts") then
         say MMClasses.x 'class registration successful'
      else
         say MMClasses.x 'class registration failed'
   x = x + 1
end

/* Do MMBitmap Replacement Class */

if deinstalling = '-R' then
   do
      if RxWinReplaceObjectClass('WPBitmap','MMBitmap', '0') then
         say 'UnReplace MMBitmap successful'
      else
         say 'UnReplace MMBitmap failed'

      if SysDeregisterObjectClass('MMBitmap') then
         say 'MMBitmap class deregistration successful'
      else
         say 'MMBitmap class deregistration failed'

   end
else
   do
      if SysRegisterObjectClass('MMBitmap', 'MMBIT') then
         say 'MMBitmap class registration successful'
      else
         say 'MMBitmap class registration failed'

      res = SysIni(, 'PM_InstallClassReplacement', 'WPBitmap', 'MMBitmap'x2c('0') )
      say 'Replacing WPBitmap with MMBitmap successful (res=' res ')'
   end

/* Do MMShadow Replacement Class */

if deinstalling = '-R' then
   do
      if RxWinReplaceObjectClass('WPShadow','MMShadow', '0') then
         say 'UnReplace MMShadow successful'
      else
         say 'UnReplace MMShadow failed'

      if SysDeregisterObjectClass('MMShadow') then
         say 'MMShadow class deregistration successful'
      else
         say 'MMShadow class deregistration failed'

   end
else
   do
      if SysRegisterObjectClass('MMShadow', 'MMSHD') then
         say 'MMShadow class registration successful'
      else
         say 'MMShadow class registration failed'

      res = SysIni(, 'PM_InstallClassReplacement', 'WPShadow', 'MMShadow'x2c('0') )
      say 'Replacing WPShadow with MMShadow successful (res=' res ')'
   end

exit




