/* REXX Procedure for Code Page Convertor */
arg prog
i = words(prog)
if (( prog = '?') | (i > 9) | ((i < 8) & (i > 0 )) )  then do
   say ""
   say "Syntax: 'textconv [p1 p2 p3 p4 p5 p6 p7 p8 [p9]]'"
   say ""
   say "Where:"
   say "  p1 - Input Filename."
   say "  p2 - Input file Code Page."
   say "  p3 - Input file Text Type."
   say "  p4 - Input text Symmetric Swapping."
   say "  p5 - Output Filename."
   say "  p6 - Output file Code Page."
   say "  p7 - Output file Text Type."
   say "  p8 - Output text Symmetric Swapping."
   say "  p9 - Delimiter. If other than SPACE, only text between these characters"
   say "                  is converted."
   say ""
   say "Possible Values:"
   say "  p1,p5 - Filename"
   say "  p2,p6 - Code Page values:"
   say "            862  - PC DOS"
   say "            803  - IBM Mainframe Old code (EBCDIC)"
   say "            424  - IBM Mainframe Bulletin code (EBCDIC)"
   say "            1255  - Hebrew Windows"
   say "  p3,p7 - Text Type values:"
   say "            vltr - Visual Left-to-right"
   say "            vrtl - Visual Right-to-left"
   say "            impl - Implicit Left-to-right"
   say "            impr - Implicit Right-to-Left"
   say "            impc - Implicit Contextual"
   say "  p4,p8  - On, Off"
   say "  p9     - Any ASCII character (including SPACE)"
   say '           if  "  is specified it should be preceded with'
   say '           backslash ( \" ).'
   end
else   do
   textcon1.exe prog
      end
