/*  Generate dumps of XPager and XWP Hook
 *  configuration from os2.ini. It is in
 *  the REXX .cmd file, which restores
 *  configuration when called from startup.cmd
 *  (c) 2014, Sep 09, Team Boot/2
 *  use it like this:
 *
 *  [c:\] dumpkey "PM_Workplace:WindowListPos" "SavePos" >winlist.cmd
 */

parse arg app key
 
a.crlf = '0d 0a'x
a.strlen = 24

call header

if app = '' | key = '' then do
  call keydump 'XWorkplace:Hook', 'Config'
  call keydump 'XWorkplace:Hook', 'PagerConfig'
  call keydump 'XWorkplace:Hook', 'PagerWinPos'
end; else do
  if pos('"', app) > 0 then app = strip(app, 'B', '"')
  if pos('"', key) > 0 then key = strip(key, 'B', '"')
  call keydump app, key
end

exit 0
/* ===================================== */
keydump: procedure expose a.
app = arg(1)
key = arg(2)

data   = iniin(app, key)
len = length(data)

say "cfg = ,"

pos = 0
do forever
  i = 0
  str = ''''
  do forever
    /*  process a single line 
     *  of a hex dump
     */
    pos = pos + 1
    i = i + 1
    
    byte = c2x(substr(data, pos, 1))
    str  = str || byte
    
    if pos = len then
      leave
    
    if i = a.strlen then
      leave
      
    str  = str || ' '
  end
    
  if pos = len then do
    str = str || '''x'  || a.crlf
    call charout, str
    leave
  end; else
    str = str || '''x ||,' || a.crlf

  call charout, str
end

say
say "call sysini 'USER', '" || app || "', '" || key || "', cfg"
say

return
/* ===================================== */
header:

say "/* rexx */"
say
say "call RxFuncAdd 'SysIni', 'rexxutil', 'SysIni'" 
say

return
/* ===================================== */
iniin: procedure expose a.
app = arg(1)
key = arg(2)

x = sysini('USER', app, key)

return x
/* ===================================== */
