/* bobixx */

ndDrive = 'w:\iso\'

/* parse command line */

CmdLine = ARG(1)
IF (ARG() = 0) | (POS('?', CmdLine) > 0) THEN CALL Help

verbose = 0
beep = 0
chdir = 0
wps = 0
IF LEFT(CmdLine, 1) = '-' THEN DO
    PARSE ARG keys fName
    keys = TRANSLATE(keys)
    IF POS('H', keys) > 0 THEN CALL Help
    verbose = POS('V', keys)
    beep = POS('B', keys)
    chdir = POS('C', keys)
    wps = POS('W', keys)
END
ELSE DO
    PARSE ARG fName
END

fName = FullPath(fName)
diskID = TRANSLATE(fName, '!__', ':\ ')
MountPoint = ndDrive''diskID

/* try to find existing mount point; mount if not found, otherwise unmount  */

CALL RxFuncAdd 'NdRxLoadFuncs', 'NDCALLS', 'NdRxLoadFuncs'
CALL NdRxLoadFuncs

IF FindMountPoint(ndDrive, diskID, verbose) = 0 THEN DO
    IF verbose > 0 THEN SAY 'Creating mount point: 'MountPoint
    rc = NdRxCreateMountPoint(MountPoint)
    IF rc <> 0 THEN ErrorExit('Cannot create mount point 'MountPoint' (errcode = 'rc')', 2)

    IF verbose > 0 THEN SAY 'Mounting ISO image to 'MountPoint'\'
    fsType = SelectPlugin(fName)
    rc = NdRxMount(fsType, MountPoint, fName, 'R')
    IF rc <> 0 THEN DO
	    IF verbose > 0 THEN SAY 'Deleting mount point: 'MountPoint
        rc1 = NdRxDeleteMountPoint(MountPoint)
        ErrorExit('Cannot mount 'fName' to 'MountPoint' (errcode = 'rc')', 3)
	END
    SAY fName' was mounted to 'MountPoint'\'
    IF chdir > 0 THEN CALL CD(MountPoint)
    IF wps > 0 THEN DO
    	CALL RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"
    	CALL SysLoadFuncs
        rc = SysOpenObject(MountPoint, 0, 1)
	END
END
ELSE DO
    IF verbose > 0 THEN SAY 'Unmounting ISO image at 'MountPoint'\'
    rc = NdRxUnmount(MountPoint, 0)

    IF verbose > 0 THEN SAY 'Deleting mount point: 'MountPoint
    rc = NdRxDeleteMountPoint(MountPoint)
    IF rc <> 0 THEN ErrorExit('Cannot delete mount point 'MountPoint' (errcode = 'rc')', 2)

    SAY fName' was unmounted '
END
EXIT 0

/* procedures */

/* searches for existing mount point, returns 1 if found */

FindMountPoint: PROCEDURE EXPOSE beep
    PARSE ARG ndDrive, diskID, verbose
    rc = NdRxGetMount(ndDrive, infostem, mountpointstem, resourcestem)
    IF rc <> 0 THEN ErrorExit('Incorrect ND drive letter 'ndDrive' at line 3 of this script', 4)
    DO i = 1 TO mountpointstem.0
	    IF mountpointstem.i = diskID THEN DO
            IF verbose > 0 THEN SAY 'Found mount point: 'diskID
            RETURN 1
        END
	END
    IF verbose > 0 THEN SAY 'Mount point 'diskID' not found'
RETURN 0

/* self explanatory */

Help: PROCEDURE
    SAY 'Syntax: isomount [-vbcwh] image_file'
    SAY '  Keys: v - verbose'
    SAY '        b - beep on errors'
    SAY '        c - change directory to mounted resource'
    SAY '        w - view mounted resource in WPS'
    SAY '        h - help'
    SAY '  image_file: full path to ISO or RSJ image file'
    SAY '              or its name, if mounting from current directory'
    SAY ''
    SAY 'First launch mounts ISO|RSJ image specified to NDFS tree.'
    SAY 'Second launch with the same parameters unmounts it.'
    EXIT 1
RETURN

/* returns full path if succeed, otherwise fails :) 	*/
/* strips double quotes from file name                  */

FullPath: PROCEDURE EXPOSE beep
    PARSE ARG fName
    IF LENGTH(fName) = 0 THEN CALL Help
    fName = TRANSLATE(fName, '\', '/')
	IF SUBSTR(fName, 1, 1) = '"' THEN fName = SUBSTR(fName, 2, LENGTH(fName)-2)
    IF SUBSTR(fName, 2, 2) = ':\' THEN RETURN fName
    IF (LEFT(fName, 1) <> '\') & (SUBSTR(fName, 2, 1) <> ':') & (LEFT(fName, 1) <> '.')
    THEN RETURN DIRECTORY()'\'fName
    ErrorExit('Please specify full path to image file', 1)
RETURN

/* check image: ISO or RSJ */

SelectPlugin: PROCEDURE EXPOSE beep
    PARSE ARG fName
	rc = stream(fName, 'c', 'open')
    IF rc <> 'READY:' THEN ErrorExit('Cannot open 'fName, 1)
    IF charin(fName, , 3) = 'RSJ' THEN fsType = 'rsjfs'
	ELSE fsType = 'isofs'
	rc = stream(fName, 'c', 'close')
RETURN fsType

ErrorExit:
    PARSE ARG errText, errLevel
    CALL errBeep
    SAY errText
    EXIT errLevel
RETURN

errBeep:
    IF beep > 0 THEN DO
        BEEP(349,125)
        BEEP(349,125)
        BEEP(349,125)
        BEEP(294,250)
	END
RETURN

CD: PROCEDURE
    PARSE ARG dir
    '@echo off'
    SUBSTR(dir, 1, 2)
    'cd 'SUBSTR(dir, 3)
RETURN

/*
errorlevel:
 0 - ok
 1 - bad parameters
 2 - error creating/deleting mount point
 3 - error while mount/unmount
 4 - bad ND drive letter

Dmitry Ban, 2003
ban@gate.itep.ru
*/

