/*  Phone controlling script
 *  (c) 2009, Nov 26
 *  _valerius (at) mail (dot) ru
 *  this script is licensed under 
 *  BSD license.
 */

/* Global configuration  */
cfg.port  = 'com6'
cfg.speed = 460800
cfg.init  = 'ate1x4&c1&d2'
cfg.ussd.balance = '*100#' /* 'AA184C3602' alt_to_ucs2('*100#') */
cfg.debug = 1

/* common variables stem */
a.hdl   = ''
a.remaining = ''
a.cr    = '0d'x
a.lf    = '0a'x
a.crlf  = '0d 0a'x
a.ctrlz = '1a'x
a.tab   = '09'x
a.cp    = 'GSM' /* 'UCS2'?, 'IRA'? */

/* response stem */
resp.ret   = ''

/* Load needed functions from DLLs */
call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs
call RxFuncAdd 'RxAsyncLoadFuncs', 'RXASYNC', 'RxAsyncLoadFuncs'
call RxAsyncLoadFuncs

parse arg section cmd parms

/*
say alt_to_ucs2("*100#")
exit
say _7bits_pack('*100#')
exit
say alt_to_ucs2("GSM")
exit
say ucs2_decode("041E0442043204350442043D043E043500200441043E043E043104490435043D04380435002E")
exit

*MTSMENU: "MegaFonPRO", 0, 7
1:"041C0435043304300424043E043D"
2:"0420043004370432043B043504470435043D0438044F"
3:"0421043F043E04400442"
4:"041D043E0432043E044104420438"
5:"04240438043D0430043D0441044B"
6:"0421043F044004300432043A0430"
7:"041E043104490435043D04380435"
*/

call mdm_init
/* call modem_init_func */

/* parse command line */
select
  when section = 'atcmd' then
    call atcommand cmd
  when section = 'init' then
    call modem_init_func
  when section = 'balance' then
    call check_balance
  when section = 'signal' then
    call check_signal
  when section = 'pin' then
    call check_pin cmd
  when section = 'ussd' then
    call send_ussd cmd
  when section = 'sms'  then do
    select
      when cmd = 'send' then do
        call smssend parms
      end
      when cmd = 'list' then do
        call smslist parms
      end
      when cmd = 'view' then do
        call smsview parms
      end
      when cmd = 'del'  then
        call smsdel parms
      when cmd = 'store'  then
        call smsstore parms
      otherwise call help ""
    end
  end
  otherwise call help ""
end

call mdm_done


exit 0
/*** ================== ***/
atcommand: procedure expose a. resp. cfg.
cmd = arg(1)

rc = RxAsyncWrite(a.hdl, 0, cmd || a.cr, 'a.remaining')
if rc \= 0 then call errwr
parse value msgread() with msg
say msg
cfg.debug = 1


return
/*** ================== ***/
smslist: procedure expose a. resp. cfg.
box = arg(1)

if       box = ''       then  box = 0
if       box = 'inbox'  then  do; box = 1; msgtype = 0; end
else; if box = 'outbox' then  do; box = 2; msgtype = 2; end
else; if box = 'sent'   then  do; box = 3; msgtype = 2; end
else; do; box = 1; msgtype = 0; end

rc = RxAsyncWrite(a.hdl, 0, 'at+cmgl=' || box || a.cr, 'a.remaining')
if rc \= 0 then call errwr

inp = ''
rc = 0
resp.0 = 2
resp.1 = '+CMGL: '
resp.2 = 'OK'
do until rc = 2
  rc = chkresp()
  if rc = 1 then do
    parse value resp.ret with n ',' . ',' . ',' .
    call outp '----------------------------------------------------------------------------' || a.crlf
    call outp 'Message: #' || n || ', '
    msg = msgread()
    parse value msg with msg (a.crlf) .
    call sms_decode msg
  end
  else 
    iterate
end

return
/*** ================== ***/
smsstore: procedure expose a. resp. cfg.
store = arg(1)

if store = ''      then store = '?'
if store = 'phone' then store = '="ME"'
if store = 'sim'   then store = '="SM"'

if store = '?' then do
  rc = RxAsyncWrite(a.hdl, 0, 'at+cpms' || store || a.cr, 'a.remaining')
  if rc \= 0 then call errwr

  rc = 0
  resp.0 = 2
  resp.1 = '+CPMS: '
  resp.2 = 'OK'

  rc = chkresp()

  if rc \= 1 then return
  parse value resp.ret with mem1.name ',' mem1.used ',' mem1.total ',',
                            mem2.name ',' mem2.used ',' mem2.total ',',
                            mem3.name ',' mem3.used ',' mem3.total .
  say 'Preferred store: ' || mem1.name || ', used ' || mem1.used || ' from ' || mem1.total
  say 'Store1:          ' || mem2.name || ', used ' || mem2.used || ' from ' || mem2.total
  say 'Store2:          ' || mem3.name || ', used ' || mem3.used || ' from ' || mem3.total
  return
end

rc = RxAsyncWrite(a.hdl, 0, 'at+cpms' || store || a.cr, 'a.remaining')
if rc \= 0 then call errwr

rc = 0
resp.0 = 2
resp.1 = '+CPMS: '
resp.2 = 'OK'

rc = chkresp()

if rc \= 1 then return
parse value resp.ret with used ',' total ',' . ',' . ',' . ',' .

say 'Preferred store: ' || store || ', used: ' || used || ', total: ' || total


return
/*** ================== ***/
smsdel: procedure expose a. resp. cfg.
num = arg(1)

if num = '' then exit 255

rc = RxAsyncWrite(a.hdl, 0, 'at+cmgd=' || num || a.cr, 'a.remaining')
if rc \= 0 then call errwr

resp.0 = 2
resp.1 = 'OK'
resp.2 = '+CMS ERROR: '
rc = chkresp()

if rc = 1 then say 'Message #' || num || ' deleted successfully.'
if rc = 2 then say 'Message #' || num || ' delete failed!'


return
/*** ================== ***/
check_balance: procedure expose a. resp. cfg.
call send_ussd cfg.ussd.balance

return
/*** ================== ***/
send_ussd: procedure expose a. resp. cfg.
ussd = arg(1)

if translate(ussd) = 'CANCEL' then
  rc = RxAsyncWrite(a.hdl, 0, 'at+cusd=2' || a.cr, 'a.remaining')
else
/*  if a.cp = 'UCS2' then
    rc = RxAsyncWrite(a.hdl, 0, 'at+cusd=1,"' || alt_to_ucs2(ussd) || '",15' || a.cr, 'a.remaining')
  else */
    rc = RxAsyncWrite(a.hdl, 0, 'at+cusd=1,"' || ussd || '",15' || a.cr, 'a.remaining')

if rc \= 0 then call errwr

rc  = 0
resp.0 = 2
resp.1 = '+CUSD: '
resp.2 = 'ERROR'

rc = chkresp()

select
  when rc = 1 then do
    parse value resp.ret with n ',' '"' msg '"' ',' dcs (a.crlf) .
    if ishex(msg) then
      say ucs2_decode(msg)
    else
      say msg
  end
  when rc = 2 then
    say 'Got ERROR response!'
  otherwise nop
end


return
/*** ================== ***/
check_signal: procedure expose a. resp. cfg.

rc = RxAsyncWrite(a.hdl, 0, 'at+csq' || a.cr, 'a.remaining')
if rc \= 0 then call errwr

rc  = 0
resp.0 = 2
resp.1 = '+CSQ: '
resp.2 = 'ERROR'

rc = chkresp()

select
  when rc = 1 then do
    parse value resp.ret with rssi ',' ber .
    select
      when rssi = 0 then
        say 'signal is -113 dBm or less'
      when rssi = 1 then
        say 'signal is -111 dBm'
      when rssi > 1 & rssi < 31 then
        say 'signal is ' || (-113 + 2 * rssi) || ' dBm'
      when rssi = 31 then
        say 'signal is -59 dBm or higher'
      otherwise
        say 'signal is not known or not detectable'
    end
  end
  when rc = 2 then
    say 'Got ERROR response!'
  otherwise nop
end

return
/*** ================== ***/
check_pin: procedure expose a. resp. cfg.
pin = arg(1)

if pin = '' 
  then cmd = '?'
  else cmd = '="' || pin || '"'
  
rc = RxAsyncWrite(a.hdl, 0, 'at+cpin' || cmd || a.cr, 'a.remaining')
if rc \= 0 then call errwr

rc  = 0
resp.0 = 3
resp.1 = '+CPIN: '
resp.2 = 'ERROR'
resp.3 = 'OK'

rc = chkresp()

select
  when rc = 1 then do
    parse value resp.ret with res (a.crlf) .
    select
      when res = 'SIM PIN' then
        say 'blocked by SIM PIN!'
      when res = 'READY' then
        say 'unblocked.'
      otherwise nop
    end
  end
  when rc = 2 then
    say 'Got ERROR response!'
  when rc = 3 then
    say 'unblocked'
  otherwise nop
end


return
/*** ================== ***/
smsview: procedure expose a. resp. cfg.
num = arg(1)

rc = RxAsyncWrite(a.hdl, 0, 'at+cmgl=1' || a.cr, 'a.remaining')
if rc \= 0 then call errwr

rc  = 0
resp.0 = 2
resp.1 = '+CMGL: '
resp.2 = 'OK'
do until rc = 2
  rc = chkresp()
  if rc = 1 then do
    parse value resp.ret with n ',' . ',' . ',' . (a.crlf) .
    msg = msgread()
    parse value msg with msg (a.crlf) .
    if n = num then
      call sms_decode msg
  end
end

return
/* read from a comport until CRLF is encountered */
msgread: procedure expose a. cfg.

inp = ''
msg = ''

do forever
  rc = RxAsyncRead(a.hdl, 0, -1, 'inp')
  if rc \= 0 then call errrd
  msg = msg || inp
  if right(inp, 2) = a.crlf 
  then 
    leave
end


return msg
/*** ================== ***/
smssend: procedure expose a. resp. cfg.
parse arg number msg

rc = RxAsyncWrite(a.hdl, 0, 'at+cmgf=0' || a.cr, 'a.remaining')
if rc \= 0 then call errwr

resp.0 = 2; 
resp.1 = 'OK'; 
resp.2 = 'ERROR'
if chkresp() = 2 then return

rc = RxAsyncWrite(a.hdl, 0, 'at+csms=0' || a.cr, 'a.remaining')
if rc \= 0 then call errwr

resp.0 = 2; 
resp.1 = '+CSMS: '; 
resp.2 = 'ERROR'
rc = chkresp()

if rc \= 1 then do
  say 'SMS sending is not supported!'
  return
end

parse value resp.ret with result (a.crlf) .
if result \= '1,1,1' then do
  say 'SMS sending is not supported!'
  return
end

pdu = '001100'

len = length(number)
if pos('+', number) = 1 then len = len - 1
outnum = num_encode(number)

len = right(d2x(len), 2, '0')
outnum =  len || '91' || outnum

/* check if the message is in 7bit encoding */
l = length(msg)
i = 1
do while i < l + 1 & x2d(c2x(substr(msg, i, 1))) < 128
  i = i + 1
end

if i = l + 1 
then do
  /* send in 7-bit encoding with PDU mode */
  cmd = 'at+cscs="GSM"' || a.cr
  dcs = 0
  outmsg = _7bits_pack(msg)
  l = right(d2x(length(msg)), 2, '0')
end
else do
  /* send in UCS2 encoding with PDU mode */
  cmd = 'at+cscs="UCS2"' || a.cr
  dcs = 8
  outmsg = alt_to_ucs2(msg)
  l = right(d2x(length(msg) * 2), 2, '0')
end

l.0 = 1
outmsg.0 = 1
l.1 = l
outmsg.1 = outmsg
i = 0

/* if message is too long, then split it to several SMS */
if (dcs = 8 & length(msg) > 70) |,
   (dcs = 0 & length(msg) > 160)  then
do
  i = 0
  select
    when dcs = 0 then do
      maxlen = 134
    end
    when dcs = 8 then do
      maxlen = 64
    end
    otherwise nop
  end
  do while msg \= ''
    i = i + 1
    outmsg.i = substr(msg, 1, min(maxlen, length(msg)))
    msg = substr(msg, maxlen + 1)
    select
      when dcs = 0 then do
        l.i = right(d2x(length(outmsg.i) + 8), 2, '0')
        outmsg.i = _7bits_pack(outmsg.i)
      end
      when dcs = 8 then do
        l.i = right(d2x(length(outmsg.i) * 2 + 6), 2, '0')
        outmsg.i = alt_to_ucs2(outmsg.i)
      end
      otherwise nop
    end
  end
  outmsg.0 = i
  l.0 = i
end

/* add udh bit to the pdu type byte */
if i <> 0 then pdu = '005100'
pdu = pdu || outnum
pdusave = pdu

/* protocol id */
pid = '00'
/* data encoding */
dcs = right(d2x(dcs), 2, '0')
/* validity period: 4 days */
vp = 'AA'

udhdr = ''

do i = 1 to outmsg.0
  /* if an encoding is 7 bits then make a message 7-bits-aligned */
  if dcs = '00' then do 
    outmsg.i = b2x('0' || x2b(outmsg.i))
    if length(outmsg.i) // 2 <> 0 then outmsg.i = '0' || outmsg.i
    t = '060004'
  end
  else
    t = '050003'

  /* if message is multipart then add an optional header */
  if outmsg.0 > 1 then udhdr = t || 'D0' || right(d2x(outmsg.0), 2, '0') || right(d2x(i), 2, '0')

  pdu = pdusave || pid || dcs || vp || l.i || udhdr

  pdu = pdu || outmsg.i

  pdulen = (length(pdu) - 2) / 2 

  rc = RxAsyncWrite(a.hdl, 0, cmd, 'a.remaining')
  if rc \= 0 then call errwr

  resp.0 = 2; 
  resp.1 = 'OK'; 
  resp.2 = 'ERROR'
  rc = chkresp()

  rc = RxAsyncWrite(a.hdl, 0, 'at+cmgs=' || pdulen || a.cr, 'a.remaining')
  if rc \= 0 then call errwr

  resp.0 = 2; 
  resp.1 = '> '; 
  resp.2 = 'ERROR'
  rc = chkresp()
  if rc \= 1 then do
    say 'SMS send command failed!'
    return
  end

  rc = RxAsyncWrite(a.hdl, 0, pdu || a.ctrlz, 'a.remaining')
  if rc \= 0 then call errwr

  resp.0 = 3; 
  resp.1 = '+CMGS: '; 
  resp.2 = '+CMS ERROR: '; 
  resp.3 = 'OK'
  rc = chkresp()
  if rc \= 1 then do
    say 'SMS submit command failed!'
    return
  end
  say 'Message submitted successfully, mr: ' || resp.ret
end


return
/*** ================== ***/
mdm_init: procedure expose cfg. a. resp.

if stream(cfg.port,'c','open') = 'NOTREADY:32' then call erropen
call stream cfg.port,'c','close'
rc = RxAsyncOpen(cfg.port, 'a.hdl')
rc = RxAsyncSetLnCtrl(a.hdl, cfg.speed, 8, 'N', 1)
if rc \= 0 then erropen

rc = RxAsyncSetDcbInfo(a.hdl, 400, 50, '00001001', '10000000', '', '', '', '', '')

/*
rc = RxAsyncWrite(a.hdl, 0, cfg.init || a.cr, 'a.remaining')
if rc \= 0 then call errwr

resp.0 = 2; 
resp.1 = 'OK'
resp.2 = 'ERROR'; 
if chkresp() = 2 then do
  say 'Port init failed!'
  exit -1
end
*/

/*
rc = RxAsyncWrite(a.hdl, 0, 'at+cscs?' || a.cr, 'a.remaining')

rc  = 0
resp.0 = 2
resp.1 = '+CSCS: '
resp.2 = 'ERROR'

rc = chkresp()

if rc = 2 then do
  say 'Incorrect charset!'
  return
end


charset = 'UCS2'
if resp.ret <> '"' || alt_to_ucs2('UCS2') || '"' then
  rc = RxAsyncWrite(a.hdl, 0, 'at+cscs="' || charset || '"' || a.cr, 'a.remaining')
else
  rc = RxAsyncWrite(a.hdl, 0, 'at+cscs="' || alt_to_ucs2(charset) || '"' || a.cr, 'a.remaining')

rc  = 0
resp.0 = 2
resp.1 = 'OK'
resp.2 = 'ERROR'

rc = chkresp()

if rc = 2 then do
  say 'Incorrect charset!'
  return
end
*/


return
/*** ================== ***/
modem_init_func:

/* Switch on 'AT+CFUN=1', if it is off */
rc = RxAsyncWrite(a.hdl, 0, 'at+cfun?' || a.cr, 'a.remaining')
if rc \= 0 then call errwr
/* if it is already switched on */
resp.0 = 3; 
resp.1 = '+CFUN: 1'; 
resp.2 = 'ERROR'; 
resp.3 = 'OK'
if chkresp() = 1 then return

rc = RxAsyncWrite(a.hdl, 0, 'at+cfun=1' || a.cr, 'a.remaining')
if rc \= 0 then call errwr

resp.0 = 4 
resp.1 = '*MRDY: 3'
resp.2 = '+PACSP0'
resp.3 = 'ERROR'
resp.4 = 'OK'

do until rc < 3 
  rc = chkresp()
end


return
/*** ================== ***/
mdm_done:

/* Switch back 'AT+CSCS="GSM"', if it is off */
rc = RxAsyncWrite(a.hdl, 0, 'at+cscs?' || a.cr, 'a.remaining')
if rc \= 0 then call errwr

resp.0 = 3
resp.1 = '+CSCS: '
resp.2 = 'ERROR'
resp.3 = 'OK'

rc = chkresp()

if rc = 1 then do
  parse value resp.ret with enc (a.cr) .
  select
    when enc = '"' || alt_to_ucs2('UCS2') || '"' then do
      /* Switch back 'AT+CSCS="GSM"', if it is off */
      rc = RxAsyncWrite(a.hdl, 0, 'at+cscs="' || alt_to_ucs2('GSM') || '"' || a.cr, 'a.remaining')
      if rc \= 0 then call errwr

      resp.0 = 2
      resp.1 = 'ERROR'
      resp.2 = 'OK'

      do until rc = 2 
        rc = chkresp()
      end
    end
    otherwise nop
  end
end


return
/*** ================== ***/
sms_decode: procedure expose a. cfg.
s = arg(1)
udoff = 0

/* say s */
smsc = num_decode(s)

len = substr(s, 1, 2)
pdutype = substr(s, 2 * len + 3, 2)
call debug 'pdutype=' || pdutype || a.crlf

/* header present bit */
udh = substr(x2b(pdutype), 2, 1)

/*
pt = substr(x2b(pdutype), 4, 2)

select
  when pt = '00' then vp = 0
  when pt = '10' then vp = 1
  when pt = '11' then vp = 7
  otherwise vp = 7
end
*/

deliver = substr(s, 2 * len + 5)
call debug 'vp=' || vp || a.tab || 'udh=' || udh || a.crlf
call debug 'deliver=' || deliver || a.crlf

senderno = num_decode(deliver)

len = x2d(substr(deliver, 1, 2))
type = x2d(substr(deliver, 3, 2))

say type

l = len + 8
if type = x2d('81') then do
  l = l - 1
  if len % 2 = 1 then l = l + 1
end

s = substr(deliver, l)

dcs = x2d(substr(s, 1, 2))
call debug 'dcs=' || dcs || a.crlf

s = substr(s, 3)

scts = bswap(substr(s, 1, 14))
date = substr(scts, 1, 2) || '.' || substr(scts, 3, 2) || '.' || substr(scts, 5, 2)
time = substr(scts, 7, 2) || ':' || substr(scts, 9, 2) || ':' || substr(scts, 11, 2)
timezone = substr(scts, 13, 2)

call outp  date || a.tab || ' @' || time || a.crlf
call outp  'SMSC: ' || smsc || a.tab || ' from: ' || senderno || a.crlf
call debug 'timezone=' || timezone || a.crlf

/*
udl = x2d(substr(s, vp * 2 + 1, 2))
ud = substr(s, vp * 2 + 3)
*/

udl = x2d(substr(s, 2 * 7, 2))
ud  = substr(s, 2 * 7 + 3 + 3)
call debug 'udl=' || udl || a.tab || 'ud=' || ud || a.crlf

/* if an optional header exists */
if udh = 1 then do
  type = substr(ud, 3, 2)
  udoff = x2d(substr(ud, 1, 2)) - 1
  call debug 'type=' || type || a.tab || 'udoff=' || udoff || a.crlf
  if type > 0 then do
    udl = x2d('0F')
    /* Unknown attach! */
    ud = '55F7DAFDBEBB41413A3D3C4687'
  end
end

select
  when dcs = 4  /* 8-bit encoding */
    then s = ud /* ??? */
  when dcs = 8  /* UCS2 encoding  */
    then s = ucs2_decode(ud)
  otherwise do  /* 7-bit encoding */
    /* ud = substr(ud, 4) */
    s = msg_decode(ud, length(ud))
    udoff = udoff + 4
  end
end

if udh = 1 & type = 0 then s = substr(s, udoff)

call debug 'udl=' || udl || a.tab || 'ud=' || ud || a.crlf
call outp  s || a.crlf


return
/*** ================== ***/
msg_decode: procedure expose a. cfg.
s = arg(1)
l = arg(2)

/* unpack 8-bits to 7-bits */
outmsg = ''
carry = ''
do i = 1 by 2 to l
  do k = 1 to 7
    if i > l then leave
    octet = x2b(strip(substr(s, i, 2)))
    octet = right(format(octet), 8, 0)
    sevenbits = b2x(right(octet, 8 - k) || carry)
    carry = left(octet, k)
    outmsg = outmsg || sevenbits
    i = i + 2
  end
  i = i - 2
  if i > l then leave
  carry = b2x(right(format(carry), 8, 0))
  if carry <> '00' then
  outmsg = outmsg || carry
  carry = ''
end

/* translate special symbols */
do forever
  p = pos('1B', outmsg)
  if p <= 0 then leave
  w = substr(outmsg, p, 4)
  u = delstr(outmsg, p)
  v = substr(outmsg, p + 4)
  select
    when w = '1B0A' then w = '0C'
    when w = '1B14' then w = '5E'
    when w = '1B28' then w = '7B'
    when w = '1B29' then w = '7D'
    when w = '1B2F' then w = '5C'
    when w = '1B3C' then w = '5B'
    when w = '1B3D' then w = '7E'
    when w = '1B3E' then w = '5D'
    when w = '1B40' then w = '7C'
    otherwise w = '7C'
  end
  outmsg = u || w || v
end

outmsg = translate(x2c(outmsg), '@$_', '00 02 11'x)


return outmsg
/*** ================== ***/
_7bits_pack: procedure expose cfg.
msg = arg(1)

l = length(msg)

do i = 1 to l
  w = substr(msg, i, 1)
  u = delstr(msg, i)
  v = substr(msg, i + 1)
  select
    when w = '0c'x then w ='1b 0a'x
    when w = '5e'x then w ='1b 14'x
    when w = '7b'x then w ='1b 28'x
    when w = '7d'x then w ='1b 29'x
    when w = '5c'x then w ='1b 2f'x
    when w = '5b'x then w ='1b 3c'x
    when w = '7e'x then w ='1b 3d'x
    when w = '5d'x then w ='1b 3e'x
    when w = '7c'x then w ='1b 40'x
    otherwise nop
  end
  msg = u || w || v
end

outmsg = ''

do i = 1 to l
  do k = 1 to 7
    u = right(format(x2b(c2x(substr(msg, i, 1)))), 7, '0')
    v = right(format(x2b(c2x(substr(msg, i + 1, 1)))), 7, '0')
    hex = b2x(right(v, k) || left(u, 8 - k))
    outmsg = outmsg || hex
    if i = l then leave
    i = i + 1
  end
end


return outmsg
/* UCS2 decode ---------- */
ucs2_decode: procedure expose a. cfg.
msg = arg(1)

msg = strip(msg)
outmsg = ''
len = (length(msg) % 4) * 4

call debug 'Decoding msg=' || msg || ', len=' || length(msg) % 4

do i = 1 by 4 while i < len
  char = substr(msg, i, 4)
  l = left(char, 2)
  r = right(char, 2)

  select
    when l = '00'   /* english  */
      then nop
    when l = '04'   /* cyrillic */
      then do       
      r = x2d(r)
      if r < 64 
        then r = d2x(r + 112)
        else r = d2x(r + 160)
    end             /* add your own encoding here */
    otherwise nop
  end

  outmsg = outmsg || r
end


return lf2crlf(x2c(outmsg))
/* ---------------------- */
lf2crlf: procedure expose a. cfg.
msg = arg(1)
outmsg = ''

do i = 1 to length(msg)
  c = substr(msg, i ,1)

  if c = a.lf then
    c = a.crlf

  outmsg = outmsg || c
end

 
return outmsg
/* UCS2 encode ---------- */
alt_to_ucs2: procedure expose cfg.
msg = arg(1)

len = length(msg)
msg = strip(msg)
outmsg = ''

do i = 1 to len
  char = substr(msg, i, 1)
  char = x2d(c2x(char))
  if char < 128
    then char = '00' || d2x(char)
  else
    if char < 176
      then char = '04' || d2x(char - 112)
      else char = '04' || d2x(char - 160)
  outmsg = outmsg || char
end


return outmsg
/*** Phone number decode **/
num_decode: procedure expose cfg.
s = arg(1)

/* number length */
len = x2d(substr(s, 1, 2))
/* number type */
type = substr(s, 3, 2)

select
  when type = 91 then l = 2 * (len - 1)
  otherwise l = len
end

/* number itself */
s = substr(s, 5, l)
n = bswap(s)

/* delete padding by 'F' */
p = pos('F', n)
if p > 0 then n = delstr(n, p, 1)

select
  when type = '81' then nop                        /* national/unknown */
  when type = '91' then n = '+' || n               /* international    */
  when type = 'D0' then n = msg_decode(s, len)     /* alphanumeric     */
  otherwise nop
end


return n
/*** Phone number encode **/
num_encode: procedure
number = arg(1)

/* delete '+' */
if pos('+', number) = 1 then number = delstr(number, 1, 1)
/* change local number to an international one */
if pos('8', number) = 1 then number = '7' || substr(number, 2)

l = length(number)

len = d2x(l)
if length(len) = 1 then len = '0' || len

/* if the number has an odd number of digits */
if l // 2 \= 0 then do 
  number = number || 'F'
  l = l + 1
end

outnum = ''
do i = 1 by 2 while i < l
  u = substr(number, i + 1, 1) || substr(number, i, 1)
  outnum = outnum || u
end


return outnum
/*** swap each odd nibble with an even one in a hex string ***/
bswap: procedure
n = arg(1)

m = ''
do i = 1 to length(n) / 2
  byte = substr(n, 2 * i - 1, 2)
  byte = substr(byte, 2, 1) || substr(byte, 1, 1)
  m = m || byte
end


return m
/*** ================== ***/
ishex: procedure /* If a string represent a hex number? */
s=arg(1)
result = 1

do i = 1 to length(s) while result
  ch = translate(substr(s, i, 1))
  if datatype(ch) = 'CHAR' &,
     ch \= 'A' & ch \= 'B' &,
     ch \= 'C' & ch \= 'D' &,
     ch \= 'E' & ch \= 'F' then result = 0
end

return result
/*** ================== ***/
errwr:

call outp '*** Error writing to cfg.port ' || cfg.port || '!, rc = ' || rc || a.crlf
exit -1
/*** ================== ***/
errrd:

call outp '*** Error reading cfg.port ' || cfg.port || '!, rc = ' || rc || a.crlf
exit -2
/*** ================== ***/
erropen:

call outp 'Error opening cfg.port ' || cfg.port || '!, rc = ' || rc || a.crlf
exit -3
/*** ================== ***/
outp: procedure expose a.
s = arg(1)

call charout 'stdout', s


return
/*** ================== ***/
debug: procedure expose cfg.
s = arg(1)

if cfg.debug = 1 
then call charout 'stderr', s


return
/*** ================== ***/
help:
cmd = arg(1)

return
/*** ================== ***/
chkresp: procedure expose a. cfg. resp.

inp = ''
do forever
  rc = RxAsyncRead(a.hdl, 0, 3000, 'inp')
  if rc > 0  then call errrd
  call debug inp
  do i = 1 to resp.0
    if abbrev(inp, resp.i, length(resp.i)) then do
      parse value inp with (resp.i) resp.ret
      return i
    end
  end
end
/*** ================== ***/
