/**************************************************************************/
/* RxNsLookUp.cmd - ᬮ DNS                                          */
/*                                                                        */
/* ⠪: RxNsLookUp [<>    ] [/l] [/i] [/m]                     */
/*                       [@[<ᯨ᮪>]]                                    */
/*                                                                        */
/* ࠬ:  - Inet- (ਬ, www.somebody.net),            */
/*                    IP- (ਬ, 192.168.0.127),                 */
/*                    蠡 IP- (ਬ, 192.168.0.*),           */
/*                     IP-ᮢ (ਬ, 192.168.0.0+127      */
/*                        192.168.0.0-192.168.0.127).                  */
/*      @[<c᮪>] -    䠩 <ᯨ᮪>   stdin,     */
/*                    ᫨  䠩 饭                              */
/*           ᯨ᮪ -  䠩, ᮤঠ饣 ᯨ᮪ ᮢ               */
/*                    (Inet, IP, 蠡  ).                */
/*                    ਬ:                                           */
/*                       :਩                                     */
/*                       www.somebody.net                                 */
/*                       192.168.0.23                                     */
/*                       192.168.0.*                                      */
/*                       192.168.0.1-192.168.0.127                        */
/*                       192.168.0.128+127                                */
/*               /l - 뢮 १⮢   ᯨ᪠ (, ⮪).  */
/*               /i - ஢ ᮮ饭  訡.                  */
/*               /m - ⮡ࠦ  ࠡ⪨  STDERR.             */
/*    ࠬ஢ - 뢮 ᪠.                                    */
/*                                                                        */
/*========================================================================*/
/* (c) VicTor Smirnoff, 2001                         sva@water.karelia.ru */
/**************************************************************************/
trace off
numeric digits 12

parse arg xParm
xParm = space( strip( xParm ), 1 )
if ( xParm = '' ) then xHowUse()
rc = xParseParm( xParm )
xMask = ''

if xList = 0 then
   do
   say ':'
   say substr( ': '||Date('L')||' ('||Time('C')||')',1,62,' ')||'RxNsLookUp v0.01'
   say  ': Parameters: '||xParm
   say substr( ':=', 1, 78, '=' )
   end

/**************************************************************************/
/* 樠 㭪権                                                  */
/**************************************************************************/
if RxFuncQuery( 'SysLoadFuncs' ) then
   do
   rc = RxFuncAdd( 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs' )
   rc = SysLoadFuncs()
   end
if RxFuncQuery( 'SockLoadFuncs' ) then
   do
   rc = RxFuncAdd( 'SockLoadFuncs', 'RxSock', 'SockLoadFuncs' )
   rc = SockLoadFuncs()
   end

/**************************************************************************/
/* 祭                                                        */
/**************************************************************************/
if xFile \= '' then rc=Stream( xFile, 'C', 'OPEN READ' )

do forever
   if xAddr \= '' then
      do
      if xMask \= '' then leave
      xMask = xAddr
      end
   else
      do
      xLine = LineIn( xFile )
      if Stream( xFile, 'S' ) = 'NOTREADY' then leave
      xLine = strip( xLine )
      if length( xLine ) = 0 | substr( xLine, 1, 1 ) = ':' then iterate
      parse var xLine xMask' 'xA
      end

/**************************************************************************/
/* ᫥ ࠭ ᭮ ࠭⢠  蠣 ᪠஢           */
/**************************************************************************/
   rc = xAddressRange( xMask )
   if (rc = 0) then
      do

      if xMonitor = 1 then rc = LineOut('STDERR:', xMask )

      rc = SockGetHostByName( xMask, 'xHost.!' )
      if (rc = 0) then
         do
         if xNoErr = 0 then say ': UNRESOLV   '||xMask
         if xNoErr = 0 & xList = 0 then say substr( ':-', 1, 78, '-' )
         end
      else
         do
         if xList=1 then say xHost.!addr
         else
            do
            say substr( xHost.!addr, 1, 22, ' ' )||xHost.!name
            xTo = xHost.!alias.0
            if xTo < xHost.!addr.0 then xTo = xHost.!addr.0
            do i=1 to xTo
               if i>xHost.!alias.0 then xA=''
               else xA = '*'||xHost.!alias.i
               if i>xHost.!addr.0 then xB=''
               else xB = xHost.!addr.i
               say substr( ': '||xB, 1, 22, ' ' )||xA
            end
            say substr( ':-', 1, 78, '-' )
            end
         end
      iterate
      end

/**************************************************************************/
/* 室  ᥬ ᠬ                                                 */
/**************************************************************************/
   do iHost=x2d(xHostA,9) to x2d(xHostB,9) by xStep

      if xMonitor = 1 then rc = LineOut('STDERR:', xHexToDot(d2x(iHost,8)) )

      rc = SockGetHostByAddr( xHexToDot(d2x(iHost,8)), 'xHost.!' )
      if (rc = 0) then
         do
         if xNoErr = 0 then say ': UNRESOLV   '||xHexToDot(d2x(iHost,8))
         if xNoErr = 0 & xList = 0 then say substr( ':-', 1, 78, '-' )
         end
      else
         do
         if xList=1 then say xHost.!name
         else
            do
            say substr( xHost.!name, 1, 63, ' ' )||xHost.!addr
            xTo = xHost.!alias.0
            if xTo < xHost.!addr.0 then xTo = xHost.!addr.0
            do i=1 to xTo
               if i>xHost.!alias.0 then xA=''
               else xA = xHost.!alias.i
               if i>xHost.!addr.0 then xB=''
               else xB = '*'||xHost.!addr.i
               say substr( ': '||xA, 1, 62, ' ' )||xB
            end
            say substr( ':-', 1, 78, '-' )
            end
         end
   end


end

if xFile \= '' then rc=Stream( xFile, 'C', 'CLOSE' )
exit




/**************************************************************************/
/* xIsTemplate()                                                          */
/*========================================================================*/
/* ᠭ: ஢ઠ  蠡  dot-樨                       */
/*                                                                        */
/* ⠪:                                                             */
/*    rc = xIsTemplate( xAddr )                                           */
/*                                                                        */
/* ࠬ: xAddr -                                                */
/*                                                                        */
/* : RC=0 -     蠡  dot-樨                  */
/*            =1 -    蠡  dot-樨                     */
/*                                                                        */
/*------------------------------------------------------------------------*/
xIsTemplate: procedure
   xAddr = arg( 1 )
   parse var xAddr x.3'.'x.2'.'x.1'.'x.0
   do i = 0 to 3
      l = length( x.i )
      if l=0 | l>3 then return 0
      if l=1 & x.i='*' then iterate
      if verify( x.i, '0123456789' ) \= 0 then return 0
      if x.i > 255 then return 0
   end
   return 1
/*------------------------------------------------------------------------*/
/*  㭪樨 xIsTemplate()                                            */
/**************************************************************************/



/**************************************************************************/
/* xIsScope()                                                             */
/*========================================================================*/
/* ᠭ: ஢ઠ  ࠭ ᮢ  dot-樨  饭  */
/*                                                                        */
/* ⠪:                                                             */
/*    rc = xIsScope( xAddr )                                              */
/*                                                                        */
/* ࠬ: xAddr -                                                */
/*                                                                        */
/* : RC=0 -     ࠭  dot-樨  饭     */
/*            =1 -    ࠭  dot-樨  饭        */
/*                                                                        */
/*------------------------------------------------------------------------*/
xIsScope: procedure
   xAddr = arg( 1 )
   parse var xAddr xA'+'xB
   rc = xIsDot( xA )
   if rc=1 then
      do
      l = length( xB )
      if l=0 then return 0
      if verify( xB, '0123456789' ) \= 0 then return 0
      end
   return rc
/*------------------------------------------------------------------------*/
/*  㭪樨 xIsScope()                                               */
/**************************************************************************/



/**************************************************************************/
/* xIsRange()                                                             */
/*========================================================================*/
/* ᠭ: ஢ઠ  ࠭ ᮢ  dot-樨                */
/*                                                                        */
/* ⠪:                                                             */
/*    rc = xIsRange( xAddr )                                              */
/*                                                                        */
/* ࠬ: xAddr -                                                */
/*                                                                        */
/* : RC=0 -     ࠭  dot-樨                   */
/*            =1 -    ࠭  dot-樨                      */
/*                                                                        */
/*------------------------------------------------------------------------*/
xIsRange: procedure
   xAddr = arg( 1 )
   parse var xAddr xA'-'xB
   rc = xIsDot( xA )
   if rc=1 then rc = xIsDot( xB )
   return rc
/*------------------------------------------------------------------------*/
/*  㭪樨 xIsRange()                                               */
/**************************************************************************/



/**************************************************************************/
/* xIsDot()                                                               */
/*========================================================================*/
/* ᠭ: ஢ઠ    dot-樨                        */
/*                                                                        */
/* ⠪:                                                             */
/*    rc = xIsDot( xAddr )                                                */
/*                                                                        */
/* ࠬ: xAddr -                                                */
/*                                                                        */
/* : RC=0 -    dot-樨                                 */
/*            =1 -   dot-樨                                    */
/*                                                                        */
/*------------------------------------------------------------------------*/
xIsDot: procedure
   xAddr = arg( 1 )
   parse var xAddr x.3'.'x.2'.'x.1'.'x.0
   do i = 0 to 3
      l = length( x.i )
      if l=0 | l>3 then return 0
      if verify( x.i, '0123456789' ) \= 0 then return 0
      if x.i > 255 then return 0
   end
   return 1
/*------------------------------------------------------------------------*/
/*  㭪樨 xIsDot()                                                 */
/**************************************************************************/



/**************************************************************************/
/* xDotToHex()                                                            */
/*========================================================================*/
/* ᠭ: ८ࠧ   dot-樨  hex-             */
/*                                                                        */
/* ⠪:                                                             */
/*    hexAddr = xDotToHex( dotAddr )                                      */
/*                                                                        */
/* ࠬ: dotAddr -   筮 樨 (dot-)          */
/*                                                                        */
/* : hexAddr -   ⭠筮 ଥ                     */
/*                                                                        */
/*------------------------------------------------------------------------*/
xDotToHex: procedure
   xDot = arg( 1 )
   parse var xDot x.3'.'x.2'.'x.1'.'x.0
   return d2x( x.3, 2 )||d2x( x.2, 2 )||d2x( x.1, 2 )||d2x( x.0, 2 )
/*------------------------------------------------------------------------*/
/*  㭪樨 xDotToHex()                                              */
/**************************************************************************/



/**************************************************************************/
/* xHexToDot()                                                            */
/*========================================================================*/
/* ᠭ: ८ࠧ   hex-  dot-             */
/*                                                                        */
/* ⠪:                                                             */
/*    dotAddr = xHexToDot( hexAddr )                                      */
/*                                                                        */
/* ࠬ: hexAddr -   ⭠筮 ଥ                   */
/*                                                                        */
/* : dotAddr -   筮 樨 (dot-)            */
/*                                                                        */
/*------------------------------------------------------------------------*/
xHexToDot: procedure
   xHex = arg( 1 )
   do i = 0 to 3
      x.i = substr( xHex, 7-i*2, 2 )
   end
   return x2d( x.3, 4 )||'.'||x2d( x.2, 4 )||'.'||x2d( x.1, 4 )||'.'||x2d( x.0, 4 )
/*------------------------------------------------------------------------*/
/*  㭪樨 xHexToDot()                                              */
/**************************************************************************/



/**************************************************************************/
/* xAddressRange()                                                        */
/*========================================================================*/
/* ᠭ: ᫥ ࠭ ᭮ ࠭⢠                     */
/*                                                                        */
/* ⠪:                                                             */
/*    rc = xAddressRange( xMask )                                         */
/*                                                                        */
/* ࠬ: xMask - 蠡                                              */
/*                    global.host.name                                    */
/*                    xxx.xxx.xxx.xxx    xxx=ddd  *                 */
/*                    ddd.ddd.ddd.ddd-ddd.ddd.ddd.ddd                     */
/*                                                                        */
/* : xHostA -  ࠭                                       */
/*          xHostB -  ࠭                                      */
/*          xStep  - 蠣                                                  */
/*          RC=0   - Inet-                                           */
/*            =1   - IP-                                             */
/*                                                                        */
/*------------------------------------------------------------------------*/
xAddressRange: procedure expose xHostA xHostB xStep
   xMask = arg( 1 )
   xDot = 1
   if xIsDot( xMask ) = 1 then
      do
      xHostA = xDotToHex( xMask )
      xHostB = xHostA
      xStep = 1
      return 1
      end
   if xIsRange( xMask ) = 1 then
      do
      parse var xMask xA'-'xB
      xHostA = xDotToHex( xA )
      xHostB = xDotToHex( xB )
      xStep = 1
      if xHostA>xHostB then xStep = -1
      return 1
      end
   if xIsScope( xMask ) = 1 then
      do
      parse var xMask xA'+'xB
      xHostA = xDotToHex( xA )
      xHostB = d2x( x2d(xHostA,9) + xB, 8 )
      xStep = 1
      if xHostA>xHostB then xStep = -1
      return 1
      end
   if xIsTemplate( xMask ) = 1 then
      do
      parse var xMask x.3'.'x.2'.'x.1'.'x.0
      y.0 = 1
      y.1 = 256
      y.2 = 65536
      y.3 = 16777216
      do i = 0 to 3
         l = length( x.i )
         if l=1 & x.i='*' then
            do
               xStep = y.i
               leave
            end
      end
      xHostA = xDotToHex( translate(xMask, '0', '*') )
      xTemp = xMask
      do while pos( '*', xTemp ) \= 0
         parse var xTemp xA'*'xB
         xTemp = xA||'255'||xB
      end
      xHostB = xDotToHex( xTemp )
      return 1
      end

   xStep = 1
   return 0
/*------------------------------------------------------------------------*/
/*  㭪樨 xAddressRange()                                          */
/**************************************************************************/



/**************************************************************************/
/* xError()                                                               */
/*========================================================================*/
/* ᠭ: 뢮 ᮮ饭  訡  室                            */
/*                                                                        */
/* ⠪:                                                             */
/*    rc = xError( xParm )                                                */
/*                                                                        */
/* ࠬ: xParm - ப ࠬ஢                                   */
/*                                                                        */
/* :                                                            */
/*                                                                        */
/*------------------------------------------------------------------------*/
xError: procedure
   xParm = arg( 1 )

   say ''
   say 'Invalid parameters - '||xParm
   say 'Type RxNsLookUp without parameters.'
   say ''

   exit 1
/*------------------------------------------------------------------------*/
/*  㭪樨 xError()                                                 */
/**************************************************************************/



/**************************************************************************/
/* xParseParm()                                                           */
/*========================================================================*/
/* ᠭ: ࠧ ࠬ஢  ப                           */
/*                                                                        */
/* ⠪:                                                             */
/*    rc = xParseParm( xParm )                                            */
/*                                                                        */
/* ࠬ: xParm - ப ࠬ஢                                   */
/*                                                                        */
/* : xAddr -   '', ᫨  ᯨ᮪                       */
/*          xFile -  䠩-ᯨ᪠, 'STDIN:'  '', ᫨ ᯨ᪠     */
/*          xMonitor=0 -  ⮡ࠦ ᮢ  STDERR                */
/*                  =1   ⮡ࠦ ࠡ뢠   STDERR     */
/*          xList=0 - १   ⮪                          */
/*               =1   १   ᯨ᪠                             */
/*          xNoErr=0 - 뢮 ᮮ饭  訡                      */
/*                =1 -  뢮 ᮮ饭  訡                   */
/*                                                                        */
/*------------------------------------------------------------------------*/
xParseParm: procedure expose xAddr xFile xList xNoErr xMonitor
   xParm = arg( 1 )

   xAddr = ''
   xFile = ''
   xList = 0
   xMonitor = 0
   xNoErr = 0
   parse var xParm x.0' 'x.1' 'x.2' 'x.3' 'x.4
   do i=0 to 4
      x.i = strip( x.i )
   end
   if x.4 \= '' then xError( xParm )

   do i=0 to 3
      if x.i  = '' then leave
      if translate( x.i ) = '/M' then
         do
         if xMonitor = 1 then xError( xParm )
         xMonitor = 1
         iterate
         end
      if translate( x.i ) = '/L' then
         do
         if xList = 1 then xError( xParm )
         xList = 1
         iterate
         end
      if translate( x.i ) = '/I' then
         do
         if xNoErr = 1 then xError( xParm )
         xNoErr = 1
         iterate
         end
      if substr( x.i, 1, 1 ) = '@' then
         do
         if xFile \= '' | xAddr \= '' then xError( xParm )
         xFile = substr( x.i, 2 )
         if xFile = '' then xFile = 'STDIN:'
         iterate
         end
      if xFile \= '' | xAddr \= '' then xError( xParm )
      xAddr =  x.i
   end
   if xFile = '' & xAddr = '' then xError( xParm )

   return ''
/*------------------------------------------------------------------------*/
/*  㭪樨 xParseParm()                                             */
/**************************************************************************/



/**************************************************************************/
/* xHowUse()                                                              */
/*========================================================================*/
/* ᠭ: 뢮 ᠭ ᨭ⠪  ப  室           */
/*                                                                        */
/* ⠪:                                                             */
/*    rc = xHowUse()                                                      */
/*                                                                        */
/* ࠬ:                                                          */
/*                                                                        */
/* :                                                            */
/*                                                                        */
/*------------------------------------------------------------------------*/
xHowUse: procedure
   say 'RxNsLookUp v0.01   (c)VicTor Smirnoff, 2001   E-mail: sva@water.karelia.ru'
   say ''
   say 'Syntax: RxNsLookUp [ <address> | @[<list>] ] [/l] [/i] [/m]'
   say ''
   say 'Parameters: address - the Inet-address (i.e. www.somebody.net),'
   say '                      the IP-address (i.e. 192.168.0.127),'
   say '                      the template of the IP-addresses (i.e. 192.168.0.*),'
   say '                      the range of the IP-addresses (i.e. 192.168.0.0+127'
   say '                         or 192.168.0.0-192.168.0.127)'
   say '          @[<list>] - get the addresses from the file <list> or from stdin,'
   say '                      when the file name is omitted.'
   say '               list - the file name. This file should contain the list '
   say '                      of addresses (Inet, IP, template or range), example:'
   say '                         :comment'
   say '                         www.somebody.net'
   say '                         192.168.0.127'
   say '                         192.168.0.*'
   say '                         192.168.0.0-192.168.0.127'
   say '                         192.168.0.0+127'
   say '                 /l - display the results as the list (else as the protocol).'
   say '                 /i - ignore the error messages.'
   say '                 /m - display the processed addresses to STDERR.'
   say ' without parameters - display the help.'
   exit 1;
/*------------------------------------------------------------------------*/
/*  㭪樨 xHowUse()                                                */
/**************************************************************************/



/**************************************************************************/
/*  䠩 RxNsLookUp.cmd                                             */
/**************************************************************************/

