/*  娢  IBM */
'@Echo off'
if (RxFuncQuery('SysLoadFuncs')) then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
end

Call InitGlobVar

Parse arg GlobVar.PackFile GlobVar.Filter
GlobVar.Filter=Translate(GlobVar.Filter)

if GlobVar.PackFile='' then do
  Say 'Upm <bundle name> [filter]'
  Exit
end

Signal On Halt

Call SysCls

Call GetPackList
Call DrawInit
Call KeysInit
Call DrawProgramTitle

Call GetList
Call QSort 1 List.0

ListBoxWidth=44
ListBoxX=2
ListBoxY=2

Call DrawHelp ListBoxX+ListBoxWidth+2, ListBoxY+1

BoxTitle=Stream(GlobVar.PackFile,'c','Query Exists')
if Length(BoxTitle)>ListBoxWidth-4 then BoxTitle=Right(BoxTitle,ListBoxWidth-4,'.')
Call ListBox ListBoxX,ListBoxY,ListBoxWidth,22,BoxTitle

Call SysCls
Call SysCurState 'ON'

Exit

/* =========================================================== */
/*  ६ */
InitGlobVar: procedure expose GlobVar.
  GlobVar.ViewMode=0
  GlobVar.DestDir='F:\1'
  GlobVar.Filter=''
  GlobVar.SortMode=0
  GlobVar.SelectMask=''
Return
/* -----------------------------------------------------------*/
/* 祭 ᯨ᪠ 娢 */
GetPackList: procedure expose PackList. GlobVar.
  'Unpack2' GlobVar.PackFile '/show | RxQueue.Exe'

  PackList.0=Queued()-1
  if PackList.0>0 then do
    Pull S
    do I=1 to PackList.0
      parse pull '->' PackList.I
    end
  end
Return

/* -----------------------------------------------------------*/
/* 祭 ᯨ᪠ ⮢  ⮡ࠦ */
GetList: procedure expose PackList. List. GlobVar.
  Drop List.;  J=0
  do I=1 to PackList.0
    if GlobVar.ViewMode=0 then S=PackList.I
    else S=FileSpec('Name',PackList.I)
    if GlobVar.Filter<>'' then do
      Ok=Pos(GlobVar.Filter,Translate(S))>0
    end
    else OK=1
    if Ok then do
      J=J+1
      List.J=S
    end
  end
  List.0=J
Return

/* -----------------------------------------------------------*/
/* ࠭ */
DrawInit: procedure expose Draw.
  Draw.CharLU=D2C(218)
  Draw.CharLD=D2C(192)
  Draw.CharRU=D2C(191)
  Draw.CharRD=D2C(217)
  Draw.CharV=D2C(179)
  Draw.CharH=D2C(196)
  Draw.CharVL=D2C(180)
  Draw.CharVR=D2C(195)
  Draw.CharHU=D2C(193)
  Draw.CharHD=D2C(194)
  Draw.InvOn=D2C(27)||'[7m'
  Draw.InvOff=D2C(27)||'[0m'
  Draw.CharMark=D2C(251)
  Draw.CharSBU=D2C(30)
  Draw.CharSBD=D2C(31)
Return
/* -----------------------------------------------------------*/
/*  */
KeysInit: procedure expose Kbd.
  Kbd.Bs   = 8
  Kbd.Enter= 13
  Kbd.Esc  = 27
  Kbd.Mul  = 42
  Kbd.Plus = 43
  Kbd.Minus= 45
  Kbd.Home = 295
  Kbd.End  = 303
  Kbd.Up   = 296
  Kbd.Dn   = 304
  Kbd.Left = 299
  Kbd.Right= 301
  Kbd.PgUp = 297
  Kbd.PgDn = 305
  Kbd.Ins  = 306
  Kbd.Del  = 307
  Kbd.F5   = 575
  Kbd.F7   = 577
  Kbd.AltU = 534
  Kbd.AltF = 545
  Kbd.AltS = 543
  Kbd.AltD = 544
  Kbd.AltV = 559
  Kbd.CtrlMinus= 654
  Kbd.CtrlPlus = 656
  Kbd.CtrlMul  = 662
  Kbd.CtrlLeft = 339
  Kbd.CtrlRight= 340
  Kbd.CtrlPgUp = 356
  Kbd.CtrlPgDn = 342
Return
/* -----------------------------------------------------------*/
/* ஢ */
QSort: procedure Expose List. GlobVar.
  Parse Arg L R
  I=L
  J=R
  K=(I+J) % 2
  X=List.K
  do until I>J
    do while Equal(List.I,X)=-1
      I=I+1
    end
    do while Equal(X,List.J)=-1
      J=J-1
    end
    if I<=J then
    do
      Call Swap I J
      I=I+1
      J=J-1
    end
  end
  if L<J then call QSort L J
  if I<R then call QSort I R
Return

Equal: procedure expose GlobVar.
  Parse Arg K1,K2
  N1=FileSpec('Name',K1)
  N2=FileSpec('Name',K2)
  P1=Pos('.',N1)
  if (P1>0)&(Length(N1)-P1<4) then E1=SubStr(N1,P1+1)
  else E1=''
  P2=Pos('.',N2)
  if (P2>0)&(Length(N2)-P2<4) then E2=SubStr(N2,P2+1)
  else E2=''
  if GlobVar.SortMode=0 then do
    if N1<N2 then R=-1
    else do
      if N1>N2 then R=1
      else do
        if E1<E2 then R=-1
        else do
          if E1>E2 then R=1
          else R=0
        end
      end
    end
  end
  else do
    if E1<E2 then R=-1
    else do
      if E1>E2 then R=1
      else do
        if N1<N2 then R=-1
        else do
          if N1>N2 then R=1
          else R=0
        end
      end
    end
  end
Return R

Swap: procedure Expose List.
  Parse Arg I1 I2
  Y=List.I1
  List.I1=List.I2
  List.I2=Y
Return

/* -----------------------------------------------------------*/
/* ⥭ ᨬ   */
/* 室:  ⠭ ᨬ */
ReadKey: procedure
  /* Call SysCurState OFF */
  Parse Value SysGetKey('NOECHO') with key
  inkey=C2D(key)
  retkey=inkey
  /* extended codes */
  if inkey=0 | inkey=224 then do
     if RetKey=0 then RetKey=512
     parse Value SysGetKey('NOECHO') WITH key
     inkey=C2D(key)
     retkey=retkey+inkey
  end
Return RetKey
/* -----------------------------------------------------------*/
/*  */
/* 1- -. . . 㣫 */
/* 2- -. . . 㣫 */
/* 3- ப, 㭪 , ࠧ ᨬ ";" */
/* 4- 砫쭮 ࠭ 㭪 */
/* 室:  ࠭ 㭪 */
SelectMenu: procedure expose Draw. Kbd.
  Call SysCurState 'OFF'
  X=Arg(1); Y=Arg(2); S=Arg(3)
  if S='' then Return
  SelectedItem=Arg(4)
  if (SelectedItem='')|(SelectedItem=0) then SelectedItem=1
  OldSelected=SelectedItem
  I=0
  do while S<>''
    parse var S S1 ';' S
    I=I+1; Items.I=' '||S1||' '
  end
  Items.0=I
  if SelectedItem>Items.0 then SelectedItem=1
  MenuLen=0
  do I=1 to Items.0
    if Length(Items.I)>MenuLen then MenuLen=Length(Items.I)
  end
  do I=1 to Items.0; Items.I=Left(Items.I,MenuLen,' '); end
  do I=0 to Items.0+1
    J=I+1
    Buf.J=SysTextScreenRead(Y+I,X,MenuLen+2)
  end
  Buf.0=Items.0+2
  Call SysCurPos Y, X
  HS=Copies(Draw.CharH,MenuLen)
  Call CharOut , Draw.CharLU||HS||Draw.CharRU
  do I=1 to Items.0
    Call SysCurPos Y+I, X
    if I=SelectedItem then do
      Call CharOut , Draw.CharV
      Call CharOut, Draw.InvOn||Items.I||Draw.InvOff
      Call CharOut , Draw.CharV
    end
    else Call CharOut , Draw.CharV||Items.I||Draw.CharV
  end
  Call SysCurPos Y+Items.0+1, X
  Call CharOut , Draw.CharLD||HS||Draw.CharRD
  EndMenu=0
  do while \EndMenu
    Key=ReadKey()
    Select
      when Key=kbd.Enter then EndMenu=1
      when Key=kbd.Esc then do
        SelectedItem=OldSelected
        EndMenu=1
      end
      when Key=kbd.Up then do
        Call SysCurPos Y+SelectedItem, X+1
        Call CharOut, Items.SelectedItem
        if SelectedItem>1 then SelectedItem=SelectedItem-1
        else SelectedItem=Items.0
        Call SysCurPos Y+SelectedItem, X+1
        Call CharOut, Draw.InvOn||Items.SelectedItem||Draw.InvOff
      end
      when Key=kbd.Dn then do
        Call SysCurPos Y+SelectedItem, X+1
        Call CharOut, Items.SelectedItem
        if SelectedItem<Items.0 then SelectedItem=SelectedItem+1
        else SelectedItem=1
        Call SysCurPos Y+SelectedItem, X+1
        Call CharOut, Draw.InvOn||Items.SelectedItem||Draw.InvOff
      end
      when Key=kbd.Home then do
        if SelectedItem>1 then do
          Call SysCurPos Y+SelectedItem, X+1
          Call CharOut, Items.SelectedItem
          SelectedItem=1
          Call SysCurPos Y+SelectedItem, X+1
          Call CharOut, Draw.InvOn||Items.SelectedItem||Draw.InvOff
        end
      end
      when Key=kbd.End then do
        if SelectedItem<Items.0 then do
          Call SysCurPos Y+SelectedItem, X+1
          Call CharOut, Items.SelectedItem
          SelectedItem=Items.0
          Call SysCurPos Y+SelectedItem, X+1
          Call CharOut, Draw.InvOn||Items.SelectedItem||Draw.InvOff
        end
      end
      otherwise NOP
    end
  end
  do I=0 to Items.0+1
    Call SysCurPos Y+I, X
    J=I+1
    Call CharOut , Buf.J
  end
Return SelectedItem
/* -----------------------------------------------------------*/
/* ப . ⥩訩  । */
/* 1- -.  . 㣫 */
/* 2- Y-.  . 㣫 */
/* 3-   */
/* 4- ⪠ */
/* 5- 砫쭮 祭 ।㥬 ப */
/* 室 - 祭 ப */
EditLine: procedure expose Draw. Kbd.
  X=Arg(1); Y=Arg(2); Width=Arg(3); Label=Arg(4); S=Arg(5)
  OldS=S
  Call SysCurState 'OFF'
  Call SysCurPos Y, X
  do I=1 to 4
    Buf.I=SysTextScreenRead(Y+I-1,X,Width)
  end; Buf.0=4
  HL=Copies(Draw.CharH,Width-2)
  Call CharOut , Draw.InvOn||Draw.CharLU||HL||Draw.CharRU
  Call SysCurPos Y+1, X
  Call CharOut , Draw.CharV||' '||Label||':'||Copies(' ',Width-4-Length(Label))||Draw.CharV
  Call SysCurPos Y+2, X
  Call CharOut , Draw.CharV||' '||Draw.InvOff||S||Copies(' ',Width-4-Length(S))||Draw.InvOn||' '||Draw.CharV
  Call SysCurPos Y+3, X
  Call CharOut , Draw.CharLD||HL||Draw.CharRD||Draw.InvOff
  LY=Y+2; LX=X+2
  Call SysCurState 'ON'
  Call SysCurPos LY, LX+Length(S)
  EndEditLine=0
  do while \EndEditLine
    Key=ReadKey()
    Select
      when Key=kbd.Enter then EndEditLine=1
      when Key=Kbd.Esc then do
        S=OldS
        EndEditLine=1
      end
      when Key=kbd.Left then do
        parse Value SysCurPos() with Y1 X1
        if X1>LX then Call SysCurPos LY, X1-1
      end
      when Key=kbd.Right then do
        parse Value SysCurPos() with Y1 X1
        if X1<LX+Length(S) then Call SysCurPos LY, X1+1
      end
      when Key=kbd.Home then do
        parse Value SysCurPos() with Y1 X1
        if X1>LX then Call SysCurPos LY, LX
      end
      when Key=kbd.End then do
        parse Value SysCurPos() with Y1 X1
        if X1<LX+Length(S) then Call SysCurPos LY, LX+Length(S)
      end
      when Key=kbd.CtrlLeft then do
        parse Value SysCurPos() with Y1 X1
        if X1>LX+1 then do
          P=LastPos(' ',S,X1-LX-1)
          if P>0 then do
            if SubStr(S,P+1,1)>' ' then Call SysCurPos Y1, LX+P
          end
          else Call SysCurPos LY, LX
        end
      end
      when Key=kbd.CtrlRight then do
        parse Value SysCurPos() with Y1 X1
        if X1<LX+Length(S) then do
          P=Pos(' ',S,X1-LX+1)
          if P>0 then do
            if SubStr(S,P+1,1)>' ' then Call SysCurPos Y1, LX+P
          end
          else Call SysCurPos LY, LX+Length(S)
        end
      end
      when ((Key>=32)&(Key<=254))|(Key=448) then do
        if Length(S)<Width-5 then do
          parse Value SysCurPos() with Y1 X1
          if Key=448 then Key=224
          S=Left(S,X1-LX)||D2C(Key)||Right(S,Length(S)-X1+LX)
          Call SysCurState 'OFF'
          Call SysCurPos LY, LX
          Call CharOut , S
          Call SysCurPos Y1, X1+1
          Call SysCurState 'ON'
        end
      end
      when Key=kbd.Del then do
        if Length(S)>0 then do
          parse Value SysCurPos() with Y1 X1
          if X1<LX+Length(S) then do
            S=Left(S,X1-LX)||Right(S,Length(S)-X1+LX-1)
            Call SysCurState 'OFF'
            Call SysCurPos LY, LX
            Call CharOut , S||Copies(' ',Width-4-Length(S))
            Call SysCurPos Y1, X1
            Call SysCurState 'ON'
          end
        end
      end
      when Key=kbd.Bs then do
        if Length(S)>0 then do
          parse Value SysCurPos() with Y1 X1
          if X1>LX then do
            S=Left(S,X1-LX-1)||Right(S,Length(S)-X1+LX)
            Call SysCurState 'OFF'
            Call SysCurPos LY, LX
            Call CharOut , S||Copies(' ',Width-4-Length(S))
            Call SysCurPos Y1, X1-1
            Call SysCurState 'ON'
          end
        end
      end
      otherwise NOP
    end
  end
  Call SysCurState 'OFF'
  do I=1 to Buf.0
    Call SysCurPos Y+I-1, X
    Call CharOut , Buf.I
  end
Return S
/* -----------------------------------------------------------*/
/* 稪 ࠭ ⮢ ᯨ᪠ */
/* 室 - - ࠭ ⮢ */
CountSelected: procedure expose Draw. List.
  Count=0
  if List.0>0 then do
    do I=1 to List.0
      if Left(List.I,1)=Draw.CharMark then Count=Count+1
    end
  end
Return Count
/* -----------------------------------------------------------*/
/* 楤 ᯠ 䠩 */
/* 1-  뤥  */
RunUnpack: procedure expose List. Draw. GlobVar. PackList.
  if List.0>0 then do
    CS=CountSelected()
    if CS=0 then do
      Focused=Arg(1)
      N=FileSpec('Name',List.Focused)
      if N<>'' then 'Unpack2' GlobVar.PackFile GlobVar.DestDir '/N:'N
    end
    else do
      SelAll=(CS=List.0)&(List.0=PackList.0)
      if \SelAll then do
        do I=1 to List.0
          if Left(List.I,1)=Draw.CharMark then do
            List.I=SubStr(List.I,2)
            N=FileSpec('Name',List.I)
            if N<>'' then 'Unpack2' GlobVar.PackFile GlobVar.DestDir '/N:'N
          end
        end
      end
      else do
        'Unpack2' GlobVar.PackFile GlobVar.DestDir
        Call UnSelectAll
      end
    end
    Call CharOut , 'Press any key...'
    Key=ReadKey()
  end
Return
/* -----------------------------------------------------------*/
/* Mark/Unmark  ᯨ᪠. */
/* 1-   */
ToggleMark: procedure expose Draw. List.
  Focused=Arg(1)
  if Focused<=List.0 then do
    if List.Focused<>'' then do
      if Left(List.Focused,1)=Draw.CharMark then List.Focused=SubStr(List.Focused,2)
      else List.Focused=Draw.CharMark||List.Focused
    end
    else List.Focused=Draw.CharMark
  end
Return
/* -----------------------------------------------------------*/
/* 롮  ⮢ ᯨ᪠ */
SelectAll: procedure expose Draw. List.
  do I=1 to List.0
    if List.I<>'' then do
      if Left(List.I,1)<>Draw.CharMark then
      List.I=Insert(Draw.CharMark,List.I)
    end
    else List.I=Draw.CharMark
  end
Return
/* -----------------------------------------------------------*/
/* 롮 ⮢ ᯨ᪠  ᪥ */
/* 1- ᪠ 롮 */
SelectByMask: procedure expose Draw. List.
  Mask=Arg(1)
  if Mask='' then Exit
  else do
    do I=1 to List.0
      if List.I<>'' then do
        if (Pos(Mask,Translate(List.I))>0)&(Left(List.I,1)<>Draw.CharMark) then
        List.I=Insert(Draw.CharMark,List.I)
      end
    end
  end
Return
/* -----------------------------------------------------------*/
/* ⬥ 롮  ⮢ ᯨ᪠ */
UnSelectAll: procedure expose Draw. List.
  do I=1 to List.0
    if List.I<>'' then do
      if Left(List.I,1)=Draw.CharMark then
      List.I=SubStr(List.I,2)
    end
  end
Return
/* -----------------------------------------------------------*/
/*  롮  ⮢ ᯨ᪠ */
InvertAll: procedure expose Draw. List.
  do I=1 to List.0
    Call ToggleMark I
  end
Return
/* -----------------------------------------------------------*/
/* 㭪  ⢠ ࠭ ⮢ */
/* 室 - ⢮ ࠭ ⮢*/
CountSelected: procedure expose Draw. List.
  Count=0
  do I=1 to List.0
    if List.I>'' then if Left(List.I,1)=Draw.CharMark then Count=Count+1
  end
Return Count
/* -----------------------------------------------------------*/
/* 㭪 ⮡ࠦ ⢠ ࠭ ⮢ */
/* 뢠  ListBox() */
/* 1- -. */
/* 2- Y-. */
/* 3-   */
DrawCountSelected: procedure expose Draw. List.
  Call SysCurPos Arg(2), Arg(1)
  C=Left(CountSelected(),Arg(3),' ')
  Call CharOut , C
Return
/* -----------------------------------------------------------*/
/* 㭪 ⮡ࠦ 饣 ⢠ ⮢ */
/* 뢠  ListBox() */
/* 1- -. */
/* 2- Y-. */
/* 3-   */
DrawCount: procedure expose Draw. List.
  Call SysCurPos Arg(2), Arg(1)
  C=Left(List.0,Arg(3),' ')
  Call CharOut , C
Return
/* -----------------------------------------------------------*/
/* 㭪 ⮡ࠦ ᪠  */
/* 뢠  ListBox() */
/* 1- -. */
/* 2- Y-. */
/* 3-   */
/* 4- ᪠ ᪠ */
DrawSearchMask: procedure
  parse value SysCurPos() with Y X
  Call SysCurPos Arg(2), Arg(1)
  S=Left(Arg(4),Arg(3),' ')
  Call CharOut , S
  Call SysCurPos Y, X
Return
/* -----------------------------------------------------------*/
/* 㭪 ଠ஢ ப ᯨ᪠  ᮢ. */
/* 뢠  ListBox(), DrawListBox(), ChangeFocus() */
/* 1-  ப */
/* 2-  ப */
/* 室 - ப  */
GetString: procedure expose Draw. List.
  Num=Arg(1); Len=Arg(2)
  if List.0<Num then S=Copies(' ',Len)
  else do
    if Left(List.Num,1)=Draw.CharMark then S=Left(List.Num,Len,' ')
    else S=' '||Left(List.Num,Len-1,' ')
  end
Return S
/* -----------------------------------------------------------*/
/* ᮢ ᯨ᪠ ⮢. 뢠  ListBox() */
/* 1- -.  . 㣫 */
/* 2- Y-.  . 㣫 */
/* 3-  ப */
/* 4- - ப */
/* 5-  孥 ப */
/* 6-  뤥 ப */
DrawListBox: procedure expose Draw. List.
  X=Arg(1); Y=Arg(2); Len=Arg(3); Count=Arg(4); First=Arg(5); Focused=Arg(6)
  do I=0 to Count-1
    Call SysCurPos Y+I, X
    J=First+I
    S=GetString(J,Len)
    if J=Focused then do
      S=Draw.InvOn||S||Draw.InvOff
      FY=Y+I
    end
    if I=0 then do
      if First=1 then S=S||Draw.CharV
      else S=S||Draw.CharSBU
    end
    if I=Count-1 then do
      if J>=List.0 then S=S||Draw.CharV
      else S=S||Draw.CharSBD
    end
    Call CharOut , S
  end
  Call SysCurPos FY,X
Return
/* -----------------------------------------------------------*/
/*  䮪 ᯨ᪠ ⮢. 뢠  ListBox() */
/* 1- -.  . 㣫 */
/* 2- Y-.  . 㣫 */
/* 3-  ப */
/* 4-  뤥  */
/* 5- 0-, 1- */
/* 室 -   뤥   */
ChangeFocus: procedure expose Draw. List.
  X=Arg(1); Y=Arg(2); Len=Arg(3); Focused=Arg(4); FocDn=Arg(5)=1
  S=GetString(Focused,Len)
  Call CharOut , S
  if \FocDn then do
    Focused=Focused-1; Y=Y-1
  end
  else do
    Focused=Focused+1; Y=Y+1
  end
  Call SysCurPos Y, X
  S=GetString(Focused,Len)
  Call CharOut , Draw.InvOn||S||Draw.InvOff
  Call SysCurPos Y, X
Return  Focused
/* -----------------------------------------------------------*/
/* ᮪ ⮢   ப⪨, ⪨  .. */
/* 1- -.  . 㣫 */
/* 2- Y-.  . 㣫 */
/* 3-   */
/* 4-   */
/* 5-   */
ListBox: procedure expose Draw. Kbd. List. GlobVar. PackList.
  X=Arg(1); Y=Arg(2); Width=Arg(3); High=Arg(4); WName=Arg(5)
  if Width<30 then Width=30
  if High<5 then High=5
  Call SysCurState 'OFF'
  Call SysCurPos Y, X
  HLUp1=Copies(Draw.CharH,(Width-4-Length(WName))%2)
  HLUp2=Copies(Draw.CharH,(Width-4-Length(WName))//2)
  Call CharOut , Draw.CharLU||HLUp1||' '||WName||' '||HLUp2||HLUp1||Draw.CharRU
  CountLines=High-4
  do I=1 to CountLines
    Call SysCurPos Y+I, X
    if I=1 then do
      Call CharOut , Draw.CharV||Draw.InvOn||' '
      if List.0>0 then Call CharOut , Left(List.I,Width-3,' ')
      else Call CharOut , Copies(' ',Width-3)
      Call CharOut , Draw.InvOff||Draw.CharV
    end
    else do
      if I>List.0 then S=Copies(' ',Width-3)
      else S=Left(List.I,Width-3,' ')
      if (I<>CountLines)|(List.0<=CountLines) then Call CharOut , Draw.CharV||' '||S||Draw.CharV
      else Call CharOut , Draw.CharV||' '||S||Draw.CharSBD
    end
  end
  SBX=X+Width-1; SBUY=Y+1; SBDY=Y+CountLInes
  HLDown=Copies(Draw.CharH,Width-2)
  Call SysCurPos Y+High-3, X
  Call CharOut , Draw.CharVR||HLDown||Draw.CharVL
  Call SysCurPos Y+High-2, X
  Call CharOut , Draw.CharV||' '||'Selected: '||Left(CountSelected(),5,' ')||'Files: '||Left(List.0,Width-25,' ')||Draw.CharV
  CSY=Y+High-2; CSX=X+12; FY=CSY; FX=CSX+12
  SMY=CSY; SMX=FX+5
  Call SysCurPos Y+High-1, X
  Call CharOut , Draw.CharLD||HLDown||Draw.CharRD
  LY=Y+1; LX=X+1
  Call SysCurPos LY, LX
  SLine=Copies(' ',Width-2)
  Focused=1; First=1; EndListBox=0; SearchMask=''
  do while \EndListBox
    Key=ReadKey()
    Select
      when Key=Kbd.Esc then EndListBox=1

      when Key=Kbd.Ins then do
        Call ToggleMark Focused
        if Focused<List.0 then do
          parse Value SysCurPos() with Y1 X1
          Call DrawCountSelected CSX, CSY, 4
          Call SysCurPos Y1, X1
          if Y1<Y+CountLines then Focused=ChangeFocus(X1,Y1,Width-2,Focused,1)
          else do
            Focused=Focused+1; First=First+1
            Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
          end
        end
        else do
          Call CharOut , Draw.InvOn||GetString(Focused,Width-2)||Draw.InvOff
          Call DrawCountSelected CSX, CSY, 4
          Call SysCurPos Y1, X1
        end
      end

      when Key=Kbd.Up then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        if Focused>1 then do
          parse Value SysCurPos() with Y1 X1
          if Y1>LY then Focused=ChangeFocus(X1,Y1,Width-2,Focused,0)
          else do
            Focused=Focused-1; First=First-1
            Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
          end
        end
      end

      when Key=Kbd.Dn then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        if Focused<List.0 then do
          parse Value SysCurPos() with Y1 X1
          if Y1<Y+CountLines then Focused=ChangeFocus(X1,Y1,Width-2,Focused,1)
          else do
            Focused=Focused+1; First=First+1
            Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
          end
        end
      end

      when Key=Kbd.PgUp then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        if Focused>1 then do
          if First>CountLines then First=First-CountLines+1
          else First=1
          if Focused>CountLines then Focused=Focused-CountLines+1
          else do
            Call CharOut , GetString(Focused,Width-2)
            Focused=1
          end
          Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
        end
      end

      when Key=Kbd.PgDn then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        if Focused<List.0 then do
          if First<List.0-CountLines+1 then First=First+CountLines-1
          if Focused<List.0-CountLines+1 then Focused=Focused+CountLines-1
          else Focused=List.0
          Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
        end
      end

      when (Key=Kbd.Home)|(Key=Kbd.CtrlPgUp) then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        if Focused>1 then do
          Call CharOut , GetString(Focused,Width-2)
          Focused=1; First=1
          Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
        end
      end

      when (Key=Kbd.End)|(Key=Kbd.CtrlPgDn) then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        if Focused<List.0 then do
          Focused=List.0; First=List.0-CountLines+1
          Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
        end
      end

      when Key=Kbd.Plus then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        parse Value SysCurPos() with Y1 X1
        S=EditLine(5,5,24,'Select by mask',GlobVar.SelectMask)
        if S<>'' then NewMask=Translate(S)
        else NewMask=''
        if NewMask<>GlobVar.SelectMask then do
          GlobVar.SelectMask=NewMask
          if GlobVar.SelectMask<>'' then do
            Call SelectByMask GlobVar.SelectMask
            Call DrawCountSelected CSX, CSY, 4
            Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
          end
        end
        else do
          Call SysCurPos Y1, X1
          Call CharOut , Draw.InvOn||GetString(Focused,Width-2)||Draw.InvOff
          Call SysCurPos Y1, X1
        end
      end

      when Key=Kbd.CtrlPlus then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        Call SelectAll
        Call DrawCountSelected CSX, CSY, 4
        Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
      end

      when (Key=Kbd.Minus)|(Key=Kbd.CtrlMinus) then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        GlobVar.SelectMask=''
        Call UnSelectAll
        Call DrawCountSelected CSX, CSY, 4
        Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
      end

      when Key=Kbd.AltF then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        GlobVar.SelectMask=''
        parse Value SysCurPos() with Y1 X1
        S=EditLine(5,5,24,'Filter',GlobVar.Filter)
        if S<>'' then NewFilter=Translate(S)
        else NewFilter=''
        if NewFilter<>GlobVar.Filter then do
          GlobVar.Filter=NewFilter
          Call GetList
          if List.0>0 then Call QSort 1 List.0
          First=1; Focused=1
          Call DrawCountSelected CSX, CSY, 4
          Call DrawCount FX,FY,4
          Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
        end
        else do
          Call SysCurPos Y1, X1
          Call CharOut , Draw.InvOn||GetString(Focused,Width-2)||Draw.InvOff
          Call SysCurPos Y1, X1
        end
      end

      when (Key=Kbd.AltD)|(Key=Kbd.F7) then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        parse Value SysCurPos() with Y1 X1
        GlobVar.DestDir=EditLine(5,5,48,'Destination directory',GlobVar.DestDir)
        Call SysCurPos Y1, X1
        Call CharOut , Draw.InvOn||GetString(Focused,Width-2)||Draw.InvOff
        Call SysCurPos Y1, X1
      end

      when Key=Kbd.AltS then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        parse value SysCurPos() with Y1 X1
        V1=GlobVar.SortMode+1
        V=SelectMenu(5,4,'Sort by Name;Sort by Extention',V1)
        if V<>V1 then do
          GlobVar.SortMode=V-1
          if List.0>0 then Call QSort 1 List.0
          First=1; Focused=1
          Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
        end
        else do
          Call SysCurPos Y1, X1
          Call CharOut , Draw.InvOn||GetString(Focused,Width-2)||Draw.InvOff
          Call SysCurPos Y1, X1
        end
      end

      when Key=Kbd.AltV then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        parse value SysCurPos() with Y1 X1
        V1=GlobVar.ViewMode+1
        V=SelectMenu(5,4,'Full path;Name only',V1)
        if V<>V1 then do
          GlobVar.ViewMode=V-1
          Call GetList
          if List.0>0 then Call QSort 1 List.0
          First=1; Focused=1
          Call DrawCount FX, FY, 4
          Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
        end
        else do
          Call SysCurPos Y1, X1
          Call CharOut , Draw.InvOn||GetString(Focused,Width-2)||Draw.InvOff
          Call SysCurPos Y1, X1
        end
      end

      when (Key=Kbd.AltU)|(Key=Kbd.F5) then do
        parse value SysCurPos() with Y1 X1
        BufY=0; BufX=0; ScrW=80
        Buf.0=24
        do I=1 to Buf.0
          Buf.I=SysTextScreenRead(BufY+I-1,BufX,ScrW)
        end
        Call SysCls
        Call RunUnpack Focused
        Call SysCls
        do I=1 to Buf.0
          Call SysCurPos BufY+I-1, BufX
          Call CharOut , Buf.I
        end
        Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
      end

      when (Key=Kbd.Mul)|(Key=Kbd.CtrlMul) then do
        if SearchMask<>'' then do
          SearchMask=''
          Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        end
        Call InvertAll
        Call DrawCountSelected CSX, CSY, 4
        Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
      end

      when ((Key>=32)&(Key<=254))|(Key=448) then do
        SearchMask=SearchMask||Translate(D2C(Key))
        Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        Found=0
        do I=1 to List.0 while \Found
          Found=Pos(SearchMask,List.I)>0
        end
        if Found & (Focused<>I-1) then do
          Focused=I-1
          if Abs(Focused-First)>=CountLines then First=Focused
          Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
        end
      end

      when Key=Kbd.Bs then do
        if SearchMask<>'' then SearchMask=Left(SearchMask,Length(SearchMask)-1)
        Call DrawSearchMask SMX,SMY,X+Width-1-SMX,SearchMask
        if SearchMask<>'' then do
          Found=0
          do I=1 to List.0 while \Found
            Found=Pos(SearchMask,List.I)>0
          end
          if Found & (Focused<>I-1) then do
            Focused=I-1
            if Abs(Focused-First)>=CountLines then First=Focused
            Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
          end
        end
        else do
          if Focused>1 then do
            Focused=1; First=1
            Call DrawListBox LX,LY,Width-2,CountLines,First,Focused
          end
        end
      end

      otherwise NOP
    end
  end
Return
/* -----------------------------------------------------------*/
/* 뢮  ணࠬ */
DrawProgramTitle: procedure expose Draw.
  Title='Unpack Manager 1.0'
  S=Copies(Draw.CharH,(78-Length(Title)-2)%2)
  Call SysCurState 'OFF'
  Call SysCurPos 0, 1
  Call CharOut , S||' '||Title||' '||S
Return
/* -----------------------------------------------------------*/
Halt:
  Call SysCls
  Call SysCurState 'ON'
  Exit
Return
/* -----------------------------------------------------------*/
DrawHelp: procedure
  X=Arg(1); Y=Arg(2)
  Call SysCurPos Y, X
  Call CharOut , 'Ins      - Select'
  Call SysCurPos Y+1, X
  Call CharOut , '"+"      - Select by mask'
  Call SysCurPos Y+2, X
  Call CharOut , 'Ctrl-"+" - Select all'
  Call SysCurPos Y+3, X
  Call CharOut , '"-"      - Deselect all'
  Call SysCurPos Y+4, X
  Call CharOut , '"*"      - Invert selection'
  Call SysCurPos Y+5, X
  Call CharOut , 'Alt-D,F7 - Destination dir'
  Call SysCurPos Y+6, X
  Call CharOut , 'Alt-F    - Filter'
  Call SysCurPos Y+7, X
  Call CharOut , 'Alt-U,F5 - Extract'
  Call SysCurPos Y+8, X
  Call CharOut , 'Alt-S    - Sort mode'
  Call SysCurPos Y+9, X
  Call CharOut , 'Alt-V    - View mode'
  Call SysCurPos Y+10, X
  Call CharOut , 'Esc      - Exit'
Return
/* -----------------------------------------------------------*/

