/* rexx script color ping for perversant                  (c) stas kive 2003 */
/* '@mode co50,10' */
/* ---------- FTPLoadFuncs ---------------------- */
if 0 < RxFuncQuery('FtpLoadFuncs') then
 do
  call RxFuncAdd  'FtpLoadFuncs','rxFtp','FtpLoadFuncs'
  call FtpLoadFuncs
  if 0 < RxFuncQuery('FtpLoadFuncs') then say 'Error !!! TCP/IP not supported on this comp.'
 end

/* ---------------------------------------------- */
ETC=value('ETC',,'OS2ENVIRONMENT')
signal on halt name CtrlC
signal on syntax
call rexxcolor
/* ---------------------------------------------- */
lst.0=0
hst.0=0
config=etc'\'||'pinghost.lst'
call readcfg
say s.c.cls
/* ---------------------------------------------- */
Do forever
 do i=1 to lst.0
  rc = FtpPing(lst.i,'60')
  if datatype(rc)='NUM' then bip=0; else bip=1
  select
    when rc='PINGREPLY'  then rc=s.b.red'Host does not reply    '
    when rc='PINGSOCKET' then rc=s.b.yel'Unable to obtain socket'
    when rc='PINGPROTO'  then rc=s.b.mag'Unknown protocol ICMP  '
    when rc='PINGSEND'   then rc=s.b.mag'Send failed            '
    when rc='PINGRECV'   then rc=s.b.mag'Receive failed         '
    when rc='PINGHOST'   then rc=s.b.yel'Unknown host           '
    otherwise rc=s.b.grn||substr(rc,1,23,' ')
  end
  say s.b.wit||lst.i' 'hst.i' 'rc s.b.mag
  if bip=1 then call beeps 1500 5
  call syssleep 1
 end
 say D2C(27)||'['||lst.0+3||'A'Date('N') Time('N')
end
return 2
/* ---------------------------------------------- */
beeps: procedure
parse arg note ret
do i=1 to ret
   call beep note,200
end
return
/* ---------------------------------------------- */
/*

 If no error occurred, FtpPing() call returns the number  of milliseconds
 it took for the echo to return.

 If an error occurred, the return values are:

  Return values     Description

       PINGREPLY    Host does not reply
       PINGSOCKET   Unable to obtain socket
       PINGPROTO    Unknown protocol ICMP
       PINGSEND     Send failed
       PINGRECV     Receive failed
       PINGHOST     Unknown host

*/
/* ---------------------------------------------- */
rexxcolor:
Esc=D2C(27)
S.B.Blc=Esc||'[1;30m';S.B.Red=Esc||'[1;31m'
S.B.Grn=Esc||'[1;32m';S.B.Yel=Esc||'[1;33m'
S.B.Blu=Esc||'[1;34m';S.B.Mag=Esc||'[1;35m'
S.B.Cya=Esc||'[1;36m';S.B.Wit=Esc||'[1;37m'
S.N.Blc=Esc||'[0;30m';S.N.Red=Esc||'[0;31m'
S.N.Grn=Esc||'[0;32m';S.N.Yel=Esc||'[0;33m'
S.N.Blu=Esc||'[0;34m';S.N.Mag=Esc||'[0;35m'
S.N.Cya=Esc||'[0;36m';S.N.Wit=Esc||'[0;37m'
S.g.Blc=Esc||'[40m'  ;S.g.Red=Esc||'[41m'
S.g.Grn=Esc||'[42m'  ;S.g.Yel=Esc||'[43m'
S.g.Blu=Esc||'[44m'  ;S.g.Mag=Esc||'[45m'
S.g.Cya=Esc||'[46m'  ;S.g.Wit=Esc||'[47m'
S.A.All=Esc||'[0m'   ;S.A.Bld=Esc||'[1m'
S.A.Nor=Esc||'[2m'   ;S.A.Cur=Esc||'[3m'
S.A.Bli=Esc||'[5m'   ;S.A.FBl=Esc||'[6m'
S.A.Inv=Esc||'[7m'   ;S.A.Msk=Esc||'[8m'
S.C.Cls=Esc||'[2J'   ;S.C.Cll=Esc||'[K'
S.C.CUp=Esc||'[1A'   ;S.C.CDn=Esc||'[1B'
S.C.CRt=Esc||'[1C'   ;S.C.CLt=Esc||'[1D'
S.C.CPS=Esc||'[1s'   ;S.C.CPR=Esc||'[1u'
S.C.Bak=Esc||'[1A'   ;S.C.Ba2=Esc||'[2A'
return S.
/* ---------------------------------------------- */
readcfg:
fc = stream(config,'c','query exists')
if fc='' then do
 say s.b.red' Error open 's.b.yel config s.n.wit
 exit
                     end
else
 do
 fc = stream(config,'c','open')
 i=0
  do while lines(config)
    str=strip(linein(config))
    str=translate(str,' ','09'x)
    if substr(str,1,1)='#' then iterate;
    if str='' then iterate;
              else do
    parse value str with keyword entry';'suxx
    lst.0 = lst.0 + 1 ; hst.0 = hst.0 + 1 ; i = lst.0
    lst.i = substr(keyword,1,16,' ')      ; hst.i = substr(space(entry),1,16,' ')
                   end
  end
 fc = stream(config,'c','close')
 end
return
/* ---------------------------------------------- */
/* ddebbuggingg procedure */
CtrlC:
  Say "Ctrl-C 믮 p pp  p "sigl
 exit 90

Syntax:
  Say "訡  ப "sigl
  call SysLog "訡  ப "sigl
 exit 98

NoValue:
  Say  "H樠஢ ६  ப "sigl
  call SysLog "H樠஢ ६  ப "sigl
 exit 99

SysLog: procedure  /* ⠥ ᮮ饭  ࠭   䠩 */
    parse arg message
    parse source . . me
    logfile = me||".debug"
    call lineout logfile, date() time() || "  " || filespec("N", me)":" message
    call lineout logfile
Return
