/* 
 *   A REXX script to keep WarpVision cli "server" running
 *   valerius, 2007, Jan 8
 */

parse arg file

file = strip(file, 'B', '"')
if file \= '' then
  file = stream(file, 'c', 'query exists')

call RexxInit

if \WvRunning() then
  do while \WvRunning()
    if \WvRunning() then
      'detach wvision -vasp43 -perm'
    call SysSleep 2
    if file \= '' then do
      'echo open' file '>\pipe\wv'
      file = ''
    end
  end
else
  'echo open' file '>\pipe\wv'


exit 0
/* ======================================== */
RexxInit: procedure

if RxFuncQuery('SysLoadFuncs') then do
  call RxFuncAdd 'SysLoadFuncs', 'rexxutil', 'SysLoadFuncs'
  call SysLoadFuncs
end


return
/* ======================================== */
WvRunning: procedure

call cleanque
'ps wvision | rxqueue'

do 2
  pull .
end

if queued() > 0 then do
  call cleanque
  return 1
end
call cleanque

return 0
/* ======================================== */
cleanque: procedure

do queued()
  pull .
end


return
/* ======================================== */
