/* 
 *  Network card(s) autodetection
 *  (c) Team Boot/2, 2014, Feb
 */

'@echo off'

network = value('NETWORK',, 'OS2ENVIRONMENT')
bootdrv = value('BOOTDRV',, 'OS2ENVIRONMENT')
sysdrv  = value('SYSDRV',,  'OS2ENVIRONMENT')

/* sysdrv='w:'  */
/* bootdrv='h:' */

/* root dir */
root = sysdrv
/* max network cards number */
MAX_NICS = 3
/* NIC model list */
niclist  = root || '\tools\bin\genproto.slo'
/* EOLN symbol */
crlf = '0d 0a'x

/* zip file names (without an extension) 
   containing dirs called 'wrapper_vid_pid' 
   each of which contains (optional) windoze 
   driver with .inf/.reg, and (optional)
   a patch file. The OS/2 NIC driver can 
   be patched (which not necessary would
   be GenMac). 'Misc' is intended to store
   patches to a non-Genmac OS/2 drivers. 
   They all must be put in \genmac\driver
   directory on a 'sysdrv' */
DriverPacks = 'genmac genmu misc'

call RxFuncAdd 'SysFileTree', 'rexxutil', 'SysFileTree'
call RxFuncAdd 'SysSleep', 'rexxutil', 'SysSleep'

call cleanque

/* get NIC's list from pci.exe */
root || '\tools\pci\pci.exe | awk -v cls="Network" -f scanpci.awk | rxqueue'

/* just for test */
/* 'cat ' || root || '\tools\pci\vpc-dtp.log | awk -v cls="Network" -f scanpci.awk | rxqueue'       */
/* 'cat ' || root || '\tools\pci\vova-desk.log | awk -v cls="Network" -f scanpci.awk | rxqueue'     */
/* 'cat ' || root || '\tools\pci\ben-tosh.log | awk -v cls="Network" -f scanpci.awk | rxqueue'      */
/* 'cat ' || root || '\tools\pci\pci-asus-note.log | awk -v cls="Network" -f scanpci.awk | rxqueue' */
/* 'cat ' || root || '\tools\pci\pci-asus-work.log | awk -v cls="Network" -f scanpci.awk | rxqueue' */

curdir = directory()

do i = 1 to MAX_NICS
  id = ''

  if queued() > 0 then 
     parse pull id

  id.i = id
end
id.0 = i - 1

call cleanque

do l = 1 to MAX_NICS
  desc = ''
  nif = ''
  
  if id.l = '' then 
    cfg = ''
  else
    cfg = getcfg(id.l)

  if cfg = '' then do
    /* No NIC description is found in 'genproto.slo' */
    /* if unknown then iterate */
    id.l   = 'None      '
    ind.l  = l /* i */
    os2.l  = 'nullndis.os2'
    nif.l  = 'nullndis.nif'
    desc.l = 'NULL NDIS driver'

    call unpack_drv
    
    /* 'set DETECT_NIF_' || l || '=nullndis.nif' */
    /* 'set DETECT_OS2_' || l || '=nullndis.os2' */
    call value 'DETECT_NIF_' || l, 'nullndis.nif', 'OS2ENVIRONMENT'
    call value 'DETECT_OS2_' || l, 'nullndis.os2', 'OS2ENVIRONMENT'
    
    iterate
  end

  /* otherwise, if NIC is found in 'genproto.slo' */
  parse var cfg nif desc
  nif = translate(nif)

  if nif = '' then iterate

  ind.l  = l  /* i */
  os2.l  = drv
  nif.l  = nif
  desc.l = desc

  call unpack_drv
  
  /*  'set DETECT_NIF_' || l || '=' || nif */
  /* 'set DETECT_OS2_' || l || '=' || drv  */
  call value 'DETECT_NIF_' || l, nif, 'OS2ENVIRONMENT'
  call value 'DETECT_OS2_' || l, drv, 'OS2ENVIRONMENT'
end
os2.0 = l

select
  when network = 'auto'   then 
    detect = 1;
  when network = 'user' then
    detect = 2;
  when network = 'null'   then do
    detect = 1; 
    l = 0;
  end
  when network = 'none'   then do
    say 'The network is disabled!'
    exit 0
  end
  otherwise
    nop
end

if l < MAX_NICS then do l = os2.0 + 1 to MAX_NICS
    /* 'set DETECT_NIF_' || l || '=nullndis.nif' */
    /* 'set DETECT_OS2_' || l || '=nullndis.os2' */
    call value 'DETECT_NIF_' || l, 'nullndis.nif', 'OS2ENVIRONMENT'
    call value 'DETECT_OS2_' || l, 'nullndis.os2', 'OS2ENVIRONMENT'
    ind.l  = l
    id.l   = 'None      '
    os2.l  = 'nullndis.os2'
    nif.l  = 'nullndis.nif'
    desc.l = 'NULL NDIS driver'
    
    call unpack_drv
end

call directory bootdrv || '\ibmcom'

'copy ' || sysdrv || '\tools\bin\genproto.* . >nul 2>&1'

'attrib -h -r -s *'

'if not exist ' || bootdrv || '\ibmcom\macs ' ||,
    'mkdir ' || bootdrv || '\ibmcom\macs'

/* 1 - automatic, if possible; 2 - user */
/* genproto.exe + genproto.slo are (c) Veit Kannegieser */

'genproto ' || detect

call directory bootdrv || '\ibmcom\macs'

/* rename driver files to ndis?.os2 */
do k = 1 to MAX_NICS
  'attrib -h -r -s ndis' || k || '.os2'
  'if exist ndis' || k || '.os2 del  ndis' || k || '.os2 >nul 2>&1'
  'copy ' || os2.k || ' ndis' || k || '.os2 >nul 2>&1'
end

/*
do i = 1 to MAX_NICS
  say 'detect_nif_' || i || '=' || value('detect_nif_' || i,, OS2ENVIRONMENT)
  say 'detect_os2_' || i || '=' || value('detect_os2_' || i,, OS2ENVIRONMENT)
end
*/

say 'Network cards found:'

do l = 1 to MAX_NICS
 /* i = ind.l */

  /* Change ',' to ':' */
  id   = translate(id.l, ':', ',')

  /*  and delete '$'   */
  do 2
    p  = pos('$', id)
    if p > 0 then id = delstr(id, p, 1)
  end

  /* unpack windoze driver from .ZIP archive to ramdisk for GenMAC */
  /* if pos('GENM32W', translate(os2.i)) > 0 then do */
    name = translate('wrapper_' || translate(id, '_', ':'))

    do num = 1 to words(DriverPacks)
      DriverPack = word(DriverPacks, num)
      
      /* unpack wendoze drivers and patches to OS/2 drivers */
      'if exist ' || sysdrv || '\genmac\driver\' || DriverPack  || '.zip ',
          'unzip -oqC ' || sysdrv || '\genmac\driver\' || DriverPack || '.zip ' || name ||, 
              '\* -d ' || bootdrv || '\genmac\driver\ >nul 2>&1'

      /* 'if exist ' || sysdrv || '\genmac\driver\' || DriverPack  || '.7z ',
          '7z x -r -y -o' || bootdrv || '\genmac\driver\ ' ||,
           sysdrv || '\genmac\driver\' || DriverPack || '.7z ' || name || '\* 2>&1'*/
  
       /* apply patch (if any) */
       'if exist ' || bootdrv || '\genmac\driver\' || name || '\patch.dat ',  
          'call pat.cmd ' || bootdrv || '\genmac\driver\' || name ||, 
              '\patch.dat ndis' || l || '.os2 >nul 2>&1'
    end
  /* end */
  
  if id \= '' then
     say 'lan' || (l-1) || ': ' || id || ' ' || desc.l
end

'rem cd ' || root || '\ibmcom\macs'

call directory curdir


exit 0
/* -----======================----- */
cleanque:

do while queued() > 0
  pull .
end

return
/* -----======================----- */
getcfg: procedure expose niclist
line = ''

call cleanque
'awk -v id=' || arg(1) || ' -f getnic.awk ' || niclist || ' | rxqueue'
/* get the very first card description from NIC list */
if queued() > 0 then parse pull line
call cleanque

return line
/* -----======================----- */
unpack_drv:
driver = os2.l

  call directory bootdrv || '\ibmcom'
  
  /* unpack .nif to ramdrive */
  'unzip -qoC ' || sysdrv || '\ibmcom\macs\drv.zip ' || nif.l ||,
      ' -d ' || bootdrv || '\ibmcom'

  /* unpack extra files */
  call cleanque
  call directory curdir
  'awk -f extras.awk ' || bootdrv || '\ibmcom\' || nif.l || ' | rxqueue'
  call directory bootdrv || '\ibmcom'
  
  do while queued() > 0
    parse pull file
    if file = '' then iterate
    /* unpack extra files to ramdrive */
    'unzip -qoC ' || sysdrv || '\ibmcom\macs\drv.zip ' || file ||,
        ' -d ' || bootdrv || '\ibmcom'
  end
  
  call cleanque
  call directory curdir

  /* get driver params from NIF */
  'awk -F= -f nif.awk ' || bootdrv || '\ibmcom\' || nif.l || ' | rxqueue'
  
  do while queued() > 0 
     parse pull driver
     if driver \= '' 
       then leave
  end

  call cleanque

  if driver = '' then return
  
  call directory bootdrv || '\ibmcom'

  /* unpack driver to ramdrive */
  'unzip -qoC ' || sysdrv || '\ibmcom\macs\drv.zip ' || driver ||,
      ' -d ' || bootdrv || '\ibmcom'

  call directory curdir
  
  drv   = driver
  os2.l = driver
  
return
/* -----======================----- */
