/*
 *   M$ IE to OS/2 URL objects converter.
 *   (c) valerius, 2006, Aug 27
 *   BSD license ;-)
 */


parse arg args

call rxInit

expList = 'opt. opts. objCount stack'

objCount = 0

/* Queue name  */
que   = 'ie2rc_que'

call exposeSymTable

opts.location = '<WP_DESKTOP>'

call parseCmdLine args

opt.infile = strip(opt.infile, 'B', '"')

stack = RxQueue('CREATE', que)
call recurseFile opt.infile
call RxQueue 'DELETE', stack


exit 0
/* -------------======================----------------- */
recurseFile: procedure expose (expList)
infile = arg(1)

call sysFileTree infile, 'list.', 'B'

if list.0 = 1 then do
  parse var list.1 . . . attr spec
  if substr(attr, 2, 1) = 'D' then do
    /* It's a directory */
    call processFolder spec
    /* Go to the parent directory */
    oq = RxQueue('SET', stack)
    parse pull opts.location
    call RxQueue 'SET', oq
  end
  else do
    /* It's a file */
    if lastpos('.url', spec) = length(spec) - 3
      then
        call processUrl spec
  end
end


return
/* -------------======================----------------- */
processFolder: procedure expose (expList)
infile = arg(1)

p = lastpos('\', infile)
if p > 0 then text = substr(infile, p + 1)
call outFolder , text

call sysFileTree infile'\*', 'list.', 'B'

do i = 1 to list.0
  parse var list.i . . . attr spec
  call recurseFile spec
end


return
/* -------------======================----------------- */
processUrl: procedure expose (expList)
infile = arg(1)

q = (infile = '')

if \q then do
  infile = strip(infile)
  infile = strip(infile, 'B', '"')
  q = ( stream(infile, 'c', 'query exists') \= '' )
end

if q then do
  if infile \= '' then
    ret = stream(infile, 'c', 'open read')

  do while lines(infile)
    line = linein(infile)
    line = strip(line)
    if line = '[InternetShortcut]' then
      do while lines(infile)
        line = linein(infile)
        line = strip(line)
        p = pos('URL', line)
        if p = 1 then do
          parse var line 'URL=' url
          parse var infile text '.url'
          q = lastpos('\', text)
          if q > 0 then
            text = substr(text, q + 1)
          call outUrl url, text
        end
      end
  end

  if infile \= '' then
    ret = stream(infile, 'c', 'close')
end
else do
  call lineout 'stderr', 'Error: file 'infile' does not exist!'
  exit -255
end


return
/* -------------======================----------------- */
outUrl: procedure expose (expList)
url  = arg(1)
text = arg(2)

objCount = objCount + 1

text = makeObjectName(text)

opts.name     = text
opts.class    = 'WPUrl'
opts.opt      = 'UPDATE'

opts.objId = makeObjectId(text)

opts.setup = 'TITLE='text';URL='url ||,
             ';OBJECTID='opts.objId';'

call rcOut


return
/* -------------======================----------------- */
outFolder: procedure expose (expList)
url  = arg(1)
text = arg(2)

objCount = objCount + 1

text = makeObjectName(text)

opts.name  = text
opts.class = 'WPUrlFolder'
opts.opt   = 'UPDATE'

opts.objId = MakeObjectId()

oq = RxQueue('SET', stack)
push opts.location
call RxQueue 'SET', oq

opts.setup = 'TITLE='text';SHOWALLINTREEVIEW=YES' ||,
             ';OBJECTID='opts.objId';'

call rcOut

opts.location = opts.objId


return
/* -------------======================----------------- */
makeObjectName: procedure expose (expList)
text = arg(1)


do forever
  parse var text first '&' symbol ';' last
  if symbol = '' then
    leave
  do i = 1 to sym.0
    if symbol = sym.i then do
      symbol = sym.i.val
      leave
    end
  end
  text = first || symbol || last
end

text = translate(text, '|`', ';"')
text = deleteQuotes(text)
text = stripUrl(text)
text = stripEOL(text)
text = strip(text)


return text
/* -------------======================----------------- */
stripUrl: procedure
line = arg(1)

if pos('://', line) > 0 then do
  parse var line head proto '://' domain '/' tail

  if proto = '' then do
    proto = head
    head = ''
  end

  p = lastpos('/', tail)
  tail = substr(tail, p + 1)

  line = head domain tail
  line = despace(line)
end

line = strip(line)


return line
/* -------------======================----------------- */
deleteQuotes: procedure
line = arg(1)

do forever
  p = pos('"', line)
  if p > 0 then
    line = delstr(line, p, 1)
  else
    leave
end


return line
/* -------------======================----------------- */
stripEOL: procedure expose opt.
line = arg(1)

do forever
  p = pos(opt.EOL, line)
  if p = 0
    then leave
  parse var line first (opt.EOL) last
  line = first || last
end


return line
/* -------------======================----------------- */
makeObjectId: procedure expose (expList)
text = arg(1)

/* Prefixes for object ids */

/* For Url */
prefix.url     = '<MY_URL_'
/* For Url Folder */
prefix.urlf    = '<MY_URLF_'
/* Default prefix */
prefix.other   = '<MY_'

select
  when opts.class = 'WPUrl' then
    prefix = prefix.url

  when opts.class = 'WPUrlFolder' then
    prefix = prefix.urlf

  otherwise
    prefix = prefix.other
end

id = prefix || objCount || '>'


return id
/* -------------======================----------------- */
rcOut: procedure expose opts.

app = '"PM_InstallObject"'
key = '"' || opts.name     || ';' || opts.class ||,
      ';' || opts.location || ';' || opts.opt   || '"'

opts.setup = strip(opts.setup)
opts.setup = strip(opts.setup, 'L', ';')

val = '"'opts.setup'"'

line = '  'app'    'key'   'val

say line


return
/* -------------======================----------------- */
parseCmdLine: procedure expose opt.
args = arg(1)

opt.infile = args


return
/* -------------======================----------------- */
exposeSymTable: procedure expose sym.

sym.0 = 8
sym.1 = 'nbsp';      sym.1.val = ' '
sym.2 = 'laquo';     sym.2.val = '`'
sym.3 = 'raquo';     sym.3.val = ''''
sym.4 = 'amp';       sym.4.val = '&'
sym.5 = 'quot';      sym.5.val = '"'
sym.6 = 'lt';        sym.6.val = '<'
sym.7 = 'gt';        sym.7.val = '>'
sym.8 = 'hellip';    sym.8.val = ''


return
/* -------------======================----------------- */
rxInit:

call rxFuncAdd 'sysLoadFuncs', 'rexxutil', 'sysLoadFuncs'
call sysLoadFuncs


return
/* -------------======================----------------- */
