/*
 *  Converts an indented text file (.lst)
 *  to .rc file.
 *  (c) valerius, 2006, Jun 26
 *  _valerius (dog) mail (dot) ru
 *  BSD license
 */



parse arg args

call ParseCmdLine args

expList = 'BaseFldrId CurFldrId ParentFldrId',
          'urls folders pad spc nestlevel',
          'curfldlevel nextelemcntr'

urls = 0
folders = 0

BaseFldrId = '<WP_DESKTOP>'
CurFldrId = ''
ParentFldrId = ''

pad = '    '
spc = ''
nestlevel = 0
curfldlevel= 0

/* Counter of elements following this
   folder on the same level of nesting */
nextelemcntr = 0

q = (infile = '')

if \q then q = (stream(infile, 'c', 'query exists') \= '')

if q then do

if infile \= '' then
  ret = stream(infile, 'c', 'open read')

que    = RxQueue('CREATE', 'lst2rc_que')
oldque = RxQueue('SET', que)

objs = 0
do while lines(infile)
  line = linein(infile)
  line1 = line
  line = strip(line)
  if line = ''
  then iterate
  else do
    if lines(infile) then do
      line = linein(infile)
      line2 = line
      line = strip(line)
      if line = ''
      then do
        call lineout 'stderr', 'Must be two non-empty lines in order!'
        exit -1
      end
      else do
        objs = objs + 1
        call processLines line1, line2
      end
    end
  end
end

call RxQueue 'SET', oldque
call RxQueue 'DELETE', que

if infile \= '' then
  ret = stream(infile, 'c', 'close')

end
else do
  call lineout 'stderr', 'file 'infile' doesn''t exist!'
  exit -255
end





exit 0
/* -----------=====================-------------- */
ParseCmdLine: procedure expose infile
args = arg(1)

infile = args


return
/* -----------=====================-------------- */
processLines: procedure expose (expList) que oldque
line1 = arg(1)
line2 = arg(2)

url   = strip(line2)
title = strip(line1)

l = length(url)

s = ''

do l
  s = s || '~'
end

p = pos(title, line1)
if p > 0 then
  nestlevel = (p - 1) / 4

/* Indent left */
if nestlevel = curfldlevel &,
   queued() > 0            &,
   nextelemcntr = 0  then do
  nextelemcntr = nextelemcntr + 1
  curfldlevel = curfldlevel - 1
  parse pull CurFldrId
end
else
do while nestlevel < curfldlevel &,
         queued() > 0
  curfldlevel = curfldlevel - 1
  parse pull CurFldrId
end

select

  /* When Url equals l times '~' */
  when abbrev(url, s, 3)
    then do
      call processFolder title
    end

  otherwise do
      call processUrl title, url
    end

end


return
/* -----------=====================-------------- */
processFolder: procedure expose (expList)
title = arg(1)

folders = folders + 1
nextelemcntr = 0

FldrId = '<MY_URLF_'folders'>'
if ParentFldrId = '' then CurFldrId = BaseFldrId

opts.name  = delstr(title, 30)
opts.class = 'WPUrlFolder'
opts.location = CurFldrId
opts.opt = 'UPDATE'

opts.setup = 'TITLE='title';SHOWALLINTREEVIEW=YES;' ||,
             'OBJECTID='FldrId';'

call RcOut


push CurFldrId
ParentFldrId = CurFldrId
CurFldrId = FldrId
curfldlevel = nestlevel


return
/* -----------=====================-------------- */
processUrl: procedure expose (expList)
title = arg(1)
url = arg(2)

urls = urls + 1

id = '<MY_URL_'urls'>'

opts.name  = delstr(title, 30)
opts.class = 'WPUrl'
opts.location = CurFldrId
opts.opt = 'UPDATE'

opts.setup = 'URL='url';TITLE='title';' ||,
             'OBJECTID='id';'

call RcOut


return
/* -----------=====================-------------- */
RcOut: procedure expose opts.

app = '"PM_InstallObject"'
key = '"' || opts.name     || ';' || opts.class ||,
      ';' || opts.location || ';' || opts.opt   || ';"'

opts.setup = strip(opts.setup)
opts.setup = strip(opts.setup, 'L', ';')

val = '"'opts.setup'"'

line = '  'app'    'key'   'val

say line


return
/* -----------=====================-------------- */
