/*
 *  Mozilla bookmarks to URL objects converter
 *  Usage:
 *  moz2rc [ -f <Folder> ] bookmarks.html > file.rc
 *  (c) valerius, 2006, Feb 3
 *  _valerius (dog) mail (dot) ru,
 */

parse arg args

args.basefolder = ''
BaseFldrId = '<WP_DESKTOP>'
ParentFldrId = ''

call ParseCmdLine

if args.basefolder \= '' then
  BaseFldrId = args.basefolder

expList  = 'cp hostcp CountUrlFldrs CountUrls',
           'ParentFldrId CurFldrId dir BaseFldrId',
           'newque oldque'

call InitRxDlls
cp = 'UTF-8'
hostcp = UniQueryCp()

dir = ''

q = (bkmk = '')

if \q then
  q = ( stream(bkmk, 'c', 'query exists') \= '' )

if q then do

CountUrls = 0
CountUrlFldrs = 0

if bkmk \= '' then
  rc = stream(bkmk, 'c', 'open read')

newque = RxQueue('CREATE', 'bkmk2rc_que')
oldque = RxQueue('SET', newque)

do while lines(bkmk)
  line = linein(bkmk)
  line = strip(line)
  call processLine line
end

call RxQueue 'SET', oldque
call RxQueue 'DELETE', newque

if bkmk \= '' then
  rc = stream(bkmk, 'c', 'close')

end


exit 0
/* ================================================ */
processLine: procedure expose (expList)
line = arg(1)

select
    when abbrev(line, '<META', 5) then do
      parse value line with '<META' line '>'
      do while line \= ''
        parse value line with var '="' val '"' line
        line = strip(line)
        if var = 'CONTENT' then
        do i = 1 to words(val)
          wd = word(val, i)
          parse value wd with 'charset=' wd
          if wd \= '' then do
            cp = wd
            leave
          end
        end
      end
    end
    when abbrev(line, '<H', 2) then do
      parse value line with '<H' . '>' line '</H' .
      line = UniXlat(line, hostcp, cp)
      dir = line
    end
    when abbrev(line, '<DT>', 4) then do
      parse value line with '<DT>' line
      line = UniXlat(line, hostcp, cp)
      call ParseDT line
    end
    when abbrev(line, '<DL>', 4) then do
      CountUrlFldrs = CountUrlFldrs + 1
      title = normalize(dir)
      FldrId = '<MY_URLF_'CountUrlFldrs'>'
      if ParentFldrId = '' then CurFldrId = BaseFldrId
      say '   "PM_InstallObject"  "'title';WPUrlFolder;'CurFldrId';PRESERVEOLD"                   "SHOWALLINTREEVIEW=YES;OBJECTID='FldrId'"'
      push CurFldrId
      ParentFldrId = CurFldrId
      CurFldrId = FldrId
    end
    when abbrev(line, '</DL>', 5) then do
      /* CurFldrId = ParentFldrId */
      if queued() > 0 then
        parse pull CurFldrId
      /*  parse pull ParentFldrId */
    end
    otherwise nop
end


return
/* ================================================ */
ParseDT: procedure expose (expList)
line = arg(1)

select
  when abbrev(line, '<A', 2) then do
    parse value line with '<A HREF="' url '"' . '>' line '</A>'
    CountUrls = CountUrls + 1
    id = '<MY_URL_'CountUrls'>'
    line = normalize(line)
    say '   "PM_InstallObject"  "'line';WPUrl;'CurFldrId';PRESERVEOLD"                          "URL='url';OBJECTID='id'"'
  end
  when abbrev(line, '<H', 2) then do
    parse value line with '<H' . '>' line '</H' .
    dir = line
  end
  otherwise nop
end


return
/* ================================================ */
ParseCmdLine: procedure expose args bkmk args.

do while args \= ''

  opt = getarg()

  if pos('-', opt) = 1 then
  select
    when opt = '-h'
      then do
        call GiveHelp
        exit 0
      end

    when opt = '-f'
      then do
        args.basefolder = getarg()
      end

    otherwise nop
  end
  else do
    args = opt args
    leave
  end

end

bkmk = args


return
/* ================================================ */
getarg: procedure expose args

/* Gets one word, or a line, enclosed
   in quotes, from args               */

args = strip(args)

if pos('"', args) == 1 then
  parse value args with '"' opt '"' args
else
  parse var args opt args


return opt
/* ================================================ */
normalize: procedure
line = arg(1)

from = ';'
to   = '|'

line = translate(line, to, from)
line = left(line, 64)
line = strip(line)


return line
/* ================================================ */
InitRxDlls:

  call RxFuncAdd 'SysLoadFuncs', 'rexxutil', 'SysLoadFuncs'
  call SysLoadFuncs


  call RxFuncAdd 'UniLoadFuncs', 'rexxuni', 'UniLoadFuncs'
  call UniLoadFuncs


return
/* ================================================ */
GiveHelp:

call lineout 'stderr', ''
call lineout 'stderr', 'Mozilla bookmarks to .rc file converter.'
call lineout 'stderr', '(c) valerius, 2006'
call lineout 'stderr', ''
call lineout 'stderr', 'Usage:'
call lineout 'stderr', 'bkmk2rc [-h | -f <folder>] <bookmarks file> > rcfile.rc'
call lineout 'stderr', ''


return
/* ================================================ */
