/*
 *  Converts a tree of WPS objects into .rc file,
 *  uses WPTools by Henk Kelder.
 *  (c) valerius, 2006 Apr 06, 00h 50m.
 */


/*** User setup: **************************/

debug = 0 /* Debugging off */

/*  Path to the debug log  */
logfile = 'f:\cur\wps\稩 ⮫1\conv.log'

/******************************************/

/* Expose list for procedures */
expList = 'debug logfile prop.'

parse arg args

if args = '' then do
  call lineout 'stderr', 'You must pass a single WPS object or folder to this script!'
  exit -255
end

call InitRxDlls

/* obj = '<WP_DESKTOP>' */
/* obj = '<URLF_MY_2>'  */
/* obj = 'F:\cur\wps\稩 ⮫1\\Web-㧫\Bookmarks\OSes\osdev' */
/* obj = 'wptools' */

obj = args
obj = strip(obj, 'B', '"')

if debug then do
  'if exist "'logfile'" @del "'logfile'" 2>&1 >\dev\nul'
  rc = stream(logfile, 'c', 'open write')
end

call log 'The script is invoked on object: 'obj

if WPToolsQueryObject(obj,,
                      'prop.Class',,
                      'prop.Title',,
                      'prop.Setup',,
                      'prop.Location') then do

  /* The 'prop.' stem stores properties of
          the current processed object      */

  call Recurse obj

end
else do
  call log 'Error querying object properties by wptools: 'obj
  call log 'trying other means...'

  /* On success, modifies 'prop.' stem */
  if FSQueryObject(obj) then do

    call log 'querying fs object properties by fs, OK'
    call Recurse obj

  end
  else
    call log 'querying fs object properties by fs, failure!'
end

if debug then
  rc = stream(logfile, 'c', 'close')


exit 0
/* ======================================= */
FSQueryObject: procedure expose (expList)
obj = arg(1)


/*
   Query properties of 'defective' filesystem objects
   without .CLASSINFO EA's by checking their
   '.TYPE' and '.LONGNAME' EA's and also
   file contents. (These 'defective' objects
   (usually, URL's) are usually
   made by Mozilla)                                    */

if SysGetEA(obj, '.TYPE', type) = 0 then do
  type = substr(type, 11)
  call log 'EA ''.TYPE'' queried, value: "'type'"'
  select
    when type == 'UniformResourceLocator' then do

      p = lastpos('\', obj)
      loc = substr(obj, 1, p - 1)

      if SysGetEA(obj, '.LONGNAME', tit) = 0 then do
        call log 'EA ''.LONGNAME'' queried, value: "'tit'"'
        if tit \= '' then tit = substr(tit, 5)
        if tit = '' then do
          tit = substr(obj, p + 1)
          call log '''.LONGNAME'' EA is empty, using filename: "'tit'"'
        end
      end
      else do
        call log 'SysGetEA for ''.LONGNAME'' failed!'
      end

      rc = stream(obj, 'c', 'open read')
      if rc = 'READY:' then do
        call log 'File '''obj''' opened for reading.'
        url = linein(obj)
        call log 'Read URL '''url''' from the file '''obj''''
      end
      else do
        call log 'Can''t open file '''obj''' for reading!'
        return 0
      end
      rc = stream(obj, 'c', 'close')

      prop.Class = 'WPUrl'
      prop.Title = tit
      prop.Setup = 'URL='url';'
      prop.Location = loc

    end
    otherwise nop
  end
end
else do
  call log 'Can''t query ''.TYPE'' EA'
  return 0
end

return 1
/* ======================================= */
Recurse: procedure expose (expList)
parse arg obj

select

  when prop.Class = 'WPFolder'    |,
       prop.Class = 'XWPFolder'   |,
       prop.Class = 'WPDesktop'   |,
       prop.Class = 'WPUrlFolder' |,
       prop.Class = 'MMFolder'      then do

    call ProcessFolder   obj
    call RecurseFolder   obj

  end

  when prop.Class = 'WPUrl'         then

    call ProcessFile     obj

  when prop.Class = 'WPProgram'   |,
       prop.Class = 'WPShadow'      then

    call ProcessAbstract obj

  otherwise

    call ProcessDefault  obj

end

return
/* ======================================= */
RcOut: procedure expose (expList)

app = '"PM_InstallObject"'
key = '"'prop.Title';'prop.Class';'  ||,
         prop.Location';UPDATE;"'
val = '"'prop.Setup'"'

say '  'app'    'key'   'val


return
/* ======================================= */
ProcessFolder: procedure expose (expList)
parse arg folder

call log 'ProcessFolder: 'folder

call RcOut


return
/* ======================================= */
ProcessFile: procedure expose (expList)
parse arg url

call log 'ProcessUrl: 'url

call RcOut


return
/* ======================================= */
ProcessAbstract: procedure expose (expList)
parse arg abs

call log 'ProcessAbstract: 'abs

call RcOut


return
/* ======================================= */
ProcessDefault: procedure expose (expList)
parse arg obj

call log 'ProcessDefault: 'obj

call RcOut


return
/* ======================================= */
RecurseFolder: procedure expose (expList)
parse arg folder

call log 'RecurseFolder: 'folder', Class: 'prop.Class

/* Create the list of all filesystem
   and all abstract objects in folder:    */

if WPToolsFolderContent(folder, 'objs', 'F') then do

  do i = 1 to objs.0
    if WPToolsQueryObject(objs.i,,
                          'prop.Class',,
                          'prop.Title',,
                          'prop.Setup',,
                          'prop.Location')

    then do

      call Recurse objs.i

    end
    else do
      call log 'Can''t query object properties: 'objs.i'!'
      exit -7
    end
  end

end
else
  call log 'Can''t query folder content!: 'folder' (WPToolsFolderContent)'

return
/* ======================================= */
toupper: procedure
word = arg(1)

lower = '񦧨',
        'abcdefghijklmnopqrstuvwxyz'

upper = '',
        'ABCDEFGHIJKLMNOPQRSTUVWXYZ'

return translate(word, upper, lower)
/* ======================================= */
log: procedure expose (expList)
str = arg(1)

if debug then
  call lineout logfile, str


return
/* ======================================= */
InitRxDlls:

  call RxFuncAdd 'SysLoadFuncs', 'rexxutil', 'SysLoadFuncs'
  call SysLoadFuncs

  call RxFuncAdd "WPToolsLoadFuncs", "wptools", "WPToolsLoadFuncs"
  call WPToolsLoadFuncs


return
/* ======================================= */
