/*
 *  Specialized AWK dialect to REXX compiler, for processing .rc files.
 *  .rc is a file for creating .INI file entries, for use with makeini.
 *  [---------------------------]
 *  Usage:
 *  rawk -f script1.tr -v var1=val1 ... -v varn=valn ... -f scriptm ... <file1.rc> ... <filel.rc>
 *  Paths with spaces must be enclosed in double quotes (").
 *  [---------------------------]
 *  (c) valerius, 2006, Apr 06
 *  _valerius (dog) mail (dot) ru
 */

rcfile = ''

parse arg args

call ParseCmdLine args

/*

signal on syntax  name break
signal on halt    name break

 */


/*
/* Command line parsing results: */

 call lineout 'stderr', 'count = 'count
 do i = 1 to rcfile.0
   call lineout 'stderr', 'rcfile.'i' = 'rcfile.i
 end

 do i = 1 to script.0
   call lineout 'stderr', 'script.'i' = 'script.i
   call lineout 'stderr', 'script.'i'.vars = 'script.i.vars
   w = words(script.i.vars)
   if w > 0 then
   do l = 1 to w
     var = word(script.i.vars, l)
     val = script.i.vars.var
     call lineout 'stderr', 'script.'i'.vars.'var' = 'val
   end
 end

exit 0

 */


/* Expose list */

expList = 'script. keyword. n casevar prop. expSect lineno',
          'inbegin inend inperline inexpr blockCount',
          'CompileNext LastClause InClause'

/* current switch clause parameter */

casevar = ''

/* Section flags */

inbegin = 0
inend = 0
inperline = 0
inexpr = 0

lineno = 0

/* Open braces counter */
blockCount = 0

/* RAwk keywords: */
keyword.0  = 11
keyword.1  = 'if'
keyword.2  = 'else'
keyword.3  = 'switch'
keyword.4  = 'while'
keyword.5  = 'do'
keyword.6  = 'for'
keyword.7  = 'break'
keyword.8  = 'continue'
keyword.9  = 'next'
keyword.10 = 'nextfile'
keyword.11 = 'exit'


/* default values */
drop Title
drop Class
drop Location
drop Opt
drop Setup

prop.Title = ''
prop.Class = ''
prop.Location = ''
prop.Opt = ''
prop.Setup = ''


do i = 1 to script.0
  rc = compile(i)
  if \rc then do
    call lineout 'stderr', 'Error compiling script 'script.i'!'
    exit -1
  end
end


/*

rcfile.0 = 1
rcfile.1 = rcfile

 */

result = BeginHandler()

do i = 1 to rcfile.0

  rcfile = rcfile.i

 /*
  *  if <rcfile> = '' then getting data from stdin
  */

  if rcfile \= '' then do
    rc = stream(rcfile, 'c', 'open read')
    if rc \= 'READY:' then do
      call lineout 'stderr', 'Error opening input file: 'rcfile
      exit -1
    end
  end

  do lines = 1 while lines(rcfile)
    line = linein(rcfile)
    line = strip(line)
    if line = '' then iterate
   call ParseLine line
    skip = 0
    do s = 1 to script.0
      if script.s.expr.0 > 0 then
      do r = 1 to script.s.expr.0
        if script.s.expr.r.2 = '' then do
          if script.s.expr.r.1 = '' then do
            call lineout 'stderr', 'script.'s'.expr.'0' > 0 but '
            call lineout 'stderr', 'script.'s'.expr.'r'.1 and script.'s'.expr.'r'.2'
            call lineout 'stderr', 'both empty!'
            exit -1
          end
          else do
            /*       some black magic:       */
            /* this is to interpret properly
               contents of the variable as a
               REXX expression               */
            f = script.s.expr.r.1
            interpret 'f = 'f
            if f then do
              /* Single expression patterns */
              result = PerLineHandler(s, r)
              skip = 0
            end
            else do
              skip = 1
              iterate r
            end
          end
        end
        else do
          /*   Range patterns  */
          /* some black magic: */
          f = script.s.expr.r.1
          interpret 'f = 'f
          if f then do
            f = 0
            do until f

              result = PerLineHandler(s, r)
              select
                when result = 'NEXT:' then
                  iterate lines
                when result = 'NEXTFILE:' then
                  iterate i
                otherwise nop
              end
              line = StoreLine()
              say line

              u = 0
              do while lines(rcfile)
                u = 1
                line = linein(rcfile)
                line = strip(line)
                if line = '' then iterate
                call ParseLine line
                /* some black magic: */
                f = script.s.expr.r.2
                interpret 'f = 'f
                leave
              end
              if \lines(rcfile) then f = 1

            end
            f = 0
            if u then do
              result = PerLineHandler(s, r)
              select
                when result = 'NEXT:' then
                  iterate lines
                when result = 'NEXTFILE:' then
                  iterate i
                otherwise nop
              end
              line = StoreLine()
              say line
              iterate lines
            end
            else
              iterate lines
          end
          else /* f = 0 */
            iterate lines
        end
      end
      else do
        /* PERLINE section (without a pattern) */
        result = PerLineHandler(s)
      end
    end
    if \skip then do
      select
        when result = 'NEXT:' then
          iterate lines
        when result = 'NEXTFILE:' then
          iterate i
        otherwise nop
      end
      line = StoreLine()
      say line
    end
  end

  if rcfile \= '' then
    rc = stream(rcfile, 'c', 'close')

end

result = EndHandler()


exit 0
/* ----------------------------------------- */
ParseCmdLine: procedure expose script. rcfile.,
                               count
args = arg(1)

/* Parse the command line: */

f = 0

count = 0
k = 0
l = 0


do while args \= ''

  opt = getarg()

  count = count + 1

  select
    when opt = '-f' then do
      /* scripts counter */
      k = k + 1
      opt = getarg()
      count = count + 1
      script.k = opt
      script.k.vars = ''
      f = 1
    end

    when opt = '-v' then do
      if f then do
        opt = getarg()
        count = count + 1
        p = pos('=', opt)
        if p > 0 then do
          parse var opt var '=' val
          script.k.vars.var = val
          script.k.vars = script.k.vars var
        end
        else do
          call lineout 'stderr', 'Option 'opt' is not variable value assignment!'
          exit -1
        end
      end
    end

    when \abbrev(opt, '-', 1) then do
      f = 0
      l = l + 1
      rcfile.l = opt
    end

    otherwise do
      f = 0
    end

  end

end
script.0 = k
rcfile.0 = l


return
/* ----------------------------------------- */
getarg: procedure expose args

/* Gets one word, or a line, enclosed
   in quotes, from args               */

args = strip(args)

if pos('"', args) == 1 then
  parse value args with '"' opt '"' args
else
  parse var args opt args


return opt
/* ----------------------------------------- */
compile: procedure expose (expList)
n = arg(1)

/* Compile a whole script */

script = script.n

rc = stream(script, 'c', 'query exist')
if rc = 0 then do
  call lineout 'stderr', 'Script 'script' doesn''t exist!'
  return 0
end

rc = stream(script, 'c', 'open read')

script.n.BEGIN = ''
script.n.PERLINE = ''
script.n.END = ''

drop script.n.expr.
drop script.n.handler.

/* Divide a program into sections
   and process them separately:
   BEGIN, PERLINE and END or
   conditional.                  */

/* Conditional sections counter: */
/* expr1[,expr2] { ... }         */
expSect = 0

lineno = 0
line = ''
do while lines(script)

  do while lines(script)
    line = normalize(line)
    if line = '' then do
      line = linein(script)
      lineno = lineno + 1
    end
    else
      leave
  end

  if pos('{', line) = 1 then do
    line = delstr(line, 1, 1)
    if \(inbegin | inend | inexpr) then do
      inbegin = 0
      inend = 0
      inexpr = 0
      inperline = 1
      blockCount = 1
    end
    call CompileClause '{'
  end

  if inbegin   |,
     inend     |,
     inperline |,
     inexpr then
    call ProcessSection

  line = normalize(line)
  if line = '' then iterate

  if pos('BEGIN', line) = 1 then do
    inbegin = 1
    inend = 0
    inperline = 0
    inexpr = 0
    blockCount = 0
    line = delstr(line, 1, 5)
    iterate
  end

  if pos('END', line) = 1 then do
    inbegin = 0
    inend = 1
    inperline = 0
    inexpr = 0
    blockCount = 0
    line = delstr(line, 1, 3)
    iterate
  end

  if substr(line, 1, 1) \= '{'     &,
     substr(line, 1, 5) \= 'BEGIN' &,
     substr(line, 1, 3) \= 'END'  then do

    p = pos('{', line)
    if p > 0 then do
      expSect = expSect + 1
      parse value line with exp '{' line
      parse value exp with exp.1 ',' exp.2
      exp.1 = strip(exp.1)
      exp.2 = strip(exp.2)
      exp.1 = CompileExpr(exp.1)
      exp.2 = CompileExpr(exp.2)
      if exp.1 = 'ERROR:' then do
        call lineout 'stderr', 'Invalid expression!:'
        call lineout 'stderr', exp.1
        call lineout 'stderr', 'line: 'lineno
        exit -1
      end
      if exp.2 = 'ERROR:' then do
        call lineout 'stderr', 'Invalid expression!:'
        call lineout 'stderr', exp.2
        call lineout 'stderr', 'line: 'lineno
        exit -1
      end
      script.n.expr.expSect.1 = exp.1
      script.n.expr.expSect.2 = exp.2
      script.n.handler.expSect = ''
      inexpr = 1
      inbegin = 0
      inend = 0
      inperline = 0
      line = strip(line)
      line = '{ ' || line
    end
    else
      do until p > 0 | \lines(script)
        next = linein(script)
        lineno = lineno + 1
        next = normalize(next)
        if next = '' then iterate
        line = line next

        line = AddImplicitSemicolons(line)

        p = pos('{', line)
      end
  end

end
script.n.expr.0 = expSect
script.n.handler.0 = expSect

rc = stream(script, 'c', 'close')


return 1
/* ----------------------------------------- */
ProcessSection: procedure expose (expList),
                          script line

/*
 *  Processing of one program section:
 *        BEGIN, END or PERLINE
 *           (or conditional)
 */


loops = 0
do while lines(script)

  line = strip(line)

  loops = loops + 1

  if loops == 1 then blockCount = 1

  /* Whether to exit section: */
  if blockCount = 0 then do
    inbegin = 0
    inend = 0
    inperline = 0
    inexpr = 0
    leave
  end

  if line = '' then do
    lineno = lineno + 1
    line = linein(script)
    line = normalize(line)
    iterate
  end

  line = AddImplicitSemicolons(line)

  if pos('{', line) = 1 then do
    blockCount = blockCount + 1
    line = delstr(line, 1, 1)
    call CompileClause '{'
    iterate
  end

  if pos('}', line) = 1 then do
    blockCount = blockCount - 1
    /* delete '}' together with ';' */
    line = delstr(line, 1, 2)
    call CompileClause '}'
    iterate
  end

  line = strip(line)
  if line = '' then iterate

  p = pos(';', line)
  if p > 0 then do
    parse value line with clause ';' line
    clause = strip(clause)
    if clause \= '' then
       call CompileClause clause
    line = strip(line)
    if line = '' then iterate
  end
  else
    do until p > 0 | \lines(script)
      lineno = lineno + 1
      next = linein(script)
      next = normalize(next)
      if next = '' then iterate
      line = line next

      line = AddImplicitSemicolons(line)

      p = pos(';', line)
    end

end


return
/* ----------------------------------------- */
normalize: procedure expose keyword.
line = arg(1)

/* Get the line in 'normal' form i.e.,
   with no extra spaces, tabs and
   without comments                  */

from = '09'x
to   = ' '

p = pos('#', line)
if p > 0 then line = delstr(line, p)
line = strip(line)

line = translate(line, to, from)
line = despace(line)


return line
/* ----------------------------------------- */
despace: procedure
line = arg(1)

/* Remove double spaces
   from the line        */

do forever
  p = pos('  ', line)
  if p > 0 then line = delstr(line, p, 1)
  else
    leave
end


return line
/* ----------------------------------------- */
AddImplicitSemicolons: procedure expose keyword.
line = arg(1)

/* Add semicolons before and after
   closing braces                 */
p = 0
do forever
  p = pos('}', line, p + 1)

  if p <= 0 then leave

  if substr(line, p + 1, 1) \= ';' &,
     substr(line, p + 2, 1) \= ';' then
    line = insert(';', line, p)

  if p > 1 then do
    q = substr(line, p - 1, 1)
    if q \= ' ' &,
       q \= ';'    then do
      line = insert('; ', line, p - 1)
      p = p + 1
    end
    else
    if p > 2 & q = ' ' then do
      r = substr(line, p - 2, 1)
      if r \= ';' then do
        line = insert(';', line, p - 2)
        p = p + 1
      end
    end
  end

end

/* Add semicolons after parameters in round
   brackets after a keyword,
   or, if there's no parameters, then
   add semicolon after a keyword          */
p = 0
do i = 1 to keyword.0
  kw = keyword.i
  do forever
    p = pos(kw, line, p + 1)
    if p > 0 then do
      l = length(kw)
      p1 = pos('(', line, p + l)
      p2 = pos(')', line, p1 + 1)

      if p1 > 0 & p2 == 0 then iterate

      if (p1 == p + l      |,
          p1 == p + l + 1) &,
          p2 > p1 + 1    then do
        line = insert(';', line, p2)
      end
      else do
        line = insert(';', line, p + l - 1)
      end
    end
    else
      leave
  end
end


return line
/* ----------------------------------------- */
CompileClause: procedure expose (expList)
/* Current clause to compile */
clause = arg(1)

/* Compiles a clause from RAwk to REXX.
   Must (in future) add a compiled clause
   to the corresponding section of a compiled
   script; but now it just prints one clause
   at a time to screen.                     */

script = script.n

pull .

last = word(LastClause, 1)

/* `last' is a program clause, previous to
    the current clause                      */
select
  when last = 'switch' then
    if CompileNext & clause = '{' then do
      blockCount = blockCount + 1
      return ''
    end

  when last = 'while' then
    if CompileNext & clause = '{' then do
      blockCount = blockCount + 1
      return ''
    end

  when last = 'do' then do
    /* do; { ... }; while (cond);
    -> do forever; ...; if \cond; then; leave; end; */

  end

  otherwise nop
end

CompileNext = 0

/*
section = ''

if inbegin   then section = 'BEGIN'   else
if inperline then section = 'PERLINE' else
if inend     then section = 'END'

if section = '' then do
  call lineout 'stderr', 'Script: 'script
  call lineout 'stderr', 'Unknown script section:'
  call lineout 'stderr', 'not BEGIN, PERLINE or END!'
  exit -1
end
 */

/* Check if the line begins with keyword */

cond = ''
rest = ''
do i = 1 to keyword.0
  kw = keyword.i
  p = pos(kw, clause)
  if p = 1 then do
    parse value clause with (kw) rest
    rest = strip(rest)
    if rest \= '' then do
      parse value rest with '(' cond ')' rest
      cond = strip(cond)
      rest = strip(rest)
      if rest \= '' then do
        call lineout 'stderr', 'Compilation error, junk after condition: '
        call lineout 'stderr', clause
        call lineout 'stderr', 'Junk: 'rest
        exit -1
      end
    end
    leave
  end
  else
    kw = ''
end

/*
/* script.1.BEGIN or such: */
prefix = 'script.'n'.'section
 */

if kw \= '' then do
/* a keyword found */
  LastClause = clause
  select
    when kw == 'if'    then do
      if cond == '' then do
        call lineout 'stderr', '`if'' clause hasn''t a condition: '
        call lineout 'stderr', clause
        exit -1
      end
      result = CompileExpr(cond)
      if result = 'ERROR:' then do
        call lineout 'stderr', '`if'' clause has invalid condition: '
        call lineout 'stderr', clause
        exit -1
      end
      else
        clause = 'if 'result'; then'
    end

    when kw == 'else'  then
      clause = 'else'

    when kw == 'switch'  then do
      if cond == '' then do
        call lineout 'stderr', '`switch'' clause hasn''t a condition: '
        call lineout 'stderr', clause
        exit -1
      end
      if CheckIdentifier(cond) then
        casevar = cond
      else do
        call lineout 'stderr', 'Incorrect switch identifier:'
        call lineout 'stderr', cond
        call lineout 'stderr', clause
        exit -1
      end
      CompileNext = 1
      clause = 'select'
    end

    when kw == 'do' then do
      if cond \= '' then do
        call lineout 'stderr', '`do'' clause has a condition: '
        call lineout 'stderr', '"'clause'"'
        exit -1
      end
      InClause = 'do'
      CompileNext = 1
      clause = 'do forever'
    end

    when kw == 'while' then do
      if cond == '' then do
        call lineout 'stderr', '`while'' clause hasn''t a condition: '
        call lineout 'stderr', clause
        exit -1
      end
      result = CompileExpr(cond)
      if result = 'ERROR:' then do
        call lineout 'stderr', '`while'' clause has invalid condition: '
        call lineout 'stderr', clause
        exit -1
      end
      if InClause = 'do' then do
        InClause = ''
        clause = 'if \('result'); then; leave; end'
      end
      else do
        clause = 'do while 'result
        CompileNext = 1
      end
    end

    otherwise nop
  end
end
else do

  if clause = '{' then
    clause = 'do'
  else
  if clause = '}' then
    clause = 'end'
  else
  if casevar \= '' then do
    kw = 'case '
    p = pos(kw, clause)
    if p = 1 then do
      parse value casevar with (kw) val ':' rest
      if datatype(val) \= 'NUM' then do
        call lineout 'stderr', 'switch parameter must be numeric:'
        call lineout 'stderr', clause
        exit -1
      end
      rest = strip(rest)
      if rest \= '' then
         call CompileClause rest
    end
    else do
      call lineout 'stderr', '`case'' must follow `switch'', but not:'
      call lineout 'stderr', clause
      exit -1
    end
  end
  else do
    /* Assignment operator */
    parse value clause with var '=' expr

    if expr \= "" &,
       CheckIdentifier(var) then
      clause = 'script.'n'.vars.'var' = 'CompileExpr(expr)
  end

end

say clause';'


return clause
/* ----------------------------------------- */
GetNextClause: procedure


return
/* ----------------------------------------- */
CompileExpr: procedure
expr = arg(1)

/* Parse and compile expressions           */
/* Returns same expression, compiled
   to REXX, or 'ERROR:', if it was invalid */

/* dummy */

return expr
/* ----------------------------------------- */
CheckIdentifier: procedure
id = arg(1)

/* Check if the name of identifier
   is valid                        */

x = substr(id, 1, 1)
if datatype(x) == 'NUM' then return 0
if pos(' ', x) > 0 then return 0


return 1
/* ----------------------------------------- */
UpdateSetup: procedure expose prop.
e = arg(1)

/* Update Setup string element */
/* Input: ELEM=VALUE           */
/* I.e. : UpdateSetup('ICONVIEW=NONFLOWED,VISIBLE,MINI') */

parse value e with elem '=' val

last = prop.Setup.0

flag = 0
do i = 1 to last
  el = prop.Setup.i
  parse value el with el '=' v
  if el == elem then do
    flag = 1
    if val = 'undef' then do
      prop.Setup.i = prop.Setup.last
      prop.Setup.0 = prop.Setup.0 - 1
      drop prop.Setup.last
      last = last - 1
    end
    else
      prop.Setup.i = e
    leave
  end
end

if \flag & val \= 'undef' then do
  last = last + 1
  prop.Setup.last = e
  prop.Setup.0 = last
end

prop.Setup = ''

do i = 1 to last
  prop.Setup = prop.Setup || prop.Setup.i || ';'
end

prop.Setup = '"'prop.Setup'"'


return
/* ----------------------------------------- */
GetSetup: procedure expose prop.
e = arg(1)

/* Gets setup string element           */
/* I.e., string = GetSetup('ICONVIEW') */

flag = 0
do i = 1 to prop.Setup.0
  el = prop.Setup.i
  parse value el with el '=' val
  if el = e then do
    flag = 1
    leave
  end
end

if \flag then
  return 'undef'


return val
/* ----------------------------------------- */
BeginHandler: procedure expose (expList) line

do i = 1 to script.0
  /* interpret sets result */
  interpret(script.i.BEGIN)
  select
    when result = 'NEXT:'     then return 'NEXT:'
    when result = 'NEXTFILE:' then return 'NEXTFILE:'
    otherwise nop
  end
end


return ''
/* ----------------------------------------- */
EndHandler: procedure expose (expList) line

do i = 1 to script.0
  /* interpret sets result */
  interpret(script.i.END)
  select
    when result = 'NEXT:'     then return 'NEXT:'
    when result = 'NEXTFILE:' then return 'NEXTFILE:'
    otherwise nop
  end
end


return ''
/* ----------------------------------------- */
PerLineHandler: procedure expose (expList) line
i = arg(1)
sec = arg(2)

/* getline -> rc = Getline() */
/* interpret sets result */
if sec = '' then
  interpret(script.i.PERLINE)
else
  interpret(script.i.handler.sec)
select
  when result = 'NEXT:'     then return 'NEXT:'
  when result = 'NEXTFILE:' then return 'NEXTFILE:'
  otherwise nop
end


return ''
/* ----------------------------------------- */
Getline: procedure expose (expList) line rcfile

/* Called from "interpret(script.i.PERLINE)",
   gets and parses a new line from .rc file.
   Realizes a getline AWK statement        */

if lines(rcfile) then
  line = linein(rcfile)
else
  return 0

call ParseLine line

return 1
/* ----------------------------------------- */
GetlineVar: procedure expose (expList) line rcfile


return
/* ----------------------------------------- */
GetlineFromFile: procedure expose (expList) line rcfile


return
/* ----------------------------------------- */
GetlineFromFileVar: procedure expose (expList) line rcfile


return
/* ----------------------------------------- */
NextFile: procedure




return
/* ----------------------------------------- */
ParseLine: procedure expose prop.
line = arg(1)

/* line -> prop. */

parse value line with '"PM_InstallObject"' '"' key '"' '"' val '"'
parse value key  with prop.Title ';' prop.Class ';' prop.Location ';',
                      prop.Opt

prop.Opt = strip(prop.Opt, 'T', ';')

if lastpos(';', val) \= length(val) then
  val = val';'

prop.Setup = '"'val'"'

i = 0
do while val \= ''
  parse value val with e ';' val
  i = i + 1
  prop.Setup.i = e
end
prop.Setup.0 = i


return
/* ----------------------------------------- */
StoreLine: procedure expose prop.

/* prop. -> line */

app = '"PM_InstallObject"'
key = '"' || prop.Title    || ';' || prop.Class ||,
      ';' || prop.Location || ';' || prop.Opt || '"'
val = prop.Setup

line = '  'app'    'key'   'val

return line
/* ----------------------------------------- */
break:

call lineout 'stderr', '[ Program halted on line: ]-> 'sigl

exit -255
/* ----------------------------------------- */
