/*
 *
 *  Converts a sorted .rc file into indented
 *  textfile (.lst), use rcsort to make strings
 *  in .rc file sorted.
 *  (c) valerius, 2006, Jun 20
 *  _valerius (dog) mail (dot) ru
 *
 */


parse arg args


call ParseCmdLine args

call InitRxDlls

/* defaults: */
InComment = 0
countCommented = 0;

/* commentary symbols */
BeginComment = '/*'
EndComment   = '*/'

CommentVars = 'InComment countCommented',
              'BeginComment EndComment'

expList = 'lines prevloc previd prevtype',
          'nestlevel pad spc cp hostcp location',
          'newque curfolder urls'

nestlevel = 0
pad = '    '
spc = ''
curfolder = ''

urls = 0

location = ''
prevloc = ''
previd = ''
prevtype = ''

newque = RxQueue('CREATE', 'rc2lst_que')

q = (rcfile = '')

if \q then q = (stream(rcfile, 'c', 'query exists') \= '')

if q then do

if rcfile \= '' then
  ret = stream(rcfile, 'c', 'open read')

call AddHeader


lines = 0
do while lines(rcfile)
  line = linein(rcfile)
  lines = lines + 1
  call processLine line
end


call CloseEndingFolder

call RxQueue 'DELETE', newque

if rcfile \= '' then
  ret = stream(rcfile, 'c', 'close')

end
else do
  call lineout 'stderr', 'file 'rcfile' doesn''t exist!'
  exit -255
end


exit 0
/* -------------==============---------------- */
ParseCmdLine: procedure expose rcfile
args = arg(1)

rcfile = args


return
/* -------------==============---------------- */
processLine: procedure expose (CommentVars),
                              (expList)
line = arg(1)


p1 = 1; p2 = 1;

do while p1 + p2 > 0

  /* Comment deleting */
  /* Comments can't be nested */

  p1 = pos(BeginComment, line);
  p2 = pos(EndComment, line);

  /* Deleting the first comment in a line */
  if (0 < p1) & (p1 < p2) then do
    line = delstr(line, p1, p2 - p1 + 2)
  end; else if (0 < p2) & ((p2 < p1) | (p1 == 0)) then do
    line = substr(line, p2 + 2);
    InComment = 0;
    countCommented = 0;
  end; else if p1 > 0 then do
    line = delstr(line, p1);
    InComment = 1
  end

  line = strip(line)

  /* Skipping the lines inside the comment */
  if InComment > 0 then countCommented = countCommented + 1;
  if countCommented > 2  then return;

  if p1 + p2 = 0 then do
    if line = '' then return
    if pos('"', line) == 0 then return
    parse var line '"' app '"' line
    select
      when app = 'PM_InstallObject'
        then call processInstallObj line

      otherwise
        nop
    end
    return
  end

end


return
/* -------------==============---------------- */
processInstallObj: procedure expose (expList)
line = arg(1)

parse var line '"' key '"' . '"' setup '"' .
parse var key name ';' class ';' location ';' opt
opt = strip(opt, 'T', ';')

str = setup
title = ''
do while str \= ''
  parse var str parm '=' val ';' str
  parm = translate(parm)
  val = strip(val, 'T', ';')
  if parm = 'TITLE' then do
    title = val
    leave
  end
end

str = setup
ObjId = ''
do while str \= ''
  parse var str parm '=' val ';' str
  parm = translate(parm)
  val = strip(val, 'T', ';')
  if parm = 'OBJECTID' then do
    ObjId = val
    leave
  end
end

if opt = 'DELETE'  |,
   opt = 'RELOCATE'
  then return

if title = '' then title = name

select
  when class = 'WPFolder'    |,
       class = 'XWPFolder'   |,
       class = 'MMFolder'    |,
       class = 'WPUrlFolder' |,
       class = 'WPDesktop'
  then do

    /*
    if title = 'Bookmarks' &,
       nestlevel = 1
      then
        return
     */

    if (prevloc  \= '' &,       /* !!! */
        previd   \= location &,
        location \= prevloc) |,
       (prevtype == 'folder' &,
        previd   \= location)
      then
        call CloseFolder

    t = '~'
    s = ''
    do length(title)
      s = s || t
    end

    say spc || title
    say spc || s
    say spc

    nestlevel = nestlevel + 1
    spc = spc || pad

    /* Save parent folder in stack */
    oldque = RxQueue('SET', newque)
    push location
    call RxQueue 'SET', oldque

    prevtype = 'folder'
    curfolder = ObjId
  end

  when class == 'WPUrl'
  then do
    str = setup
    do while str \= ''
      parse var str parm '=' val ';' str
      parm = translate(parm)
      if parm = 'URL' |,
         parm = 'LOCATOR'
      then do
        url = val
        leave
      end
    end

    urls = urls + 1

    if (prevloc  \= ''       &,
        previd   \= location &,
        location \= prevloc) |,
       (prevtype == 'folder' &,
        previd   \= location)
      then
        call CloseFolder

    say spc || title
    say spc || url
    say ''

    prevtype = 'url'
  end

  otherwise
    return
end

prevloc = location
previd = ObjId


return
/* -------------==============---------------- */
AddHeader: procedure

/*
say 'Bookmarks'
say '~~~~~~~~~'
say ''
 */

return
/* -------------==============---------------- */
CloseFolder: procedure expose spc location nestlevel,
                              newque

oldque = RxQueue('SET', newque)

do forever  /* !!! */

  if nestlevel < 0 then do
    call lineout 'stderr', 'Error: nestlevel='nestlevel' < 0!'
    exit -1
  end

  if queued() > 0  &,
     nestlevel > 1 &,
     location \= ''
    then do
      nestlevel = nestlevel - 1
      parse pull parentFld
      spc = delstr(spc, 1, 4)
      if parentFld = location
        then leave
    end
    else
      leave

end

call RxQueue 'SET', oldque


return
/* -------------==============---------------- */
CloseEndingFolder: procedure expose newque spc prevtype,
                                    nestlevel

oldque = RxQueue('SET', newque)

do queued()
  parse pull .
  spc = delstr(spc, 1, 4)
  nestlevel = nestlevel - 1
end

call RxQueue 'SET', oldque


return
/* -------------==============---------------- */
InitRxDlls:

  call RxFuncAdd 'SysLoadFuncs', 'rexxutil', 'SysLoadFuncs'
  call SysLoadFuncs


  call RxFuncAdd 'UniLoadFuncs', 'rexxuni', 'UniLoadFuncs'
  call UniLoadFuncs


return
/* -------------==============---------------- */
