/*
 *  Makes an unique Object Id for each object.
 *  Usage:
 *  cat file.rc | uniqid [-f] > newrc.rc
 *  (c) valerius, 2006, Jun 18.
 *  _valerius (dog) mail (dot) ru
 */

parse arg args

/* Do not make the new object ids for all objects */
/* -- only for those ones, having no object id.   */
/* If this parameter == 1, then new objects ids   */
/* are created for all objects                    */
args.force = 0

call ParseCmdLine args

/* Expose List */
expList = 'id ids. newids. opts. args. lines objs prefix.',
          'from to rus lat'

newids.0 = 0

/* Chars to translate into "_" */
from = '/\!@$#^*&?~|''":;,.()[]{} -'
to   = '___________________________'

/* Translation of russian chars into latin ones */
rus = '',
      '񦧨'
lat = 'ABVGDEEZZIJKLMNOPRSTUFXCCSSJY_EUA',
      'abvgdeezzijklmnoprstufxccssjy_eua'


/* defaults: */
InComment = 0
countCommented = 0;

/* commentary symbols */
BeginComment = '/*'
EndComment   = '*/'

CommentVars = 'InComment countCommented',
              'BeginComment EndComment'

/* Prefixes for object ids */

/* For Url */
prefix.url     = '<MY_URL_'
/* For Url Folder */
prefix.urlf    = '<MY_URLF_'
/* For other folders */
prefix.folder  = '<MY_FLD_'
/* For shadows */
prefix.shadow  = '<MY_SHADOW_'
/* For program object */
prefix.program = '<MY_PROG_'
/* Default prefix for new objects */
prefix.other   = '<MY_'

/* Lines counter */
lines = 0

/* The counter for 'PM_InstallObject' lines */
objs = 0

call GetRegisteredIds


q = (infile = '')

if \q then
  q = ( stream(infile, 'c', 'query exists') \= '' )

if q then do

  if infile \= '' then
    ret = stream(infile, 'c', 'open read')

  do while lines(infile)
    line = linein(infile)
    line = strip(line)
    lines = lines + 1
    call processLine line
  end

  if infile \= '' then
    ret = stream(infile, 'c', 'close')

end
else do
  call lineout 'stderr', 'Error: file doesn''t exist: '''infile'''!'
  exit -1
end


exit 0
/* ----------------==================------------------- */
ParseCmdLine: procedure expose infile args.
args = arg(1)

do while args \= ''

  opt = getarg()

  if pos('-', opt) = 1 then
  select
    when opt = '-h'
      then do
        call GiveHelp
        exit 0
      end

    when opt = '-f'
      then do
        args.force = 1
      end

    otherwise nop
  end
  else do
    args = opt args
    leave
  end

end

infile = args


return
/* ----------------==================------------------- */
getarg: procedure expose args

/* Gets one word, or a line, enclosed
   in quotes, from args               */

args = strip(args)

if pos('"', args) == 1 then
  parse value args with '"' opt '"' args
else
  parse var args opt args


return opt
/* ----------------==================------------------- */
processLine: procedure expose (CommentVars) (expList)
line = arg(1)


p1 = 1; p2 = 1;

do while p1 + p2 > 0

  /* Comment deleting */
  /* Comments can't be nested */

  p1 = pos(BeginComment, line);
  p2 = pos(EndComment, line);

  /* Deleting the first comment in a line */
  if (0 < p1) & (p1 < p2) then do
    line = delstr(line, p1, p2 - p1 + 2)
  end; else if (0 < p2) & ((p2 < p1) | (p1 == 0)) then do
    line = substr(line, p2 + 2);
    InComment = 0;
    countCommented = 0;
  end; else if p1 > 0 then do
    line = delstr(line, p1);
    InComment = 1
  end

  line = strip(line)

  /* Skipping the lines inside the comment */
  if InComment > 0 then countCommented = countCommented + 1;
  if countCommented > 2  then return;

  if p1 + p2 = 0 then do
    if line = '' then return
    if pos('"', line) == 0 then return

    /*
    parse var line '"' app '"' . '"' key '"' . '"' val '"' .
     */

    call splitLine line

    opts.val = strip(opts.val, 'T', ';')

    select

      when opts.app = 'PM_InstallObject'
        then do

          line = processInstallObj(line)
          if pos(' ', line) \= 1 then line = '  'line

        end

      otherwise
        nop
    end

    say line
    return

  end

end


return
/* ----------------==================------------------- */
processInstallObj: procedure expose (expList) opts.key opts.val
line = arg(1)

/* Process each object's line */

objs = objs + 1
parse var opts.key opts.name ';' opts.class ';' opts.location ';' opts.opt
opts.opt = strip(opts.opt, 'T', ';')
opts.setup = opts.val

str = opts.setup
opts.ObjId = ''
do while str \= ''
  parse var str parm '=' val ';' str
  parm = translate(parm)
  if parm = 'OBJECTID' then do
    opts.ObjId = val
    leave
  end
end

str = opts.setup
opts.title = ''
do while str \= ''
  parse var str parm '=' val ';' str
  parm = translate(parm)
  if parm = 'TITLE' then do
    opts.title = val
    leave
  end
end

if opts.ObjId = ''  |,
   args.force       then do

  line = MakeUniqId(line)

  newids.objs = opts.ObjId
  newids.0 = objs
  newids.objs.new = id

  /* Add the new id to the list */
  i = ids.0 + 1
  ids.i = id
  ids.0 = i

end


return line
/* ----------------==================------------------- */
InitRxDlls:

call RxFuncAdd 'SysLoadFuncs', 'rexxutil', 'SysLoadFuncs'
call SysLoadFuncs

call RxFuncAdd "WPToolsLoadFuncs", "wptools", "WPToolsLoadFuncs"
call WPToolsLoadFuncs



return
/* ----------------==================------------------- */
GetRegisteredIds: procedure expose ids.

call SysIni 'USER', 'PM_Workplace:Location', 'ALL:', 'ids.'


return
/* ----------------==================------------------- */
MakeUniqId: procedure expose (expList)
line = arg(1)

if opts.class = 'WPDesktop' then do
  id = opts.ObjId
  return line
end

select

  when opts.class = 'WPUrlFolder'
    then do
      prefix = prefix.urlf
    end

  when opts.class = 'WPFolder'  |,
       opts.class = 'MMFolder'  |,
       opts.class = 'XWPFolder' |,
       opts.class = 'WPDesktop'
    then do
      prefix = prefix.folder
    end

  when opts.class = 'WPUrl'
    then do
      prefix = prefix.url
    end

  when opts.class = 'WPProgram'
    then do
      prefix = prefix.program
    end

  when opts.class = 'WPShadow'
    then do
      prefix = prefix.shadow
    end

  otherwise do
      prefix = prefix.other
    end

end

newtitle = opts.title
if newtitle = '' then
   newtitle = opts.name

n = words(newtitle)
if n > 3 then n = 3

newtit = word(newtitle, 1) || word(newtitle, 2) ||,
         word(newtitle, 3)

newtitle = newtit

newtitle = translate(newtitle, to, from)

newtitle = translate(newtitle, lat, rus)

newtitle = delstr(newtitle, 26)

newtitle = strip(newtitle, 'T', '-')
newtitle = strip(newtitle, 'T', '_')

/*
newtitle = translate(newtitle)
 */

suff = ''
id = ''
f = 1
cnt = 0

do forever
  if f then do
    if cnt > 1 then suff = '_'cnt
    id = prefix || newtitle || suff || '>'
    cnt = cnt + 1
    f = 0
  end
  else
    leave
  do i = 1 to ids.0
    if id = ids.i then do
      f = 1
      leave
    end
  end
end

/* Change OBJECTID */
parse var opts.setup first 'OBJECTID=' . ';' last
if substr(first, length(first), 1) \= ';' then
  first = first';'
opts.setup = '  'first || 'OBJECTID='id';' || last

/* Change SHADOWID */
if pos('SHADOWID=', opts.setup) > 0 then do
  parse var opts.setup first 'SHADOWID=' shadowid ';' last
  do i = 1 to newids.0
    if shadowid = newids.i & newids.i.new \= 'NEWIDS.'i'.NEW'
      then do
        shadowid = newids.i.new
        leave
      end
  end
  opts.setup = '  'first'SHADOWID='shadowid';'last
end

/* Change location */
do i = 1 to newids.0
  if opts.location = newids.i & newids.i.new \= 'NEWIDS.'i'.NEW'
    then do
      opts.location = newids.i.new
      leave
    end
end

/* Change name */
parse var opts.setup first 'TITLE=' tit ';' last
if tit = '' then
  tit = opts.name

i = 0
name1 = opts.name

first = strip(first, 'T', ';')
first = first';'

opts.name = name1
opts.setup = '  'first'TITLE='tit';'last


line = RcOut()


return line
/* ----------------==================------------------- */
RcOut: procedure expose (expList)

opts.app = '"PM_InstallObject"'
opts.key = '"' || opts.name    || ';' || opts.class ||,
      ';' || opts.location || ';' || opts.opt || '"'

opts.setup = strip(opts.setup)
opts.setup = strip(opts.setup, 'L', ';')

opts.val = '"'opts.setup'"'

line = '  'opts.app'    'opts.key'   'opts.val


return line
/* ----------------==================------------------- */
splitLine: procedure expose opts.
line = arg(1)

drop opts.
line = strip(line)
q = 0

opts.app = quotedText()
opts.key = quotedText()
opts.val = quotedText()
opts.comment = commentedText()


return
/* ----------------==================------------------- */
quotedText: procedure expose line q

p = pos('"', line, q + 1)

if p > 0 then do

  t = p
  do forever
    q = pos('"', line, p + 1)
    if q > 1
      then do
        if substr(line, q - 1, 1) \= '^'
          then
            leave
          else
            p = q
      end
  end

  s = substr(line, t + 1, q - t - 1)

end
else
  parse var line s line


return s
/* ----------------==================------------------- */
commentedText: procedure expose line q

p = pos('/*', line, q + 1)
if p > 0 then do

  q = pos('*/', line, p + 1)
  s = substr(line, p + 2, q - p - 3)

end
else
  parse var line '/*' s '*/' line

  s = strip(s)
  line = strip(line)


return s
/* ----------------==================------------------- */
GiveHelp:

call lineout 'stderr', ''
call lineout 'stderr', 'Unique object id maker,'
call lineout 'stderr', ''
call lineout 'stderr', 'Syntax:'
call lineout 'stderr', ''
call lineout 'stderr', 'uniqid [-h | -f] [file.rc]'
call lineout 'stderr', 'where'
call lineout 'stderr', ' ''-h'' means "give Help" (this help screen)'
call lineout 'stderr', ' ''-f'' means "Force" (force new unique object'
call lineout 'stderr', 'id for all objects (by default -- only if an'
call lineout 'stderr', 'object has no object id.)).'
call lineout 'stderr', ''


return
/* ----------------==================------------------- */
