/* */
/*============================================================================+
|    This .CMD calls Theseus1.dll for RT2GetLInMemMap.                        |
+============================================================================*/
trace o

secs        = 5;
iterations  = 1;
found       = false;
pid_num     = false;

/*==================================================================+
|   Parse the input arguements to upper case.                       |
+==================================================================*/
PARSE UPPER ARG p_iterations p_secs

/*==================================================================+
|   Check to see if any operand have been passed. If Not exit.      |
+==================================================================*/
IF p_iterations = '?' | p_iterations = "HELP" THEN
DO
   SAY 'CMD file GETMEMMP does not need any input operands.'
   SAY ''
   SAY '   Optional operands are multiple re-iterations of output.'
   SAY '  GETMEMCP [num_iterations] [num_secs]'
   SAY ''
   SAY '   Where:'
   SAY '     num_iterations - is the number of data collections for this run.'
   SAY '                      DEFAULT is 1 iteration.'
   SAY '     num_secs       - is the number of seconds between interations.'
   SAY '                      DEFAULT is 5 seconds.'
   EXIT 999
END

/*==================================================================+
|   Check operand to see if any have been defaulted.                |
+==================================================================*/
IF p_secs \= '' THEN secs = STRIP(p_secs);
IF p_iterations \= '' THEN iterations = p_iterations

/*==================================================================+
|   The following loads the necessary REXX functions and Theseus2   |
| functions.                                                        |
+==================================================================*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call RxFuncAdd 'RT2LoadFuncs1', 'THESEUS1', 'RT2LoadFuncs1'
rc = RT2LoadFuncs1()
IF rc \= 0 THEN Say 'RT2loadfuncs1 rc is = 'rc

/*==================================================================+
|   After all parms have been checked and a pid found then loop     |
| for the number of iterations for the duration of seconds between  |
| iterations.                                                       |
+==================================================================*/
DO
   DO i = 1 TO iterations BY 1
      rc = RT2GetLinMemMap( )
      if rc = 0 THEN
      DO
         SAY 'Data collected for Linear memory map at 'time()', on 'date(Language)'.'
         SAY ''
         SAY ''
         call SysSleep secs
      END
      ELSE
      DO
         SAY 'Return code 'rc 'from RT2GetLinMemMap.'
         EXIT
      END
   END
END
SAY 'GETMEMMP has terminated.  The time is 'time()', the date is 'date(Language)'.'
EXIT
