/* REXX program to modify TShell */

if 'PGMSHELL' <> address() then do
  say 'Expected PGMSHELL environment.'
  say 'Usage:  PGMSHELL <cmd filename>'
  return 2
end

/* TShell does not spool, so reduce parallel port timeout
   from 120 to 5 seconds in case you accidentally hit print-screen
   and there is no printer hooked up. */
rc = SetParallelTimeout( "LPT1", 5 )

/* title text for the start list  */
rc = SetStartTitle( "Start Group" )

/* title text for the running list  */
rc = SetRunningTitle( "Running Group" )

/* Add OS2 program; arguments: title, startup dir, parameters, exe */
/* I omit the title of CMD.EXE session, then CMD.EXE will dynamically */
/* update the title based on the currently-running program. */
rc = AddOS2Program('Command prompt (cmd)',,,'cmd.exe')
rc = AddOS2Program('Command prompt (4os2)',,,'4os2.exe')
/* Add OS2 program; arguments: title, startup dir, parameters, exe */
rc = AddOS2Program('Format floppy',,'a:','format.com')
/* DFSee */
rc = AddOS2Program('DFSee 9.15', '!:\tools\dfree915',, 'dfsos2.exe')
/* FC/2 */
rc = AddOS2Program('File Commander/2', '!:\tools\fc2',, 'fc.exe')
/* DN/2 */
rc = AddOS2Program('DosNavigator/2', '!:\tools\dn',, 'dn.exe')
/* MiniTerm */
rc = AddOS2Program('MiniTerm', '!:\tools\miniterm',, 'term.exe')
/* pci.exe */
rc = AddOS2Program('pci sniffer', '!:\tools\pci',, 'pci.exe')

/* is configured for DOS? */
if QueryDOSCapable() then do
   /* Add DOS program;
      arguments: title, startup dir, parameters, settings stem */

   drop settings
   settings.0 = "DPMI_DOS_API=ENABLED"
   settings.1 = "DPMI_MEMORY_LIMIT=8"
   rc = AddDOSProgram('DOS DPMI',,, 'settings')
   rc = AddDOSProgram('Volkov Comander', '!:\tools\vc', '/C vc.com', 'settings' )
   rc = AddDOSProgram('AXE', '!:\tools\vc', '/C axe.com', 'settings' )
   rc = AddDOSProgram('FreeGEM', '!:\', '/C gem.bat', 'settings' )

   drop settings
   settings.0 = "KBD_ALTHOME_BYPASS=1"
   settings.1 = "KBD_CTRL_BYPASS=CTRL_ESC"
   settings.2 = "VIDEO_SWITCH_NOTIFICATION=1"
   settings.3 = "SET VIDEO_8514A_XGA_IOTRAP=0"
   settings.4 = "DPMI_MEMORY_LIMIT=64"
   settings.5 = "WIN_DDE=0"
   settings.6 = "WIN_CLIPBOARD=1"
   rc = AddDOSProgram('WinOS/2 fullscreen', '!:\os2\mdos\winos2', '/C progman.exe', 'settings' )
end

/* add shutdown option. arguments: title, completion msg */
rc = AddShutdown( "Shutdown", "Shutdown Complete" )

/* make text white on blue; 0=black; 1=blue; 2=green; 3=cyan; 4=red;
   5=pink; 6=orange; 7=white */
rc = SetForegroundColor( 2 )
rc = SetBackgroundColor( 0 )

return 0

