/*REXX*/

/* Load the Tvfs REXX interface. */
rc = RxFuncAdd('TvLoadFuncs', 'TVRX', 'TvLoadFuncs');
if (rc <> 0) then call shutdown;
rc = TvLoadFuncs();
if (rc <> 0) then call shutdown;

/* Restore the Tvfs drives. */
rc = TvUmount("*");

rc = TvMount("-c0 #:");
if (rc <> 0) then call shutdown;

rc = TvMkdir("#:\tmp");
if (rc <> 0) then call shutdown;

rc = TvLink("-drwnt #:\os2 @:\os2");
if (rc <> 0) then call shutdown;

rc = TvLink("-drwnt #:\os2 !:\os2");
if (rc <> 0) then call shutdown;

rc = TvLink("-drwnt #:\mmos2 @:\mmos2");
if (rc <> 0) then call shutdown;

rc = TvLink("-drwnt #:\mmos2 !:\mmos2");
if (rc <> 0) then call shutdown;

rc = TvLink("-drwnt #:\tools @:\tools");
if (rc <> 0) then call shutdown;

rc = TvLink("-drwnt #:\tools !:\tools");
if (rc <> 0) then call shutdown;

rc = TvLink("-drwnt #:\apps @:\apps");
if (rc <> 0) then call shutdown;

rc = TvLink("-drwnt #:\apps !:\apps");
if (rc <> 0) then call shutdown;

/*
rc = TvLink("-frb #:\tmp\user.dat @:\os2\system\user.dat");
if (rc <> 0) then call shutdown;
*/

/* Unload the Tvfs REXX interface. */
rc = TvDropFuncs();
exit(0);

shutdown:
SAY "Error restoring TVFS drive."
call TvUmount("*");
call TvDropFuncs;
exit(16)
