/* rexx */

/*
 *
 *   A REXX wrapper for unpack.exe
 *   This script unpacks OS/2 bundles by list or/and
 *   by wildcard, restoring internal directory structure
 *   (c) valerius, _valerius (at) mail (dot) ru, Jun 2005
 *
 */


'@echo off'

parse arg args

if RxFuncQuery('SysLoadFuncs') then do
  call RxFuncAdd 'SysLosdFuncs', 'rexxutil', 'SysLoadFuncs'
  call SysLoadFuncs
end

base = '.'

call ParseCmdLine

if bundles.0 \= '' & bundles.0 > 0 then do
  do i = 1 to bundles.0
    say 'Unpacking 'bundles.i'...'
    call UnpackBundle bundles.i
  end
end


exit 0
/* -----======================----- */
UnpackBundle:
parse arg bundle

'if not exist 'base' mkdir 'base

call cleanque
'unpack 'bundle' /show | rxqueue'

if queued() > 0 then pull .

do while queued() > 0
  parse pull item
  say item
  parse value item with '->\' path
  if lastpos('\', path) \= 0 then
    basepath = base'\'delstr(path, lastpos('\', path))
  else
    basepath = '\'
  p = pos('\', path)
  curdir = base'\'
  do while p > 0
    parse value path with dir '\' path
    curdir = curdir || dir'\'
    'if not exist 'curdir' mkdir 'curdir
    p = pos('\', path)
  end

  file = path
  'unpack 'bundle' 'basepath' /n:'file' 2>\dev\nul >\dev\nul'
end

return
/* -----======================----- */
ParseCmdLine:

bundles.0 = 0

do while words(args) > 0
  parse var args param args
  if param == '-h'
  then do
    call GiveHelp
    exit 0
  end
  else
  if param == '-d'
  then parse var args base args
  else do
  if pos('@', param) == 1 then do
      param = substr(param, 2)
      call AddBundleList param
    end
    else do
      call ExpandWildcard param
    end
  end
end

return
/* -----======================----- */
AddBundleList:
parse arg list

i = bundles.0
rc = stream(list, 'c', 'open read')
do while lines(list) > 0
  i = i + 1
  line = linein(list)
  line = strip(line)
  if line \= ''
    then bundles.i = line
    else do
      i = i - 1
      iterate
    end
end
bundles.0 = i
rc = stream(list, 'c', 'close')

return
/* -----======================----- */
ExpandWildcard:
parse arg wildcard

call SysFileTree wildcard, stem, 'FSO'
if stem.0 = 0 then do
  bundles.0 = 0
  return
end
k = bundles.0
do i = 1 to stem.0
  l = k + i
  bundles.l = stem.i
end
bundles.0 = l

drop stem.

return
/* -----======================----- */
cleanque:

do while queued() > 0
  pull .
end

return
/* -----======================----- */
GiveHelp:

parse source . . name
name = substr(name, lastpos('\', name) + 1)

say 'Bundle unpacker, (c) valerius, 2005'
say ''
say 'Syntax:'
say ''
say ''
say name' -h'
say name' [-d basedir] wildcard1 [wildcard2 ... [ wildcardN]] [@filelist]'
say 'where:'
say '-h: give help (this screen)'
say '-d basedir: -- set base dir for unpacking'
say '@list: -- filelist (a text file)'
say ''

return
/* -----======================----- */
