/*  Patch os2chess.ini
 *  for a drive letter
 */

sysdrv  = value('SYSDRV',, 'OS2ENVIRONMENT')
bootdrv = value('BOOTDRV',, 'OS2ENVIRONMENT')
ini     = bootdrv || '\os2\apps\os2chess.ini'
/* sounds array base */
base    = x2d('2d4')
/* array entry size  */
fnsize  = x2d('104')
/* number of entries */
numfn   = 6
/* get ini file size */
size = stream(ini, 'c', 'query size')

/* read ini            */
call stream ini,  'c',  'open read'
buf  = charin(ini,  1,  size)
call stream ini,  'c',  'close'

do n = 1 to numfn
  /* offset into buf      */
  off = base + (n - 1) * fnsize
  /* put sysdrv over 'D:' */
  buf = overlay(sysdrv, buf, off)
end

/* write ini back */
call charout ini, buf, 1

exit
