/* REXX OS2CDROM.DVD installation script
 * Copyright (C) 2009 Dmitry A.Steklenev
 */

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

parse arg boot_disk install_path

if boot_disk == "" | install_path == "" then do
   return 1
end

boot_disk   = translate( boot_disk )
config      = boot_disk"CONFIG.SYS"
boot        = boot_disk"OS2\BOOT"
save_needed = 0
must_be_add = 1

if stream( boot"\OS2CDROM.ECS", "C", "QUERY EXIST" ) == "" then do
  if stream( boot"\OS2CDROM.DMD", "C", "QUERY EXIST" ) \= "" then do
    "@ren "boot"\OS2CDROM.DMD *.ECS"
    if rc \= 0 then do
       return 1
    end
  end
end

"@copy" install_path"\OS2CDROM.DMD" boot
if rc \= 0 then do
   return 1
end

do i = 1 while lines( config )

  cfg.i = linein( config )
  parse value translate( cfg.i ) with command "=" devpath

  if command == "DEVICE" & ( lastpos( "OS2CDROM.DMD" , devpath ) \= 0 ) then do
     if left( translate( cfg.i ), 31 ) \= "DEVICE="boot"\OS2CDROM.DMD" &,
        left( translate( cfg.i ), 19 ) \= "DEVICE=OS2CDROM.DMD" then
     do
        cfg.i = "DEVICE="boot"\OS2CDROM.DMD"
        save_needed = 1
     end
     must_be_add = 0
  end
end

if must_be_add then do
   cfg.i = "DEVICE="boot"\OS2CDROM.DMD"
   save_needed = 1
   i = i + 1
end

cfg.0 = i - 1
rc = stream( config, "c", "close" )

if save_needed then do

   "@copy "config SysTempFileName( boot_disk"CONFIG.???" )
   if rc \= 0 then do
      return 1
   end

   "@del "config
   if rc \= 0 then do
      return 1
   end

   do i = 1 to cfg.0
      rc = lineout( config, cfg.i )
   end
   rc = stream( config, "c", "close" )
end

return 0
