/*
 *  Converts Links browser bookmarks file to
 *  .rc profile with URL objects.
 *  (c) valerius, 2006, Jun 26
 *  _valerius (dog) mail (dot) ru
 */


parse arg args


call ParseCmdLine args


q = (infile = '')

if \q then q = (stream(infile, 'c', 'query exists') \= '')

if q then do

if infile \= '' then
  ret = stream(infile, 'c', 'open read')

call OutFolder

lines = 0
do while lines(infile)
  line = linein(infile)
  lines = lines + 1
  call processLine line
end

if infile \= '' then
  ret = stream(infile, 'c', 'close')

end
else do
  call lineout 'stderr', 'file 'infile' doesn''t exist!'
  exit -255
end


exit 0
/* -------------------===================--------------------- */
ParseCmdLine: procedure expose infile
args = arg(1)

infile = args


return
/* -------------------===================--------------------- */
OutFolder:

opts.name  = 'test'
opts.class = 'WPUrlFolder'
opts.location = '<WP_DESKTOP>'
opts.opt = 'UPDATE'

opts.setup = 'TITLE=Test folder;SHOWALLINTREEVIEW=YES;OBJECTID=<MY_URLF_TEST_1234>;'

call RcOut


return
/* -------------------===================--------------------- */
processLine: procedure
line = arg(1)

p = lastpos('|', line)
title = delstr(line, p)
url   = substr(line, p + 1)

opts.name  = delstr(title, 30)
opts.class = 'WPUrl'
opts.location = '<MY_URLF_TEST_1234>'
opts.opt = 'UPDATE'
opts.setup = 'URL='url';TITLE='title';'

call RcOut


return
/* -------------------===================--------------------- */
RcOut: procedure expose opts.

app = '"PM_InstallObject"'
key = '"' || opts.name    || ';' || opts.class ||,
      ';' || opts.location || ';' || opts.opt || '"'

opts.setup = strip(opts.setup)
opts.setup = strip(opts.setup, 'L', ';')

val = '"'opts.setup'"'

line = '  'app'    'key'   'val

say line


return
/* -------------------===================--------------------- */
