/*
 *  Convert a .rc profile with settings
 *  of URL objects to bookmarks file of Links browser
 *  (c) valerius, 2006
 *  BSD license
 */

parse arg args

call InitRxDlls

call ParseCmdLine args

/* defaults: */
InComment = 0
countCommented = 0;

/* commentary symbols */
BeginComment = '/*'
EndComment   = '*/'

CommentVars = 'InComment countCommented',
              'BeginComment EndComment'

objs = 0
urls = 0


q = (rcfile = '')

if \q then q = (stream(rcfile, 'c', 'query exists') \= '')

if q then do

if rcfile \= '' then
  ret = stream(rcfile, 'c', 'open read')


lines = 0
do while lines(rcfile)
  line = linein(rcfile)
  lines = lines + 1
  call processLine line
end

if rcfile \= '' then
  ret = stream(rcfile, 'c', 'close')

end
else do
  call lineout 'stderr', 'file 'rcfile' doesn''t exist!'
  exit -255
end


exit 0
/* -------------==============---------------- */
ParseCmdLine: procedure expose rcfile
args = arg(1)

rcfile = args


return
/* -------------==============---------------- */
processLine: procedure expose (CommentVars),
                              lines urls
line = arg(1)


p1 = 1; p2 = 1;

do while p1 + p2 > 0

  /* Comment deleting */
  /* Comments can't be nested */

  p1 = pos(BeginComment, line);
  p2 = pos(EndComment, line);

  /* Deleting the first comment in a line */
  if (0 < p1) & (p1 < p2) then do
    line = delstr(line, p1, p2 - p1 + 2)
  end; else if (0 < p2) & ((p2 < p1) | (p1 == 0)) then do
    line = substr(line, p2 + 2);
    InComment = 0;
    countCommented = 0;
  end; else if p1 > 0 then do
    line = delstr(line, p1);
    InComment = 1
  end

  line = strip(line)

  /* Skipping the lines inside the comment */
  if InComment > 0 then countCommented = countCommented + 1;
  if countCommented > 2  then return;

  if p1 + p2 = 0 then do
    if line = '' then return
    if pos('"', line) == 0 then return
    parse var line '"' app '"' line
    select
      when app = 'PM_InstallObject'
        then call processInstallObj line

      otherwise
        nop
    end
    return
  end

end


return
/* -------------==============---------------- */
processInstallObj: procedure expose lines urls
line = arg(1)

parse var line '"' key '"' . '"' setup '"' .
parse var key name ';' class ';' location ';' opt
opt = strip(opt, 'T', ';')

str = setup
title = ''
do while str \= ''
  parse var str parm '=' val ';' str
  parm = translate(parm)
  val = strip(val, 'T', ';')
  if parm = 'TITLE' then do
    title = val
    leave
  end
end

if opt = 'DELETE'  |,
   opt = 'RELOCATE'
  then return

if title = '' then title = name

select
  when class = 'WPFolder'    |,
       class = 'XWPFolder'   |,
       class = 'MMFolder'    |,
       class = 'WPUrlFolder' |,
       class = 'WPDesktop'
  then nop 

  when class == 'WPUrl'
  then do
    str = setup
    do while str \= ''
      parse var str parm '=' val ';' str
      parm = translate(parm)
      if parm = 'URL' |,
         parm = 'LOCATOR'
      then do
        url = val
        leave
      end
    end

    urls = urls + 1
    
    say title'|'url

  end

  otherwise nop

end


return
/* -------------==============---------------- */
InitRxDlls:

  call RxFuncAdd 'SysLoadFuncs', 'rexxutil', 'SysLoadFuncs'
  call SysLoadFuncs



return
/* -------------==============---------------- */
