/*
 *
 *  Sorts an arbitrary set of lines in .rc file,
 *  so, the sorted lines go "from roots to leaves"
 *  and one tree goes after the previous.
 *  (c) valerius, 2006, Jun 6
 *  mailto: _valerius (angry dog) mail (dot) ru
 *  BSD license ;-)
 *
 */


parse arg args

call ParseCmdLine args

/* defaults: */
InComment = 0
countCommented = 0;

/* commentary symbols */
BeginComment = '/*'
EndComment   = '*/'

CommentVars = 'InComment countCommented',
              'BeginComment EndComment'

q = (infile = '')

if \q then
  q = ( stream(infile, 'c', 'query exists') \= '' )

if q then do

  newque = RxQueue('CREATE')

  if infile \= '' then
    ret = stream(infile, 'c', 'open read')

  /* Lines counter */
  lines = 0

  /* the number of 'PM_InstallOnject' lines */
  objs = 0

  do while lines(infile)
    line = linein(infile)
    line = strip(line)
    lines = lines + 1
    call processLine line
  end
  lines.0 = objs

  call SortLines

  if infile \= '' then
    ret = stream(infile, 'c', 'close')

  call RxQueue 'DELETE', newque

end
else do
  call lineout 'stderr', 'Error: file doesn''t exist: '''infile'''!'
  exit -1
end


exit 0
/* ----------------==================------------------- */
ParseCmdLine: procedure expose infile
args = arg(1)

infile = args


return
/* ----------------==================------------------- */
processLine: procedure expose (CommentVars) lines lines.,
                                            objs newque
line = arg(1)


p1 = 1; p2 = 1;

do while p1 + p2 > 0

  /* Comment deleting */
  /* Comments can't be nested */

  p1 = pos(BeginComment, line);
  p2 = pos(EndComment, line);

  /* Deleting the first comment in a line */
  if (0 < p1) & (p1 < p2) then do
    line = delstr(line, p1, p2 - p1 + 2)
  end; else if (0 < p2) & ((p2 < p1) | (p1 == 0)) then do
    line = substr(line, p2 + 2);
    InComment = 0;
    countCommented = 0;
  end; else if p1 > 0 then do
    line = delstr(line, p1);
    InComment = 1
  end

  line = strip(line)

  /* Skipping the lines inside the comment */
  if InComment > 0 then countCommented = countCommented + 1;
  if countCommented > 2  then return;

  if p1 + p2 = 0 then do
    if line = '' then return
    if pos('"', line) == 0 then return
    parse var line '"' app '"' . '"' key '"' . '"' val '"' .

    val = strip(val, 'T', ';')
    
    select

      when app = 'PM_InstallObject'
        then do
          objs = objs + 1
          lines.objs = line
          parse var key name ';' class ';' location ';' opt
          opt = strip(opt, 'T', ';')
          setup = val

          str = setup
          do while str \= ''
            parse var str parm '=' val ';' str
            parm = translate(parm)
            if parm = 'OBJECTID' then do
              ObjId = val
              leave
            end
          end

          str = setup
          do while str \= ''
            parse var str parm '=' val ';' str
            parm = translate(parm)
            if parm = 'TITLE' then do
              name = val
              leave
            end
          end

          addr = ''
          if class = 'WPUrl' then do
            str = setup
            do while str \= ''
              parse var str parm '=' val ';' str
              parm = translate(parm)
              if parm = 'URL'     |,
                 parm = 'LOCATOR' then do
                addr = val
                leave
              end
            end
          end

          kind = ''
          if class = 'WPFolder'    |,
             class = 'XWPFolder'   |,
             class = 'MMFolder'    |,
             class = 'WPUrlFolder' |,
             class = 'WPDesktop'
            then
              kind = 'folder'

          lines.objs.id    = ObjId
          lines.objs.loc   = location
          lines.objs.title = name
          lines.objs.url   = addr
          lines.objs.type  = kind

        end

      otherwise
        nop
    end
    return
  end

end


return
/* ----------------==================------------------- */
SortLines: procedure expose lines. newque

/* Sort lines so one tree follows another
   and a tree is followed from roots to
   branches                             */

oldque = RxQueue('SET', newque)

trees = 0
do forever

  /* Process one tree */

  if GetRoot() then do

    /* Now we will find leaves and branches */

    trees = trees + 1

    say ''
    say '/* Tree #'trees' */'
    say ''

    say str

    exitflag = 1
    do while (queued() > 0) | exitflag

      branches = 0
      do i = 1 to lines.0
        if lines.i = 'LINES.'i
          then iterate
        if lines.i.loc = str.id then do
          if lines.i.type \= 'folder'
            then do
              say lines.i
              drop lines.i.
              drop lines.i
            end
            else do
              push str.id
              call GetLine i
              say str
              drop lines.i.
              drop lines.i
              branches = 1
              leave
            end
        end
      end

      if \branches & queued() > 0 then do
        parse pull str.id
        iterate
      end

      if branches then iterate

      /* Exit from the root condition:
         no branches and no elements in queue */
      exitflag = 0

    end

  end
  else
    leave

end

call RxQueue 'SET', oldque


return
/* ----------------==================------------------- */
GetFirstLine: procedure expose lines. str. str

/* Get the first non-dropped line */
/* Returns 1 if this line exists,
   0 otherwise                    */

flag = 0
do i = 1 to lines.0
  if lines.i \= 'LINES.'i then do
    flag = 1
    call GetLine i
    leave
  end
end


return flag
/* ----------------==================------------------- */
GetLine: procedure expose lines. str. str
i = arg(1)

/* Gets i'th line from lines.,
   assigns its value to str and str. */

str       = lines.i
str.id    = lines.i.id
str.loc   = lines.i.loc
str.title = lines.i.title
str.url   = lines.i.url
str.num   = i


return
/* ----------------==================------------------- */
GetRoot: procedure expose lines. str. str

/* Gets root of the next tree */
/* On success returns 1,
   0 otherwise           */

if GetFirstLine() then do

  j = str.num

  do forever

    flag = 0
    do i = 1 to lines.0
      if lines.i = 'LINES.'i then iterate
      /* If current element is the parent for str */
      if lines.i.id = str.loc then do
        flag = 1
        leave
      end
    end

    if flag then do
      call GetLine i
      j = i
    end
    else
      leave

  end

  /* Now str and str. hold a root element */
  drop lines.j.
  drop lines.j
  return 1
end

return 0
/* ----------------==================------------------- */
