/****************************************************************************
*                         SciTech Display Doctor
*               Copyright (C) 1991-2001 SciTech Software, Inc.
*                            All rights reserved.
*
* Description:  This REXX script allows you to replace the Screen pages in
*               the System object with the SDD version, or vice versa.
*
*               Use the parameter 'R' to remove, default is to install
*
****************************************************************************/

/******************************************
* language-specific strings defined here
*******************************************/

  MRI_RESTORE_PAGE              = "⠭ ன ࠭"
  MRI_REPLACE_PAGE              = " ࠭"
  MRI_REGISTERED_CLASS          = "ॣ஢  "
  MRI_REMOVE_OLD_CLASS          = " ॣ ண "
  MRI_INSTALLED_CLASS           = "⠭  ࠭ ࠭"
  MRI_NOPMI_WARNING             = "।०! SDDPMI.CFG  ,  ࠧ⪨  㤥 "
  MRI_CLASSREP_FAIL             = "訡 饭 !"
  MRI_REGISTER_FAIL             = "訡 ॣ樨 !"
  MRI_MUST_REBOOT               = "   ᨫ ᫥ १㧪"

/******************************************/

if RxFuncQuery('SysLoadFuncs') then do
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
  call SysLoadFuncs
end

if RxFuncQuery('rxRepClass') then do
  call RxFuncAdd 'rxRepClass','RXREPCLS','rxRepClass'
end

parse upper arg args
parse upper value VALUE( "PATH",, "OS2ENVIRONMENT" ) with "\OS2\SYSTEM" -2 boot_drive +2
parse source dir;
parse var dir x1 x2 dir;
dir = filespec("D", dir)||filespec("P", dir);
if (right(dir, 1) = "\") then dir = left(dir, length(dir)-1);
"@echo off"
say

if (args == "R") then do
    say MRI_RESTORE_PAGE
    "if exist" boot_drive||"\OS2\SDDCFG.SAV ren" boot_drive||"\OS2\SDDCFG.SAV SDDPMI.CFG"
    "if not exist" boot_drive||"\OS2\SDDPMI.CFG echo "||MRI_NOPMI_WARNING
    if (rxRepClass("WPSystem", "WPVideoSystem", 0) = 0) then Say MRI_CLASSREP_FAIL;
    else if (SysDeRegisterObjectClass("WPVideoSystem")) then Say MRI_REMOVE_OLD_CLASS;
    say
    say MRI_MUST_REBOOT
end
else do
    say MRI_REPLACE_PAGE
    "if exist" boot_drive||"\OS2\SDDPMI.CFG ren" boot_drive||"\OS2\SDDPMI.CFG SDDCFG.SAV 2> nul"
    "if exist" boot_drive||"\OS2\SDDPMI.CFG del" boot_drive||"\OS2\SDDPMI.CFG"
    pszDLLFile = boot_drive||"\OS2\DLL\SDDVCFG.DLL"
    if (SysDeRegisterObjectClass("WPVideoSystem")) then Say MRI_REMOVE_OLD_CLASS;
    if (SysRegisterObjectClass("WPVideoSystem", pszDLLFile)) then Say MRI_REGISTERED_CLASS; else Say MRI_REGISTER_FAIL;
    if (rxRepClass("WPSystem", "WPVideoSystem", 1) = 0) then Say MRI_CLASSREP_FAIL; else Say MRI_INSTALLED_CLASS;
    say
    say MRI_MUST_REBOOT
end;
