/* REXX program to modify TShell */

network = value('NETWORK',, 'OS2ENVIRONMENT')

if 'PGMSHELL' <> address() then do
  say 'Expected PGMSHELL environment.'
  say 'Usage:  PGMSHELL <cmd filename>'
  return 2
end

/* TShell does not spool, so reduce parallel port timeout
   from 120 to 5 seconds in case you accidentally hit print-screen
   and there is no printer hooked up. */
rc = SetParallelTimeout( "LPT1", 5 )

/* title text for the start list  */
rc = SetStartTitle( "Start Group" )

/* title text for the running list  */
rc = SetRunningTitle( "Running Group" )

/* Add OS2 program; arguments: title, startup dir, parameters, exe */
/* I omit the title of CMD.EXE session, then CMD.EXE will dynamically */
/* update the title based on the currently-running program. */
rc = AddOS2Program('Command prompt (cmd)',,,'cmd.exe')
rc = AddOS2Program('Command prompt (4os2)',,,'4os2.exe')

if network \= 'none' then do
  /* WPA supplicant */
  rc = AddOS2Program('WPA supplicant',, '/k wpasuppl.cmd %primary_nic%', '!:\os2\cmd.exe')
  ADDRESS cmd 'sleep 4'
  /* ISC DHCP client */
  rc = AddOS2Program('DHCP client',, '/k dhcli.cmd %primary_nic%', '!:\os2\cmd.exe')
end

/* TVFS */
rc = AddOS2Program('TVFS Control Program',, '/k tvfsrest.cmd', '!:\os2\cmd.exe')
/* FC/2 */
rc = AddOS2Program('File Commander/2', '!:\tools\fc2',, 'fc.exe')
/* DN/2 */
rc = AddOS2Program('Dos Navigator/2', '!:\tools\dn',, 'dn.exe')
/* Links */
rc = AddOS2Program('Links web browser',,, 'links.exe')
/* MiniTerm */
rc = AddOS2Program('MiniTerm', '!:\tools\miniterm',, 'term.exe')
/* pci.exe */
rc = AddOS2Program('PCI sniffer', '!:\tools\pci',, 'pci.exe')
/* DFSee */ 
rc = AddOS2Program('DFSee 9.15', '!:\tools\dfsee915',, 'dfsos2.exe')

/* is configured for DOS? */
if QueryDOSCapable() then do
   /* Add DOS program;
      arguments: title, startup dir, parameters, settings stem */

   drop settings

   settings.0 = "DPMI_DOS_API=ENABLED"
   settings.1 = "DPMI_MEMORY_LIMIT=8"

   rc = AddDOSProgram('Volkov Comander', '!:\tools\vc', '/C vc.com', 'settings' )
   rc = AddDOSProgram('FreeGEM', '!:\', '/C gem.bat', 'settings' )
   rc = AddDOSProgram('DOS DPMI',,, 'settings')
   rc = AddDOSProgram('AXE', '!:\tools\vc', '/C axe.com', 'settings' )

   drop settings

   settings.0 = "KBD_ALTHOME_BYPASS=1"
   settings.1 = "KBD_CTRL_BYPASS=CTRL_ESC"
   settings.2 = "VIDEO_SWITCH_NOTIFICATION=1"
   settings.3 = "SET VIDEO_8514A_XGA_IOTRAP=0"
   settings.4 = "DPMI_DOS_API=ENABLED"
   settings.5 = "DPMI_MEMORY_LIMIT=64"
   settings.6 = "WIN_DDE=0"   
   settings.7 = "WIN_CLIPBOARD=1"
   settings.8 = "DOS_DEVICE=@:\tcpip\bin\vdostcp.sys"

   rc = AddDOSProgram('WinOS/2 fullscreen', '#:\os2\mdos\winos2', '/C win.com', 'settings' )
end

/* add shutdown option. arguments: title, completion msg */
rc = AddShutdown( "Shutdown", "Shutdown Complete" )

/* make text white on blue; 0=black; 1=blue; 2=green; 3=cyan; 4=red;
   5=pink; 6=orange; 7=white */
rc = SetForegroundColor( 2 )
rc = SetBackgroundColor( 0 )

return 0
