/* REXX */

parse arg isodir .

/* Get some env vars values */
bootdrv = delstr(value('BOOTDRV',, 'OS2ENVIRONMENT'), 3)
sysdrv  = delstr(value('SYSDRV',, 'OS2ENVIRONMENT'), 3)
rsrv    = delstr(value('RSRV',, 'OS2ENVIRONMENT'), 3)

/* Get eCS distros list */
call SysFileTree isodir || '\ecs*', 'edist', 'DO'

say 'Available distros list:'

do i = 1 to edist.0
  say i || ') ' || edist.i
end

/*
say '1) eCS 2.1 GA'
say '2) eCS 2.2 beta 2'
 */

call charout stdout, 'Enter the dist number: '

/*
edist.0 = 2
edist.1 = 'data\isoimg\ecs21'
edist.2 = 'data\isoimg\ecs22b2'
 */

pull num

if num = 0 | num > edist.0 then
  num = edist.0

edist = edist.num

p = pos('\', edist)
if p > 0 then edist = substr(edist, p + 1)

edist2 = edist
p = pos('\', edist2)

/* change '\' to '\\' */
do until p = 0
  edist2 = insert('\', edist2, p)
  p = pos('\', edist2, p + 2)
end

call value 'EDIST',  edist,  'OS2ENVIRONMENT'
call value 'EDIST2', edist2, 'OS2ENVIRONMENT'

call charout stdout, 'Please enter the source drive (LVM drive letter): '
pull drv 
call value 'SRCDRV2', drv, 'OS2ENVIRONMENT'

drv = delstr(rsrv, 2)
call value 'SRCDRV', drv, 'OS2ENVIRONMENT'
call value 'RESERVEDRIVE', drv, 'OS2ENVIRONMENT'

call charout stdout, 'Please enter the destination drive (LVM drive letter): '
pull drv

drv = delstr(drv, 2)
call value 'INSTDRV', drv, 'OS2ENVIRONMENT'
call value 'DPF_INSTDRIVE', drv, 'OS2ENVIRONMENT'

/*
drv = delstr(sysdrv, 2)
call value 'SRCDRV', drv, 'OS2ENVIRONMENT'
 */

drv = delstr(bootdrv, 2)
call value 'MEMDRIVE', drv, 'OS2ENVIRONMENT'

exit 0
