/*\
/|\ REXX -- the best scripting language !
<|> This script is taken from Xpmfb Dive X Server distribution
\|/ Slightly modified by Valery Sedletski (aka Valerius), July 1 2001.
\*/

/* Major rewrite: Jan 8 2005, by valerius (r)                       */

/*
    Kills all processes with the names listed in cmd line.
    Syntax: killall prgname1[.suf1] [prgname2[.suf2] [prgname3[.suf3] [[...]]]
*/

delay = 0 /* 0 seconds */
suffixes = '.EXE .COM .EPPLET'


parse upper arg tokill

if RxFuncQuery('SysSleep') then do
  say 'Loading SysSleep function...'
  call RxFuncAdd 'SysSleep', 'rexxutil', 'SysSleep'
end

/* -----================---- */

call names2pids tokill

do i = 1 to pids.0
  do j = 1 to pids.i.0
    pid = pids.i.j
    say 'Killing PID: 'X2D(pid)'...'
    rc = kill(pid)
  end
end


call names2pids tokill

l = 0
do i = 1 to pids.0
  if pids.i.0 > 0 then do
    do j = 1 to pids.i.0
      pid = pids.i.j
      say 'A process with PID: 'X2D(pid)' didn''t killed...'
      l = l + 1
    end
  end
end

drop pids.

if l > 0 then do
  say l' processes didn''t killed'
  exit l
end; else do
  say 'All processses killed successfully'
end


exit 0

/* -----================---- */

names2pids: procedure expose pids. suffixes
parse arg tokill


drop pids.

do while queued() > 0
   parse pull .
end

'@pstat /C | rxqueue'

do i = 1 to 6
   if queued() > 0 then
      parse pull .
end

pids.0 = words(tokill)
l = 0
do j = 1 to pids.0
  pids.j.0 = 0
end

do while queued() > 0
  parse upper pull number . . name .
  do i = 1 to words(tokill)
    item = word(tokill, i)
    do k = 0 to words(suffixes)
      if k = 0 then suff = ''
      else suff = word(suffixes, k)
      itemtokill = item || suff;
      if Right(name, Length(itemtokill)) == itemtokill then do
        pids.i.0 = pids.i.0 + 1
        l = pids.i.0
        pids.i.l = number
        say 'process found, PID is: 'X2D(number)
      end
    end   /*   do 3   */
  end     /*   do 2   */
end       /*   do 1   */

return 0

/* -----================---- */

kill: procedure expose delay
parse arg number
  number = X2D(number)
  rc = kill4(number);
  call SysSleep delay
  rc = kill9(number);

return rc

/* -----================---- */

kill4: procedure
parse arg number
  '@kill -4 'number' 2>&1 >\dev\nul'

return rc

/* -----================---- */

kill9: procedure
parse arg number
  '@kill -9 'number' 2>&1 >\dev\nul'

return rc

/* -----================---- */
