/* Find md5 sums */

'@echo off'

/* Get whole tree in the current dir */
call SysFileTree '.\*', 'files', 'FSO'
/* Get the current dir               */
curdir = directory()

do i = 1 to files.0
  file = files.i
  
  /* convert '\\' to '\' */
  file = single_slash(file)
  
  /* convert absolute path to relative one */
  parse value file with (curdir) '\' file

  /* skip checksum files */
  if file = 'md5sums' then iterate
  if file = 'checksum.md5' then iterate

  /* find md5 sum */
  'md5sum ' || file || ' | rxqueue'
  parse pull line
  line = single_slash(line)
  p = pos('\', line)
  if p = 1 then line = delstr(line, 1, 1)
  call lineout stdout, line
end

exit 0
/* --------------------------------------- */
single_slash: procedure
file = arg(1)

p = 1

/* '\\' -> '\' */
do while p > 0
  p = pos('\\', file)
  
  if p > 0 then
    file = delstr(file, p, 1)
end

return file
/* --------------------------------------- */
