/* create desktop */

env.bootdrv = value('BOOTDRV',, 'OS2ENVIRONMENT')
env.sysdrv =  value('SYSDRV',, 'OS2ENVIRONMENT')

env.lang  = value('LANG',, 'OS2ENVIRONMENT')
env.mouse = value('MOUSE',, 'OS2ENVIRONMENT')
env.mmos2 = value('MMOS2',, 'OS2ENVIRONMENT')
env.video = value('VIDEO',, 'OS2ENVIRONMENT')
env.mode  = value('MODE',, 'OS2ENVIRONMENT')
env.opt   = value('OPT',, 'OS2ENVIRONMENT')

env.scrwidth  = value('SCRWIDTH',, 'OS2ENVIRONMENT')
env.scrheight = value('SCRHEIGHT',, 'OS2ENVIRONMENT')
env.scrdepth  = value('SCRDEPTH',, 'OS2ENVIRONMENT')

env.sedfile = env.bootdrv ||'\var\tmp\paths.sed'
env.cfg     = env.sysdrv  ||'\tools\rc.cfg'

env.crlf    = '0d 0a'x

/* read cfg file     */
call stream env.cfg,  'c',  'open read'

/* apply .cfg file */
do while lines(env.cfg) > 0
  line = linein(env.cfg)
  interpret(line)
end

call stream env.cfg,  'c',  'close'

call directory env.bootdrv ||'\tools\rc'

env.ini = env.bootdrv ||'\var\etc\os2.ini'

rclist = ''

do i = 1 to rclist.0
   rclist = rclist || ' ' || rclist.i
end

rcs = env.lang ||'\ini.rc fonts.rc video.rc '

call mkini rcs

if env.opt = 'cmd'
  then signal vmode

rcs = ''

if env.mouse = 'amouse' 
  then rcs = 'amouse.rc '

if env.opt = 'xwp' 
  then rcs = rcs || env.lang ||'\xwp.rc '
  else rcs = rcs || env.lang ||'\scenter.rc '

if env.mmos2 = 'yes' 
  then rcs = rcs ||'mmos2.rc '

rcs = rcs ||'wcat.rc cadh.rc dt.rc dtopt.rc snap.rc '

if env.video = 'panorama' 
  then rcs = rcs ||'panorama.rc '

/* add rc's list from rc.cfg */
rcs = rcs || rclist

call mkini rcs

env.ini = env.bootdrv ||'\var\etc\os2sys.ini'
rcs = 'inisys.rc'

call mkini rcs

env.ini = env.bootdrv ||'\mmos2\mmpm.ini'
if env.mmos2 = 'yes' 
  then rcs = 'sounds.rc'

call mkini rcs

env.ini = env.bootdrv ||'\os2\apps\klondike.ini'
rcs = 'klondike.rc'

call mkini rcs  

env.ini = env.bootdrv ||'\os2\apps\mahjongg.ini'
rcs = 'mahjongg.rc'

call mkini rcs  

say 'Fixing the drv. letter in chess.ini...'
call chessini

vmode: say 'Setting the display resolution... '

env.ini = env.bootdrv ||'\var\etc\os2.ini'

'if exist ' || env.ini ||' attrib -s -r -h '|| env.ini ||' 2>&1 >\dev\nul'
'screenrs ' || env.ini ||' '|| env.scrwidth ||' '|| env.scrheight ||' '|| env.scrdepth
'if exist ' || env.ini ||' attrib +s +r +h '|| env.ini ||' 2>&1 >\dev\nul'

exit
/* ========================================== */
mkini: procedure expose env. rc.
rcs = arg(1)

newrcs = ''

/* delete unneeded .rc's from the list,
   according to rc.cfg                 */
do while words(rcs) > 0
  parse var rcs rcfile rcs

  fn = rcfile
  p = lastpos('\', fn)
  /* delete path               */
  if p > 0 then fn = substr(fn, p + 1)
  p = lastpos('.rc', fn)
  /* delete an '.rc' extension */
  if p > 0 then fn = delstr(fn, p)

  /* get variable value        */
  fn = value('rc.' || fn)

  p = lastpos('.rc', rcfile)
  
  if p > 0 then 
    file = delstr(rcfile, p)
  else
    file = rcfile

  if fn = 'yes' then /* add it to the new list */
    newrcs = newrcs ||' '|| file || '.rc'
end

/* nothing to do */
if newrcs = '' then return

say 'Building '|| env.ini ||'... '

'if exist '|| env.ini ||' attrib -s -r -h '|| env.ini ||' 2>&1 >\dev\nul'

'xmakeini '|| env.ini ||' -s '|| env.sedfile ||' '|| newrcs

/* check error code */
if rc = 0 then do
  /* succeeded */
  call charout, ' ok' || env.crlf
end; else do
  /* failed    */
  call charout, ' fail, rc = '|| rc || env.crlf
  'sleep 3'
end

'if exist '|| env.ini ||' attrib +s +r +h '|| env.ini ||' 2>&1 >\dev\nul'

return
/* ========================================== */
