/* rexx */

parse arg args

command = getarg()

say command

/* Letters for flash disks and floppies */
flash_letters = 'I: O:'
args = translate(args, '/', '\')

que    = RxQueue('CREATE', 'mthelper_que')

args1 = ''
do while args \= ''
  opt = '"' || strip_letter(getarg()) || '"'
  args1 = args1 || ' ' || opt
end

oldque = RxQueue('SET', que)

command || ' ' || args1

if command = 'mcopy' then
do while queued() > 0
  parse pull from '|' to
  if from \= to then
    '@move "' || from || '" "' || to || '" 2>&1 >\dev\nul'
end

call RxQueue 'SET', oldque
call RxQueue 'DELETE', que


exit 0
/* -------------------------------------- */
strip_letter: procedure expose flash_letters que args command
opt = arg(1)

do i = 1 to 26
  q = lastpos('/', opt)
  letter = d2c(65 + i) || ':'
  p = pos(letter, translate(opt))
  if p = 1 then do
    if pos(letter, flash_letters) > 0 &,
       command = 'mcopy'
    then do
      long  = substr(short2long(opt), q + 1)
      short = substr(opt, q + 1)
      oldque = RxQueue('SET', que)
      push short || '|' || long
      que = RxQueue('SET', oldque)
      leave i
    end
    else do
      if p = 1 then
        opt = delstr(opt, p, length(letter))
      if args \= '' then do
        /* We're copying from hard disk to flash */
        if q > 0 & command = 'mcopy' then do
          opt1   = translate(opt, '5f'x, '20'x)
          opt1   = substr(opt1, q - 1)
          oldque = RxQueue('SET', que)
          push opt1 || '|' || opt
          que    = RxQueue('SET', oldque)
          if opt \= opt1 then
            '@move "' || opt || '" "' || opt1 || '" 2>&1 >\dev\nul'
          opt    = opt1
        end
      end
    end
  end
end

p = 1
do while p > 0
  p = pos('//', opt)
  if p <= 0 then leave
  opt = delstr(opt, p, 1)
end


return opt
/* -------------------------------------- */
short2long: procedure
parse arg short

do queued()
  pull .
end

p = lastpos('/', short)

if p > 0 then
  dir = delstr(short, p)
else
  dir = '.'

short = substr(short, p + 1)

if short = '' then
  return dir || '/'

'mdir 'dir' | rxqueue'

do 6
  pull .
end

n = queued()

ret = ''
do n - 2
  parse pull line
  ln = substr(line, 43)
  sh = substr(line, 1,  8) ||,
        '.' ||,
        substr(line, 10, 3)
  if ln = '' then ln = sh
  if translate(short) = translate(sh) then do
     long  = ln
     ret = dir || '/' || long
  end
  else
    iterate
end

do 2
  pull .
end


return ret
/* -------------------------------------- */
getarg: procedure expose args

/* Gets one word, or a line, enclosed
   in quotes, from args               */

args = strip(args)

if pos('"', args) == 1 then
  parse value args with '"' opt '"' args
else
  parse var args opt args


return opt
/* -------------------------------------- */
