unit OS2Ini;

{
  Low Level OS/2 .ini files support.
  (c) 2002 by madded2.

  This is a binary .INI file description.
  All pointers are absolute positions in file.
}


interface

const
   cSignature = $ffffffff;
   cVersion   = $14;

type
   { INI len type }
   INI_length = array[0..1] of SmallWord; { Length always specified twice ;) }

   { INI file header structure }
   INI_Header = record
      Signature 		       :  Longint; { always $ffffffff }
      Version			       :  Longint; { always $14 }
      FileSize			       :  Longint; { total file size }
      Reserved1,Reserved2	       :  Longint; { always 0 }
   end;

   { INI application structure }
   INI_Application = record
      NextApp			       :  Longint; { pointer to next App }
      KeyData			       :  Longint; { pointer to Key data }
      Reserved			       :  Longint; { always 0 }
      AppLen			       :  INI_length; { size of AppName }
      AppName			       :  Longint; { pointer to AppName }
   end;

   { INI key structure }
   INI_Key = record
      NextKey			       :  Longint; { pointer to next Key }
      Reserved			       :  Longint; { always 0 }
      KeyLen			       :  INI_length; { size of KeyName }
      KeyName			       :  Longint; { pointer to KeyName }
      ValLen			       :  INI_length; { size of KeyValue }
      Value			       :  Longint; { pointer to KeyValue }
   end;


implementation




end.



