/* rexx */

parse arg args

call ParseCmdLine args

indent = '    '

q = (infile = '')

if \q then q = (stream(infile, 'c', 'query exists') \= '')

if q then do

  if infile \= '' then
    ret = stream(infile, 'c', 'open read')

  /* Output file name as folder (container for all urls) */
  call OutFolder infile

  do while lines(infile)
    line = linein(infile)
    line = strip(line)
    call processLine line
  end

  if infile \= '' then
    ret = stream(infile, 'c', 'close')

end
else do
  call lineout 'stderr', 'file 'infile' doesn''t exist!'
  exit -255
end


exit 0
/* --------------=================--------------- */
ParseCmdLine: procedure expose infile
args = arg(1)

infile = args


return
/* --------------=================--------------- */
OutFolder: procedure
fname = arg(1)

l = length(fname)

/* l times a tilde */
tildes = ''
do l
  tildes = tildes'~'
end

say fname
say tildes


return
/* --------------=================--------------- */
OutUrl: procedure expose indent
url = arg(1)

do 2
  say indent || url
end


return
/* --------------=================--------------- */
processLine: procedure expose indent
line = arg(1)

call OutUrl line
say ''


return
/* --------------=================--------------- */
