/* Create SciTech Display Doctor Desktop objects */
/*******************************************************/
/* Before running, SET LANG= to the correct language.  */
/* It may already be correctly set in your CONFIG.SYS. */
/* For examples:                                       */
/* SET LANG=ar_AA for Arabic                           */
/* SET LANG=pt_BR for Brazil                           */
/* SET LANG=zh_CN for Simplified Chinese               */
/* SET LANG=de_DE for Germany                          */
/* SET LANG=da_DK for Denmark                          */
/* SET LANG=es_ES for Spain                            */
/* SET LANG=el_GR for Greece                           */
/* SET LANG=fi_FI for Finland                          */
/* SET LANG=fr_FR for France                           */
/* SET LANG=iw_IL for Israel                           */
/* SET LANG=it_IT for Italy                            */
/* SET LANG=ja_JP for Japan                            */
/* SET LANG=ko_KR for Korea                            */
/* SET LANG=nl_NL for Netherlands                      */
/* SET LANG=no_NO for Norway                           */
/* SET LANG=ru_RU for Russia                           */
/* SET LANG=sv_SE for Sweden                           */
/* SET LANG=zh_TW for Taiwan                           */
/* SET LANG=en_US for English (default)                */
/*******************************************************/

/******************************************
* Define MRI strings here
*******************************************/

  MRI_PARAMETERS_GAMON             = 'ࠬ  GAMON (-h  ࠢ)'
  MRI_TITLE_CONFIGURATION_PROGRAM  = 'ணࠬ^䨣஢'
  MRI_TITLE_HARDWARE_REPORT        = ' ^㤮'
  MRI_TITLE_MONITOR_UTILITY        = '롮 '
  MRI_TITLE_SCITECH_FOLDER_NAME    = 'SciTech SNAP^Graphics/se'
  MRI_TITLE_SCITECH_MARKETPLACE    = 'SciTech Web Site'
  MRI_TITLE_UNINSTALL              = ' SNAP'

/******************************************
* Define message ids from *mid*.h
*******************************************/

  MSG_CANNOT_MAKE            =   82
  MSG_INSTALL_UNSUCCESSFUL   = 1975



/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* get current directory - Where SNAP utilities are installed */
bootDrive = SysBootDrive()
if bootDrive = '' then exit
snapdir=bootDrive || '\snap'

CreateObjects:

/* Create the Scitech folder on Desktop */
Class='WPFolder'
Location='<WP_DESKTOP>'
ObjectID='<SCITECH_DESKTOP>'
Title=MRI_TITLE_SCITECH_FOLDER_NAME
SETUP='ICONVIEWPOS=16 44 56 23;ALWAYSSORT=YES;OPEN=NO;DISABLETOOLBAR=1;'

Call MakeObject

/* All other objects created in Scitech folder */
Location='<SCITECH_DESKTOP>'

/* Create Shadows */
Class='WPShadow'

Title='⥬'
ObjectID='<SCITECH_SYSTEM>'
SETUP='SHADOWID=<WP_SYSTEM>;'
Call MakeObject

Title='readme.txt'
ObjectID='<SCITECH_README>'
SETUP='SHADOWID='snapdir'\readme.txt'
Call MakeObject

Title='snapos2.pdf'
ObjectID='<SCITECH_MANUAL>'
SETUP='SHADOWID='snapdir'\snapos2.pdf'

/* Make URLs */
Class='WPUrl'

Title=MRI_TITLE_SCITECH_MARKETPLACE
ObjectID='<SCITECH_MARKET>'
SETUP='URL=https://store.scitechsoft.com/'
Call MakeObject

/* Make Programs */
Class='WPProgram'

Title=MRI_TITLE_MONITOR_UTILITY
ObjectID='<SCITECH_GAMON>'
SETUP='EXENAME=CMD.EXE;'||,
      'STARTUPDIR='snapdir';'||,
      'PARAMETERS=/c (GAMON.EXE [' || MRI_PARAMETERS_GAMON || '] ' ||,
                  '> gamon.out & e.exe gamon.out );'||,
      'PROGTYPE=WINDOWABLEVIO;'
Call MakeObject

Title=MRI_TITLE_CONFIGURATION_PROGRAM
ObjectID='<SCITECH_GACTRL>'
SETUP='EXENAME='snapdir'\GACTRL.EXE;'||,
      'STARTUPDIR='snapdir';'||,
      'PROGTYPE=FULLSCREEN;'
Call MakeObject

Title=MRI_TITLE_HARDWARE_REPORT
ObjectID='<SCITECH_REPORT>'
SETUP='EXENAME=cmd.exe;'||,
      'STARTUPDIR='snapdir';'||,
      'PARAMETERS=/c (GAREPORT.EXE > gareport.out & start /f e.exe gareport.out);'||,
      'PROGTYPE=FULLSCREEN;'
Call MakeObject

Title=MRI_TITLE_UNINSTALL
ObjectID='<SCITECH_UNINSTAL>'
SETUP='EXENAME='snapdir'\UNINSTAL.EXE;'||,
      'STARTUPDIR='snapdir';'||,
      'PROGTYPE=PM;'||,
      'NOAUTOCLOSE=YES;'
Call MakeObject

exit

/******************************************************
* Make a Work Place Shell object
*******************************************************/

MakeObject:
  if SysCreateObject(Class,Title,Location,'OBJECTID='ObjectID';'||,
                     'TITLE='title';'SETUP,'U')<>1,
  then Say Title || ' ' || MyGetMsg(SysGetMessage(MSG_CANNOT_MAKE))
  return

/******************************************************
* Remove SYSXXXX: from messages
*******************************************************/

MyGetMsg: Procedure

  parse arg message
  if pos('SYS', word(message, 1)) == 1
    then parse arg . message
  return message
