/* rexx */

'@echo off'

call RxFuncAdd 'syssleep', 'rexxutil', 'syssleep'
call RxFuncAdd 'sysini',   'rexxutil', 'sysini'

network = value('NETWORK',, 'OS2ENVIRONMENT')
bootdrv = VALUE('BOOTDRV',, 'OS2ENVIRONMENT')
sysdrv  = VALUE('SYSDRV',, 'OS2ENVIRONMENT')

mode = VALUE('MODE',, 'OS2ENVIRONMENT')
psd  = VALUE('ACPI',, 'OS2ENVIRONMENT')
vbox = VALUE('VBOX',, 'OS2ENVIRONMENT')
vpc  = VALUE('VPC',,  'OS2ENVIRONMENT')
wp   = VALUE('WP',,   'OS2ENVIRONMENT')

/* acpi daemon */
select
  when psd = 'pasha'
    then acpid = '!:\os2\boot\AcpiDaem.exe'
  when psd = 'azar'
    then acpid = '!:\os2\boot\AcpiDaaz.exe'
  otherwise acpid = ''
end

/* VPC additions daemon  */
if vpc  = 'yes'
  then 
    vpc = 'vmserv daemon'
  else 
    vpc = ''

/* VBox additions daemon */
if vbox = 'yes'
  then
    vbox = 'vboxsvc'
  else
    vbox=  ''

niced = ''

if mode = 'pm' then do
  /* Set VIO window font size */
  call sysini 'USER', 'Shield', 'fMaximize', '31'
  call sysini 'USER', 'Shield', '~Font Size...', '05 0c'x
  call sysini 'USER', 'Shield', 'sInitialShape', '87 00 7a 01 e8 01 50 00 4a 02 03 00 00 00 50 02 00 80'x
  /* Mouse pointers */
  path = '@:\os2\pointers\default\'

  sz = size(path || 'arrow.ptr')
  call sysini 'USER', 'PM_SysPointer', '1',  makedword(3)  ||,
                                             makedword(sz) ||,
                                             readfile(path || 'arrow.ptr')

  sz = size(path || 'illegal.ptr')
  call sysini 'USER', 'PM_SysPointer', '18', makedword(3)  ||,
                                             makedword(sz) ||,
                                             readfile(path || 'illegal.ptr')

  sz = size(path || 'text.ptr')
  call sysini 'USER', 'PM_SysPointer', '2',  makedword(3)  ||,
                                             makedword(sz) ||,
                                             readfile(path || 'text.ptr')

  sz = size(path || 'move.ptr')
  call sysini 'USER', 'PM_SysPointer', '3',  makedword(3)  ||,
                                             makedword(sz) ||,
                                             readfile(path || 'move.ptr')

  sz = size(path || 'wait.ptr')
  call sysini 'USER', 'PM_SysPointer', '5',  makedword(3)  ||,
                                             makedword(sz) ||,
                                             readfile(path || 'wait.ptr')

  sz = size(path || 'sizenwse.ptr')
  call sysini 'USER', 'PM_SysPointer', '6',  makedword(3)  ||,
                                             makedword(sz) ||,
                                             readfile(path || 'sizenwse.ptr')

  sz = size(path || 'sizenesw.ptr')
  call sysini 'USER', 'PM_SysPointer', '7',  makedword(3)  ||,
                                             makedword(sz) ||,
                                             readfile(path || 'sizenesw.ptr')

  sz = size(path || 'sizewe.ptr')
  call sysini 'USER', 'PM_SysPointer', '8',  makedword(3)  ||,
                                             makedword(sz) ||,
                                             readfile(path || 'sizewe.ptr')

  sz = size(path || 'sizens.ptr')
  call sysini 'USER', 'PM_SysPointer', '9',  makedword(3)  ||,
                                             makedword(sz) ||,
                                             readfile(path || 'sizens.ptr')
  /* AMouse */
  call sysini 'USER', 'AMouse', 'AButtonMode', '04 00 00 00 00 00 00 00'x
  call sysini 'USER', 'AMouse', 'Applications', ''x
  call sysini 'USER', 'AMouse', 'ButtonMode',  '04 0d 0e 0b 0a 00 00 00'x
  call sysini 'USER', 'AMouse', 'CButtonMode', '04 00 00 00 00 00 00 00'x
  /* XPager etc.  */
  call xwphook
  /* lSwitcher    */
  call lswitch
  /* Window List  */
  call winlist
  /* Nice/2       */
  niced = 'niced -start' 
  /* Folders positions (just attempts, still non-working) */
  call sysini 'USER', 'PM_Workplace:FolderPos', '185397@20',,
      '6a 7b 0f 10 00 00 24 01 a9 00 c0 01 ae 01 01 00 00 00 24 01 a9'x,
      '00 c0 01 ae 01 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 6b 00 00 00 00 00 00 00 01 00 00 00 08 80 59 00 00 00 47 00 00 00 04'x,
      '00 00 00 ce cf ce 00 49 00 00 00 04 00 00 00 ce cf ce 00 46 00 00 00 04 00 00'x,
      '00 00 00 00 00 48 00 00 00 04 00 00 00 00 00 00 00 45 00 00 00 04 00 00 00 ce'x,
      'cf ce 00 0f 00 00 00 0b 00 00 00 39 2e 57 61 72 70 53 61 6e 73 00 11 00 00 00'x,
      '02 00 00 00 02 00 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '207315@10',,
      '6a 7b 0f 10 00 00 ec 00 27 02 01 03 c7 00 01 00 00 00 ec 00 27'x,
      '02 01 03 c7 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '202377@10',,
      '6a 7b 0f 10 00 00 bc 00 3d 00 33 03 c3 00 01 00 00 00 bc 00 3d'x,
      '00 33 03 c3 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '214303@10',,
      '6a 7b 0f 10 00 00 94 00 10 01 33 03 7c 00 01 00 00 00 94 00 10'x,
      '01 33 03 7c 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '255419@10',,
      '6a 7b 0f 10 00 00 94 00 72 02 a5 01 86 00 01 00 00 00 94 00 72'x,
      '02 a5 01 86 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '251049@10',,
      '6a 7b 0f 10 00 00 9c 00 fd 00 33 03 d2 00 01 00 00 00 9c 00 fd'x,
      '00 33 03 d2 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '243561@10',,
      '6a 7b 0f 10 00 00 bc 00 df 01 a3 02 9d 00 01 00 00 00 bc 00 df'x,
      '01 a3 02 9d 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '213720@10',,
      '6a 7b 0f 10 00 00 64 00 d1 01 13 01 95 00 01 00 00 00 64 00 d1'x,
      '01 13 01 95 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '205690@10',,
      '6a 7b 0f 10 00 00 5c 01 6a 00 5c 02 83 00 01 00 00 00 5c 01 6a'x,
      '00 5c 02 83 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '212903@10',,
      '6a 7b 0f 10 00 00 44 01 6d 01 c0 01 92 00 01 00 00 00 44 01 6d'x,
      '01 c0 01 92 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '224868@10',,
      '6a 7b 0f 10 00 00 0c 01 b5 00 56 02 8c 00 01 00 00 00 0c 01 b5'x,
      '00 56 02 8c 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '215408@10',,
      '6a 7b 0f 10 00 00 94 00 21 02 54 02 a7 00 01 00 00 00 94 00 21'x,
      '02 54 02 a7 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '254080@10',,
      '6a 7b 0f 10 00 00 3c 01 9e 00 96 02 eb 00 01 00 00 00 3c 01 9e'x,
      '00 96 02 eb 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
  call sysini 'USER', 'PM_Workplace:FolderPos', '200029@10',,
      '6a 7b 0f 10 00 00 94 00 0f 02 1c 02 89 00 01 00 00 00 94 00 0f'x,
      '02 1c 02 89 00 01 00 00 00 ff ff 00 00 00 04 00 00 00 03 00 00 ff ff ff ff ff'x,
      'ff ff ff 5a 00 00 00 00 00 00 00 01 00 00 00 08 80 48 00 00 00 02 00 00 00 04'x,
      '00 00 00 ef ff ff ff 04 00 00 00 04 00 00 00 ec ff ff ff 06 00 00 00 04 00 00'x,
      '00 df ff ff ff 08 00 00 00 04 00 00 00 e0 ff ff ff 0e 00 00 00 04 00 00 00 ed'x,
      'ff ff ff 31 00 00 00 04 00 00 00 01 ff ff ff 00 00 00 00'x
end

/* daemons list */
dl.0 = 2
dl.1 = acpid
dl.2 = '!:\tools\bin\usbmntd.exe'

if vpc \= '' then do
  dl.3 = vpc
  dl.0 = dl.0 + 1
end

/* detach daemons */
do i = 1 to dl.0
  if dl.i \= '' then
    'detach ' || dl.i

  sleep 1
end

if niced \= '' then niced

if vbox  \= '' then 'start /n ' || vbox

/* Set up TShell */
if mode = 'tshell' then do
  '!:\os2\pgmshell.exe @:\tshell.cmd'
end

if mode = 'pm' then
  sw = '/b /min /win'
else
  sw = '/b /fs'

/* start tvfs control program */
/* if wp \= 'ecsinst' then do */
  'start "TVFS Control Program" '|| sw ||' /k tvctl -Dt'
  'sleep 3'
  'tvrestor'
/* end */
  
if network \= 'none' then do
  /* WPA supplicant */
  'start "WPA supplicant" '|| sw ||' /k wpasuppl.cmd %primary_nic%'
  'sleep 4'
  /* ISC DHCP client */
  'start "DHCP client" '|| sw ||' /k dhcli.cmd %primary_nic%'
end

/* Start FC/2 */
'start "File Commander" '|| sw ||' /k @:\tools\fc2\fc.exe'

/* create NDFS drive and mountpoint */
if stream('!:\apps\netdrive\ndfs32.ifs', 'c', 'query exists') \= '' then do
  'nd attach w:'
  'nd createmp w:\iso'
end

'exit'
/*======================================*/
readfile: procedure
file = arg(1)

call stream file,  'c',  'open read'
buf = charin(file,  1,  size(file))
call stream file,  'c',  'close'

return buf
/*======================================*/
rev: procedure
n = arg(1)

/*
 *   Reverse byte order for little endian
 */
 l = length(n)

 if l // 2 == 1 then do
   n = '0' || n
   l = l + 1
 end

 m = l / 2

 q = ''
 do p = 0 to m - 1
   s = substr(n, 2*p + 1, 2)
   q = s || q
 end


return q
/*======================================*/
pad: procedure
/*
 *   Pad a hex number by zeroes from left
 */
s = arg(1)
n = arg(2)


if n = '' then n = 4

if length(s) > 2*n then return s

do while length(s) < 2*n
  s = '0' || s
end


return s
/*======================================*/
size: procedure:

return stream(arg(1), 'c', 'query size')
/*======================================*/
makedword: procedure

return x2c(rev(pad(d2x(arg(1)))))
/*======================================*/
