/* Restore TVFS drive for eCS installation */

'@echo off'

tvdrv  = '@reservedrive@:'
srcdrv = '@srcdrv@:'
edist  = '@edist@'
dist   = srcdrv || '\' || edist

/* Load the Tvfs REXX interface. */
rc = RxFuncAdd('TvLoadFuncs', 'TVRX', 'TvLoadFuncs');
if (rc <> 0) then call shutdown;
rc = TvLoadFuncs();
if (rc <> 0) then call shutdown;

/* Restore the Tvfs drives. */
rc = TvUmount("*");
rc = TvMount("-c0 "|| tvdrv);
if (rc <> 0) then call shutdown;

/* Set the volume label */
'echo ECS_CDRUN | label '|| tvdrv ||' >nul'

files = '\ecs\bin \ecs\boot \ecs\install \ecs\install\warpin',
        '\cid\exe\os2 \cid\exe\mpts \cid\locinstu \os2image\disk_6'
        
mp    = tvdrv || '\bin'

do i = 1 to words(files)
  file = word(files, i)
  rc = TvLink("-drwnt "|| mp ||" "|| dist ||"\"|| file);
  if rc \= 0 then call shutdown;
end

files = '\ecs\lang \ecs\boot \cid\locinstu'

mp = tvdrv || '\data'

do i = 1 to words(files)
  file = word(files, i)
  rc = TvLink("-drwnt "|| mp ||" "|| dist ||"\"|| file);
  if rc \= 0 then call shutdown;
end

files = '\ecs\dll \ecs\install \ecs\install\warpin \ecs\install\nls\en',
        '\os2image\disk_2 \cid\dll\os2 \cid\locinstu \os2image\disk_6'

mp = tvdrv || '\lib'

do i = 1 to words(files)
  file = word(files, i)
  rc = TvLink("-drwnt "|| mp ||" "|| dist ||"\"|| file);
  if rc \= 0 then call shutdown;
end

dirs = '\bootimgs \cid \diskimgs \ecs \info \language \mptn \os2image',
       '\psfonts \snap'
       
do i = 1 to words(dirs)
  dir = word(dirs, i)
  rc = TvLink("-drwnt "|| tvdrv || dir ||" "|| dist || dir);
  if rc \= 0 then call shutdown;
end

dir = '\os2'
rc = TvLink("-drwnt "|| tvdrv || dir ||" "|| srcdrv || dir);
if rc \= 0 then call shutdown;

extrafiles = 'md5sums check-cd.bat makedisk.bat check-cd.cmd',
             'makedisk.cmd startup.cmd checksum.md5 qckguide.pdf check-cd.sh',
             'biostips.txt faq.txt readme.txt regkey.txt whatsnew.txt finger.txt'

do i = 1 to words(extrafiles)
  file = word(extrafiles, i)
  f = dist || "\" || file
    
  if stream(f, 'c', 'query exists') \= '' then
      rc = TvLink("-frwnt " || tvdrv || "\" || file || " " || f);
  else
      iterate
      
  if rc \= 0 then call shutdown;
end

/* Unload the Tvfs REXX interface. */
rc = TvDropFuncs();
exit(0);

shutdown:
SAY "Error restoring TVFS drive."
call TvUmount("*");
call TvDropFuncs;
exit(16)
